/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.item.component.BlockDataComponent;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B#\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/component/BlockDataComponent;", "", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntityNbt", "Lnet/minecraft/nbt/CompoundTag;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/nbt/CompoundTag;)V", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "(Lnet/minecraft/core/HolderLookup$Provider;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntity;)V", "getBlockState", "()Lnet/minecraft/world/level/block/state/BlockState;", "getBlockEntityNbt", "()Lnet/minecraft/nbt/CompoundTag;", "tryPlace", "", "level", "Lnet/minecraft/world/level/Level;", "posToPlaceIn", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "irregular-implements-1.21.1"})
public final class BlockDataComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockState blockState;
    @Nullable
    private final CompoundTag blockEntityNbt;
    @NotNull
    private static final Codec<BlockDataComponent> CODEC;
    @NotNull
    private static final StreamCodec<ByteBuf, BlockDataComponent> STREAM_CODEC;

    public BlockDataComponent(@NotNull BlockState blockState, @Nullable CompoundTag blockEntityNbt) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        this.blockState = blockState;
        this.blockEntityNbt = blockEntityNbt;
    }

    @NotNull
    public final BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public final CompoundTag getBlockEntityNbt() {
        return this.blockEntityNbt;
    }

    public BlockDataComponent(@NotNull HolderLookup.Provider provider, @NotNull BlockState blockState, @Nullable BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        BlockEntity blockEntity2 = blockEntity;
        this(blockState, (CompoundTag)(blockEntity2 != null ? blockEntity2.saveWithFullMetadata(provider) : null));
    }

    public final boolean tryPlace(@NotNull Level level, @NotNull BlockPos posToPlaceIn, @Nullable Player player) {
        BlockState stateAlreadyThere;
        BlockState adjustedState;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)posToPlaceIn, (String)"posToPlaceIn");
                adjustedState = Block.updateFromNeighbourShapes((BlockState)this.blockState, (LevelAccessor)((LevelAccessor)level), (BlockPos)posToPlaceIn);
                stateAlreadyThere = level.getBlockState(posToPlaceIn);
                if (adjustedState.isAir() || !stateAlreadyThere.canBeReplaced()) break block11;
                Player player2 = player;
                if (level.isUnobstructed(adjustedState, posToPlaceIn, player2 == null ? CollisionContext.empty() : CollisionContext.of((Entity)((Entity)player2))) && adjustedState.canSurvive((LevelReader)level, posToPlaceIn)) break block12;
            }
            return false;
        }
        level.captureBlockSnapshots = true;
        level.setBlockAndUpdate(posToPlaceIn, adjustedState);
        level.captureBlockSnapshots = false;
        ArrayList arrayList = level.capturedBlockSnapshots;
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"capturedBlockSnapshots");
        List snapshots = CollectionsKt.toList((Iterable)arrayList);
        level.capturedBlockSnapshots.clear();
        BlockSnapshot blockSnapshot = (BlockSnapshot)CollectionsKt.firstOrNull((List)snapshots);
        if (blockSnapshot == null) {
            return false;
        }
        BlockSnapshot snapshot = blockSnapshot;
        if (((BlockEvent.EntityPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(snapshot, stateAlreadyThere, (Entity)player))).isCanceled()) {
            level.restoringBlockSnapshots = true;
            snapshot.restore(snapshot.getFlags() | 2);
            level.restoringBlockSnapshots = false;
            return false;
        }
        SoundType soundType = adjustedState.getBlock().getSoundType(adjustedState, (LevelReader)level, posToPlaceIn, (Entity)player);
        level.playSound(null, posToPlaceIn, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.volume + 1.0f) / 2.0f, soundType.pitch * 0.8f);
        if (this.blockEntityNbt != null) {
            this.blockEntityNbt.putInt("x", posToPlaceIn.getX());
            this.blockEntityNbt.putInt("y", posToPlaceIn.getY());
            this.blockEntityNbt.putInt("z", posToPlaceIn.getZ());
            BlockEntity blockEntity = level.getBlockEntity(posToPlaceIn);
            if (blockEntity != null) {
                blockEntity.loadWithComponents(this.blockEntityNbt, (HolderLookup.Provider)level.registryAccess());
            }
        }
        FluidState fluidState = level.getFluidState(posToPlaceIn);
        FluidType fluidType = fluidState.getFluidType();
        FluidStack fluidStack = new FluidStack(fluidState.getType(), 1000);
        BucketPickup fluidPickup = null;
        if (((Boolean)ServerConfig.Companion.getCONFIG().getBlockMoverTryVaporizeFluid().get()).booleanValue() && fluidType.isVaporizedOnPlacement(level, posToPlaceIn, fluidStack)) {
            Block adjustedStateBlock = adjustedState.getBlock();
            if (adjustedStateBlock instanceof BucketPickup) {
                fluidPickup = (BucketPickup)adjustedStateBlock;
            } else {
                return false;
            }
        }
        if (fluidPickup != null && !fluidPickup.pickupBlock(player, (LevelAccessor)level, posToPlaceIn, adjustedState).isEmpty()) {
            fluidType.onVaporize(null, level, posToPlaceIn, fluidStack);
        }
        return true;
    }

    @NotNull
    public final BlockState component1() {
        return this.blockState;
    }

    @Nullable
    public final CompoundTag component2() {
        return this.blockEntityNbt;
    }

    @NotNull
    public final BlockDataComponent copy(@NotNull BlockState blockState, @Nullable CompoundTag blockEntityNbt) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return new BlockDataComponent(blockState, blockEntityNbt);
    }

    public static /* synthetic */ BlockDataComponent copy$default(BlockDataComponent blockDataComponent, BlockState blockState, CompoundTag compoundTag, int n, Object object) {
        if ((n & 1) != 0) {
            blockState = blockDataComponent.blockState;
        }
        if ((n & 2) != 0) {
            compoundTag = blockDataComponent.blockEntityNbt;
        }
        return blockDataComponent.copy(blockState, compoundTag);
    }

    @NotNull
    public String toString() {
        return "BlockDataComponent(blockState=" + this.blockState + ", blockEntityNbt=" + this.blockEntityNbt + ")";
    }

    public int hashCode() {
        int result = this.blockState.hashCode();
        result = result * 31 + (this.blockEntityNbt == null ? 0 : this.blockEntityNbt.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BlockDataComponent)) {
            return false;
        }
        BlockDataComponent blockDataComponent = (BlockDataComponent)other;
        if (!Intrinsics.areEqual((Object)this.blockState, (Object)blockDataComponent.blockState)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.blockEntityNbt, (Object)blockDataComponent.blockEntityNbt);
    }

    private static final BlockState CODEC$lambda$2$lambda$0(KProperty1 $tmp0, BlockDataComponent p0) {
        return (BlockState)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final CompoundTag CODEC$lambda$2$lambda$1(KProperty1 $tmp0, BlockDataComponent p0) {
        return (CompoundTag)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$2(RecordCodecBuilder.Instance instance) {
        return instance.group((App)BlockState.CODEC.fieldOf("block_state").forGetter(arg_0 -> BlockDataComponent.CODEC$lambda$2$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)CompoundTag.CODEC.optionalFieldOf("block_entity_nbt", null).forGetter(arg_0 -> BlockDataComponent.CODEC$lambda$2$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, BlockDataComponent::new);
    }

    private static final BlockState STREAM_CODEC$lambda$3(KProperty1 $tmp0, BlockDataComponent p0) {
        return (BlockState)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional STREAM_CODEC$lambda$4(BlockDataComponent it) {
        return Optional.ofNullable(it.blockEntityNbt);
    }

    private static final BlockDataComponent STREAM_CODEC$lambda$5(BlockState state, Optional tag) {
        Intrinsics.checkNotNull((Object)state);
        return new BlockDataComponent(state, tag.orElse(null));
    }

    static {
        Codec codec = RecordCodecBuilder.create(BlockDataComponent::CODEC$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper((IdMap)((IdMap)Block.BLOCK_STATE_REGISTRY)), arg_0 -> BlockDataComponent.STREAM_CODEC$lambda$3((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.TRUSTED_COMPOUND_TAG), BlockDataComponent::STREAM_CODEC$lambda$4, BlockDataComponent::STREAM_CODEC$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/component/BlockDataComponent$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/aaronhowser/mods/irregular_implements/item/component/BlockDataComponent;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<BlockDataComponent> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StreamCodec<ByteBuf, BlockDataComponent> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

