/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.recipe.crafting;

import dev.aaronhowser.mods.irregular_implements.datagen.ModRecipeProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModItemTagsProvider;
import dev.aaronhowser.mods.irregular_implements.item.CustomCraftingTableBlockItem;
import dev.aaronhowser.mods.irregular_implements.registry.ModRecipeSerializers;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\f\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/crafting/CustomCraftingTableRecipe;", "Lnet/minecraft/world/item/crafting/CustomRecipe;", "craftingCategory", "Lnet/minecraft/world/item/crafting/CraftingBookCategory;", "<init>", "(Lnet/minecraft/world/item/crafting/CraftingBookCategory;)V", "matches", "", "input", "Lnet/minecraft/world/item/crafting/CraftingInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "", "height", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nCustomCraftingTableRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomCraftingTableRecipe.kt\ndev/aaronhowser/mods/irregular_implements/recipe/crafting/CustomCraftingTableRecipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1740#2,3:58\n*S KotlinDebug\n*F\n+ 1 CustomCraftingTableRecipe.kt\ndev/aaronhowser/mods/irregular_implements/recipe/crafting/CustomCraftingTableRecipe\n*L\n33#1:58,3\n*E\n"})
public final class CustomCraftingTableRecipe
extends CustomRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int CRAFTING_TABLE_SLOT = 4;
    @NotNull
    private static final Set<Integer> BASE_SLOTS = SetsKt.minus((Set)CollectionsKt.toSet((Iterable)((Iterable)new IntRange(0, 8))), (Object)4);
    @NotNull
    private static final Ingredient BASE_INGREDIENT = ModRecipeProvider.Companion.asIngredient(ModItemTagsProvider.Companion.getCUSTOM_CRAFTING_TABLE_ITEMS());

    public CustomCraftingTableRecipe(@NotNull CraftingBookCategory craftingCategory) {
        Intrinsics.checkNotNullParameter((Object)craftingCategory, (String)"craftingCategory");
        super(craftingCategory);
    }

    public /* synthetic */ CustomCraftingTableRecipe(CraftingBookCategory craftingBookCategory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            craftingBookCategory = CraftingBookCategory.MISC;
        }
        this(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        boolean bl;
        block6: {
            boolean plankStackValid;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (input.width() < 3 || input.height() < 3) {
                return false;
            }
            boolean centerIsCraftingTable = input.getItem(4).is(Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES);
            if (!centerIsCraftingTable) {
                return false;
            }
            ItemStack baseStack = input.getItem(((Number)CollectionsKt.first((Iterable)BASE_SLOTS)).intValue());
            boolean bl2 = plankStackValid = BASE_INGREDIENT.test(baseStack) && baseStack.getItem() instanceof BlockItem;
            if (!plankStackValid) {
                return false;
            }
            Iterable $this$all$iv = BASE_SLOTS;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (input.getItem(it).is(baseStack.getItem())) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack baseStack = input.getItem(((Number)CollectionsKt.first((Iterable)BASE_SLOTS)).intValue());
        Item item = baseStack.getItem();
        BlockItem blockItem = item instanceof BlockItem ? (BlockItem)item : null;
        if (blockItem == null || (blockItem = blockItem.getBlock()) == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        BlockItem baseBlock = blockItem;
        return CustomCraftingTableBlockItem.Companion.ofBlock((Block)baseBlock);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getCUSTOM_CRAFTING_TABLE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    public CustomCraftingTableRecipe() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/crafting/CustomCraftingTableRecipe$Companion;", "", "<init>", "()V", "CRAFTING_TABLE_SLOT", "", "BASE_SLOTS", "", "BASE_INGREDIENT", "Lnet/minecraft/world/item/crafting/Ingredient;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

