/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.CustomCraftingTableBlockEntity;
import dev.aaronhowser.mods.irregular_implements.item.CustomCraftingTableBlockItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0014J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0014J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J(\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J0\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006%"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/CustomCraftingTableBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getOcclusionShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "level", "Lnet/minecraft/world/level/BlockGetter;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getMenuProvider", "Lnet/minecraft/world/MenuProvider;", "getSoundType", "Lnet/minecraft/world/level/block/SoundType;", "Lnet/minecraft/world/level/LevelReader;", "entity", "Lnet/minecraft/world/entity/Entity;", "spawnDestroyParticles", "", "getCloneItemStack", "Lnet/minecraft/world/item/ItemStack;", "target", "Lnet/minecraft/world/phys/HitResult;", "irregular-implements-1.21.1"})
public final class CustomCraftingTableBlock
extends Block
implements EntityBlock {
    public CustomCraftingTableBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.CRAFTING_TABLE)));
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new CustomCraftingTableBlockEntity(pos, state);
    }

    @NotNull
    protected VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        VoxelShape voxelShape = Shapes.empty();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
        return voxelShape;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
        return InteractionResult.CONSUME;
    }

    @NotNull
    protected MenuProvider getMenuProvider(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return (MenuProvider)new SimpleMenuProvider((arg_0, arg_1, arg_2) -> CustomCraftingTableBlock.getMenuProvider$lambda$0(level, pos, arg_0, arg_1, arg_2), (Component)this.getName());
    }

    @NotNull
    public SoundType getSoundType(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        CustomCraftingTableBlockEntity customCraftingTableBlockEntity = blockEntity instanceof CustomCraftingTableBlockEntity ? (CustomCraftingTableBlockEntity)blockEntity : null;
        if (customCraftingTableBlockEntity == null) {
            SoundType soundType = super.getSoundType(state, level, pos, entity);
            Intrinsics.checkNotNullExpressionValue((Object)soundType, (String)"getSoundType(...)");
            return soundType;
        }
        CustomCraftingTableBlockEntity blockEntity2 = customCraftingTableBlockEntity;
        BlockState renderedState = blockEntity2.getRenderedBlockState();
        if (renderedState.is((Block)this)) {
            SoundType soundType = SoundType.WOOD;
            Intrinsics.checkNotNullExpressionValue((Object)soundType, (String)"WOOD");
            return soundType;
        }
        SoundType soundType = renderedState.getSoundType(level, pos, entity);
        Intrinsics.checkNotNullExpressionValue((Object)soundType, (String)"getSoundType(...)");
        return soundType;
    }

    protected void spawnDestroyParticles(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        CustomCraftingTableBlockEntity customCraftingTableBlockEntity = blockEntity instanceof CustomCraftingTableBlockEntity ? (CustomCraftingTableBlockEntity)blockEntity : null;
        if (customCraftingTableBlockEntity == null) {
            super.spawnDestroyParticles(level, player, pos, state);
            return;
        }
        CustomCraftingTableBlockEntity blockEntity2 = customCraftingTableBlockEntity;
        level.levelEvent(player, 2001, pos, Block.getId((BlockState)blockEntity2.getRenderedBlockState()));
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        CustomCraftingTableBlockEntity customCraftingTableBlockEntity = blockEntity instanceof CustomCraftingTableBlockEntity ? (CustomCraftingTableBlockEntity)blockEntity : null;
        if (customCraftingTableBlockEntity == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        CustomCraftingTableBlockEntity blockEntity2 = customCraftingTableBlockEntity;
        Block block = blockEntity2.getRenderedBlockState().getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        return CustomCraftingTableBlockItem.Companion.ofBlock(block);
    }

    private static final AbstractContainerMenu getMenuProvider$lambda$0(Level $level, BlockPos $pos, int containerId, Inventory playerInventory, Player player) {
        return (AbstractContainerMenu)new CraftingMenu(containerId, playerInventory, ContainerLevelAccess.create((Level)$level, (BlockPos)$pos));
    }
}

