/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import com.mojang.authlib.GameProfile;
import dev.aaronhowser.mods.irregular_implements.block.BlockBreakerBlock;
import dev.aaronhowser.mods.irregular_implements.datagen.datapack.ModEnchantments;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntities;
import dev.aaronhowser.mods.irregular_implements.util.BetterFakePlayerFactory;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u000256B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0019J(\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0019H\u0002J\u0016\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u00052\u0006\u0010$\u001a\u00020)J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020.H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00067"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockBreakerBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "uuid", "Ljava/util/UUID;", "isMining", "", "canMine", "miningProgress", "", "isFirstTick", "fakePlayer", "Ljava/lang/ref/WeakReference;", "Lnet/neoforged/neoforge/common/util/FakePlayer;", "value", "Lnet/minecraft/world/item/ItemStack;", "diamondBreaker", "getDiamondBreaker", "()Lnet/minecraft/world/item/ItemStack;", "initFakePlayer", "", "upgrade", "insertedBreaker", "downgrade", "player", "Lnet/minecraft/world/entity/player/Player;", "tick", "mineBlock", "facing", "Lnet/minecraft/core/Direction;", "targetPos", "level", "Lnet/minecraft/server/level/ServerLevel;", "resetProgress", "neighborChanged", "state", "Lnet/minecraft/world/level/Level;", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "getUpdateTag", "pRegistries", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "BlockBreakerFakePlayer", "Companion", "irregular-implements-1.21.1"})
public final class BlockBreakerBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UUID uuid;
    private boolean isMining;
    private boolean canMine;
    private float miningProgress;
    private boolean isFirstTick;
    @Nullable
    private WeakReference<FakePlayer> fakePlayer;
    @NotNull
    private ItemStack diamondBreaker;
    @NotNull
    public static final String UUID_NBT = "UUID";
    @NotNull
    public static final String IS_MINING_NBT = "IsMining";
    @NotNull
    public static final String CAN_MINE_NBT = "CanMine";
    @NotNull
    public static final String MINING_PROGRESS_NBT = "MiningProgress";
    @NotNull
    public static final String DIAMOND_BREAKER_NBT = "DiamondBreaker";

    public BlockBreakerBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntities.INSTANCE.getBLOCK_BREAKER().get(), pPos, pBlockState);
        this.isMining = true;
        this.canMine = true;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.diamondBreaker = itemStack;
    }

    @NotNull
    public final ItemStack getDiamondBreaker() {
        return this.diamondBreaker;
    }

    private final void initFakePlayer() {
        ItemStack itemStack;
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.setChanged();
        }
        GameProfile gameProfile = new GameProfile(this.uuid, "IrregularImplementsBlockBreaker");
        FakePlayer fakePlayer = BetterFakePlayerFactory.get(level2, gameProfile, (Function0<? extends FakePlayer>)((Function0)() -> BlockBreakerBlockEntity.initFakePlayer$lambda$0(level2, gameProfile)));
        fakePlayer.setSilent(true);
        fakePlayer.setOnGround(true);
        if (this.diamondBreaker.isEmpty()) {
            Level level3 = (Level)level2;
            Item item = Items.IRON_PICKAXE;
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"IRON_PICKAXE");
            ItemEnchantments itemEnchantments = ItemEnchantments.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemEnchantments, (String)"EMPTY");
            itemStack = BlockBreakerBlockEntity.Companion.getPick(level3, item, itemEnchantments);
        } else {
            ItemEnchantments breakerEnchants = this.diamondBreaker.getAllEnchantments(level2.registryAccess().lookupOrThrow(Registries.ENCHANTMENT));
            Level level4 = (Level)level2;
            Item item = Items.DIAMOND_PICKAXE;
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"DIAMOND_PICKAXE");
            Intrinsics.checkNotNull((Object)breakerEnchants);
            itemStack = BlockBreakerBlockEntity.Companion.getPick(level4, item, breakerEnchants);
        }
        ItemStack pickToUse = itemStack;
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, pickToUse);
        this.fakePlayer = new WeakReference<FakePlayer>(fakePlayer);
        this.setChanged();
    }

    public final void upgrade(@NotNull ItemStack insertedBreaker) {
        Intrinsics.checkNotNullParameter((Object)insertedBreaker, (String)"insertedBreaker");
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        FakePlayer fakePlayer = this.fakePlayer;
        if (fakePlayer == null || (fakePlayer = (FakePlayer)fakePlayer.get()) == null) {
            return;
        }
        FakePlayer fakePlayer2 = fakePlayer;
        ItemEnchantments breakerEnchantments = insertedBreaker.getAllEnchantments(level2.registryAccess().lookupOrThrow(Registries.ENCHANTMENT));
        Level level3 = (Level)level2;
        Item item = Items.DIAMOND_PICKAXE;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"DIAMOND_PICKAXE");
        Intrinsics.checkNotNull((Object)breakerEnchantments);
        ItemStack pick = BlockBreakerBlockEntity.Companion.getPick(level3, item, breakerEnchantments);
        this.diamondBreaker = insertedBreaker;
        this.setChanged();
        fakePlayer2.setItemInHand(InteractionHand.MAIN_HAND, pick);
    }

    public final void downgrade(@NotNull Player player) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Level level = this.level;
            ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (serverLevel == null) {
                return;
            }
            ServerLevel level2 = serverLevel;
            OtherUtil.INSTANCE.giveOrDropStack(this.diamondBreaker, player);
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.diamondBreaker = itemStack;
            Level level3 = (Level)level2;
            Item item = Items.IRON_PICKAXE;
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"IRON_PICKAXE");
            ItemEnchantments itemEnchantments = ItemEnchantments.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemEnchantments, (String)"EMPTY");
            ItemStack basicPick = BlockBreakerBlockEntity.Companion.getPick(level3, item, itemEnchantments);
            FakePlayer fakePlayer = this.fakePlayer;
            if (fakePlayer == null || (fakePlayer = (FakePlayer)fakePlayer.get()) == null) break block1;
            fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, basicPick);
        }
    }

    public final void tick() {
        FakePlayer fakePlayer;
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        if (!this.isFirstTick) {
            this.isFirstTick = true;
            this.initFakePlayer();
        }
        if ((fakePlayer = this.fakePlayer) == null || (fakePlayer = (FakePlayer)fakePlayer.get()) == null) {
            return;
        }
        FakePlayer fakePlayer2 = fakePlayer;
        if (this.isMining) {
            Direction facing = (Direction)this.getBlockState().getValue((Property)BlockBreakerBlock.Companion.getFACING());
            BlockPos targetPos = this.getBlockPos().relative(facing);
            BlockState targetState = level2.getBlockState(targetPos);
            float destroyProgress = targetState.getDestroyProgress((Player)fakePlayer2, (BlockGetter)level2, targetPos);
            this.miningProgress += destroyProgress;
            if (this.miningProgress < 1.0f) {
                UUID uUID = this.uuid;
                level2.destroyBlockProgress(uUID != null ? ((Object)uUID).hashCode() : 0, targetPos, Mth.ceil((float)(this.miningProgress * (float)10)));
                return;
            }
            Intrinsics.checkNotNull((Object)facing);
            Intrinsics.checkNotNull((Object)targetPos);
            this.mineBlock(facing, fakePlayer2, targetPos, level2);
        }
    }

    private final void mineBlock(Direction facing, FakePlayer fakePlayer, BlockPos targetPos, ServerLevel level) {
        this.isMining = false;
        this.resetProgress();
        BlockPos possibleInventoryPos = this.getBlockPos().relative(facing.getOpposite());
        IItemHandler inventoryBehind = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, possibleInventoryPos, (Object)facing);
        fakePlayer.gameMode.destroyBlock(targetPos);
        Inventory inventory = fakePlayer.getInventory();
        int n = ((Collection)inventory.items).size();
        for (int i = 0; i < n; ++i) {
            ItemStack stack = ((ItemStack)inventory.items.get(i)).copy();
            if (stack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)inventory.getSelected())) continue;
            inventory.removeItemNoUpdate(i);
            ItemStack remainder = stack.copy();
            if (inventoryBehind != null) {
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventoryBehind, (ItemStack)remainder, (boolean)false);
            }
            if (remainder.isEmpty()) continue;
            ItemStack itemStack = remainder.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            Level level2 = (Level)level;
            Vec3 vec3 = possibleInventoryPos.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            OtherUtil.INSTANCE.dropStackAt(itemStack, level2, vec3, false);
        }
    }

    private final void resetProgress() {
        UUID uUID = this.uuid;
        if (uUID == null) {
            return;
        }
        UUID uuid = uUID;
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        BlockPos targetPos = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockBreakerBlock.Companion.getFACING()));
        level2.destroyBlockProgress(uuid.hashCode(), targetPos, -1);
        this.miningProgress = 0.0f;
    }

    public final void neighborChanged(@NotNull BlockState state, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        BlockPos targetPos = this.getBlockPos().relative((Direction)state.getValue((Property)BlockBreakerBlock.Companion.getFACING()));
        BlockState targetState = level.getBlockState(targetPos);
        boolean bl = this.canMine = !level.hasNeighborSignal(this.getBlockPos());
        if (this.canMine) {
            if (!targetState.isAir()) {
                if (!this.isMining) {
                    this.isMining = true;
                    this.miningProgress = 0.0f;
                }
            } else {
                this.isMining = false;
                this.resetProgress();
            }
        } else if (this.isMining) {
            this.isMining = false;
            this.resetProgress();
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        UUID uuid = this.uuid;
        if (uuid != null) {
            tag.putUUID(UUID_NBT, uuid);
        }
        tag.putBoolean(IS_MINING_NBT, this.isMining);
        tag.putBoolean(CAN_MINE_NBT, this.canMine);
        tag.putFloat(MINING_PROGRESS_NBT, this.miningProgress);
        if (!this.diamondBreaker.isEmpty()) {
            tag.put(DIAMOND_BREAKER_NBT, this.diamondBreaker.save(registries));
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.uuid = OtherUtil.INSTANCE.getUuidOrNull(tag, UUID_NBT);
        this.isMining = tag.getBoolean(IS_MINING_NBT);
        this.canMine = tag.getBoolean(CAN_MINE_NBT);
        this.miningProgress = tag.getFloat(MINING_PROGRESS_NBT);
        if (tag.contains(DIAMOND_BREAKER_NBT)) {
            ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(DIAMOND_BREAKER_NBT));
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"parseOptional(...)");
            this.diamondBreaker = itemStack;
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    private static final FakePlayer initFakePlayer$lambda$0(ServerLevel $level, GameProfile $gameProfile) {
        return new BlockBreakerFakePlayer($level, $gameProfile);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockBreakerBlockEntity$BlockBreakerFakePlayer;", "Lnet/neoforged/neoforge/common/util/FakePlayer;", "level", "Lnet/minecraft/server/level/ServerLevel;", "gameProfile", "Lcom/mojang/authlib/GameProfile;", "<init>", "(Lnet/minecraft/server/level/ServerLevel;Lcom/mojang/authlib/GameProfile;)V", "take", "", "entity", "Lnet/minecraft/world/entity/Entity;", "quantity", "", "getDigSpeed", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "Companion", "irregular-implements-1.21.1"})
    public static final class BlockBreakerFakePlayer
    extends FakePlayer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String NAME = "IrregularImplementsBlockBreaker";

        public BlockBreakerFakePlayer(@NotNull ServerLevel level, @NotNull GameProfile gameProfile) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)gameProfile, (String)"gameProfile");
            super(level, gameProfile);
        }

        public void take(@NotNull Entity entity, int quantity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        }

        public float getDigSpeed(@NotNull BlockState state, @Nullable BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            float f = this.getInventory().getDestroySpeed(state);
            if (f > 1.0f) {
                ItemStack itemStack = this.getMainHandItem();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
                Holder holder = Attributes.MINING_EFFICIENCY;
                Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"MINING_EFFICIENCY");
                RegistryAccess registryAccess = this.registryAccess();
                Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
                f += (float)BlockBreakerFakePlayer.Companion.getStackAttributeValue(itemStack, (Holder<Attribute>)holder, registryAccess, 0.0f);
            }
            ItemStack itemStack = this.getMainHandItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
            Holder holder = Attributes.BLOCK_BREAK_SPEED;
            Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"BLOCK_BREAK_SPEED");
            RegistryAccess registryAccess = this.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            f *= (float)BlockBreakerFakePlayer.Companion.getStackAttributeValue(itemStack, (Holder<Attribute>)holder, registryAccess, 1.0f);
            f = EventHooks.getBreakSpeed((Player)((Player)this), (BlockState)state, (float)f, (BlockPos)pos);
            return f;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockBreakerBlockEntity$BlockBreakerFakePlayer$Companion;", "", "<init>", "()V", "NAME", "", "getStackAttributeValue", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "attribute", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/entity/ai/attributes/Attribute;", "registryAccess", "Lnet/minecraft/core/RegistryAccess;", "baseValue", "", "getModifiersForAttribute", "", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "irregular-implements-1.21.1"})
        @SourceDebugExtension(value={"SMAP\nBlockBreakerBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockBreakerBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/BlockBreakerBlockEntity$BlockBreakerFakePlayer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,373:1\n774#2:374\n865#2,2:375\n774#2:378\n865#2,2:379\n1803#2,3:381\n774#2:384\n865#2,2:385\n1803#2,3:387\n1374#2:390\n1460#2,2:391\n774#2:393\n865#2,2:394\n1563#2:396\n1634#2,3:397\n1462#2,3:400\n774#2:403\n865#2,2:404\n1563#2:406\n1634#2,3:407\n1#3:377\n*S KotlinDebug\n*F\n+ 1 BlockBreakerBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/BlockBreakerBlockEntity$BlockBreakerFakePlayer$Companion\n*L\n288#1:374\n288#1:375,2\n294#1:378\n294#1:379,2\n295#1:381,3\n298#1:384\n298#1:385,2\n299#1:387,3\n315#1:390\n315#1:391,2\n318#1:393\n318#1:394,2\n319#1:396\n319#1:397,3\n315#1:400,3\n324#1:403\n324#1:404,2\n325#1:406\n325#1:407,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            private final double getStackAttributeValue(ItemStack itemStack, Holder<Attribute> attribute, RegistryAccess registryAccess, float baseValue) {
                void $this$fold$iv;
                void initial$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$fold$iv2;
                void initial$iv2;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2;
                void $this$filterTo$iv$iv3;
                Iterable $this$filter$iv3;
                List<AttributeModifier> modifiers = this.getModifiersForAttribute(attribute, itemStack, registryAccess);
                Iterable iterable = modifiers;
                boolean $i$f$filter = false;
                void var10_10 = $this$filter$iv3;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    AttributeModifier it = (AttributeModifier)element$iv$iv;
                    boolean bl = false;
                    if (!(it.operation() == AttributeModifier.Operation.ADD_VALUE)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv3 = (List)destination$iv$iv;
                double d = 0.0;
                for (Object $i$f$filterTo2 : $this$filter$iv3) {
                    void it;
                    AttributeModifier attributeModifier = (AttributeModifier)$i$f$filterTo2;
                    double d2 = d;
                    boolean bl = false;
                    double d3 = it.amount();
                    d = d2 + d3;
                }
                double baseIncrease = d;
                double increasedBase = (double)baseValue + baseIncrease;
                Iterable $i$f$filterTo2 = modifiers;
                boolean $i$f$filter22 = false;
                void bl = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo222 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    AttributeModifier it = (AttributeModifier)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv2;
                double $i$f$filter22 = increasedBase;
                boolean $i$f$fold22 = false;
                void accumulator$iv = initial$iv2;
                for (Object element$iv : $this$fold$iv2) {
                    void modifier;
                    Object element$iv$iv;
                    element$iv$iv = (AttributeModifier)element$iv;
                    void acc = accumulator$iv;
                    boolean bl3 = false;
                    accumulator$iv = acc * modifier.amount();
                }
                void multipliedBase = accumulator$iv;
                Iterable $i$f$fold22 = modifiers;
                boolean $i$f$filter32 = false;
                Iterator $i$f$filterTo222 = $this$filter$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    AttributeModifier it = (AttributeModifier)element$iv$iv;
                    boolean bl4 = false;
                    if (!(it.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv3;
                void $i$f$filter32 = multipliedBase;
                boolean $i$f$fold = false;
                void accumulator$iv2 = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void modifier;
                    AttributeModifier element$iv$iv = (AttributeModifier)element$iv;
                    void acc = accumulator$iv2;
                    boolean bl5 = false;
                    accumulator$iv2 = acc * (1.0 + modifier.amount());
                }
                void multipliedTotal = accumulator$iv2;
                return (double)multipliedTotal;
            }

            /*
             * WARNING - void declaration
             */
            private final List<AttributeModifier> getModifiersForAttribute(Holder<Attribute> attribute, ItemStack itemStack, RegistryAccess registryAccess) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                if (itemStack.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                Set set = itemStack.getAllEnchantments(registryAccess.lookupOrThrow(Registries.ENCHANTMENT)).entrySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
                Iterable iterable = set;
                boolean $i$f$flatMap22 = false;
                void var7_7 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List list;
                    Object2IntMap.Entry entry2 = (Object2IntMap.Entry)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)entry2);
                    Holder enchantHolder = (Holder)((Map.Entry)entry2).getKey();
                    Integer level = (Integer)((Map.Entry)entry2).getValue();
                    List list2 = (List)((Enchantment)enchantHolder.value()).effects().get(EnchantmentEffectComponents.ATTRIBUTES);
                    if (list2 != null) {
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        void $this$filterTo$iv$iv2;
                        void $this$filter$iv2;
                        Iterable iterable2 = list2;
                        boolean $i$f$filter22 = false;
                        void var19_28 = $this$filter$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                            EnchantmentAttributeEffect it = (EnchantmentAttributeEffect)element$iv$iv2;
                            boolean bl2 = false;
                            if (!it.attribute().is(attribute)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        Iterable $i$f$filter22 = (List)destination$iv$iv2;
                        boolean $i$f$map = false;
                        destination$iv$iv2 = $this$map$iv2;
                        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                            void it;
                            EnchantmentAttributeEffect bl2 = (EnchantmentAttributeEffect)item$iv$iv;
                            Collection collection = destination$iv$iv3;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull((Object)level);
                            collection.add(it.getModifier(level.intValue(), (StringRepresentable)EquipmentSlot.MAINHAND));
                        }
                        list = (List)destination$iv$iv3;
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = list;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List enchantmentModifiers = (List)destination$iv$iv;
                List list = itemStack.getAttributeModifiers().modifiers();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"modifiers(...)");
                Iterable $i$f$flatMap22 = list;
                boolean $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ItemAttributeModifiers.Entry it = (ItemAttributeModifiers.Entry)element$iv$iv;
                    boolean bl = false;
                    if (!(it.slot().test(EquipmentSlot.MAINHAND) && it.attribute().is(attribute))) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv4;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ItemAttributeModifiers.Entry it = (ItemAttributeModifiers.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl = false;
                    collection.add(it.modifier());
                }
                List stackModifiers = (List)destination$iv$iv4;
                return CollectionsKt.plus((Collection)enchantmentModifiers, (Iterable)stackModifiers);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockBreakerBlockEntity$Companion;", "", "<init>", "()V", "UUID_NBT", "", "IS_MINING_NBT", "CAN_MINE_NBT", "MINING_PROGRESS_NBT", "DIAMOND_BREAKER_NBT", "getPick", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "item", "Lnet/minecraft/world/item/Item;", "withEnchantments", "Lnet/minecraft/world/item/enchantment/ItemEnchantments;", "tick", "", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockBreakerBlockEntity;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final ItemStack getPick(Level level, Item item, ItemEnchantments withEnchantments) {
            ItemStack stack = item.getDefaultInstance();
            stack.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
            ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(withEnchantments);
            ResourceKey<Enchantment> resourceKey = ModEnchantments.INSTANCE.getMAGNETIC();
            RegistryAccess registryAccess = level.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            enchantments.set((Holder)ModEnchantments.INSTANCE.getHolder(resourceKey, registryAccess), 1);
            EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)enchantments.toImmutable());
            Intrinsics.checkNotNull((Object)stack);
            return stack;
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull BlockBreakerBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            blockEntity.tick();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

