/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.BlockDestabilizerBlockEntity;
import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBlockTagsProvider;
import dev.aaronhowser.mods.irregular_implements.menu.block_destabilizer.BlockDestabilizerMenu;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.AddIndicatorsPacket;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.RemoveIndicatorsPacket;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009b\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001.\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0002BCB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u0018\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u0006\u0010)\u001a\u00020#J\b\u0010*\u001a\u00020#H\u0002J\b\u0010+\u001a\u00020#H\u0002J\b\u0010,\u001a\u00020#H\u0002J \u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020#H\u0002J\b\u0010:\u001a\u00020\u001bH\u0002J\b\u0010;\u001a\u00020\u001bH\u0002J\b\u0010<\u001a\u00020#H\u0002J\u0010\u0010=\u001a\u00020%2\u0006\u0010>\u001a\u00020'H\u0016J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@H\u0016R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0012j\b\u0012\u0004\u0012\u00020\u0004`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/\u00a8\u0006D"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockDestabilizerBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "value", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockDestabilizerBlockEntity$State;", "state", "getState", "()Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockDestabilizerBlockEntity$State;", "alreadyChecked", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "toCheck", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "targetBlockPositions", "targetBlock", "Lnet/minecraft/world/level/block/Block;", "targetBlocksSorted", "", "dropCounter", "", "", "isLazy", "()Z", "setLazy", "(Z)V", "lazyBlocks", "", "saveAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "initStart", "stepSearch", "initDrop", "dropNextBlock", "containerData", "dev/aaronhowser/mods/irregular_implements/block/block_entity/BlockDestabilizerBlockEntity$containerData$1", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockDestabilizerBlockEntity$containerData$1;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "toggleLazy", "showLazyShape", "removeLazyIndicators", "resetLazyShape", "getUpdateTag", "pRegistries", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "State", "Companion", "irregular-implements-1.21.1"})
public final class BlockDestabilizerBlockEntity
extends BlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state;
    @NotNull
    private final HashSet<BlockPos> alreadyChecked;
    @NotNull
    private final ArrayList<BlockPos> toCheck;
    @NotNull
    private final HashSet<BlockPos> targetBlockPositions;
    @Nullable
    private Block targetBlock;
    @NotNull
    private List<BlockPos> targetBlocksSorted;
    private int dropCounter;
    private boolean isLazy;
    @NotNull
    private final Set<BlockPos> lazyBlocks;
    @NotNull
    private final containerData.1 containerData;
    @NotNull
    public static final String STATE_NBT = "state";
    @NotNull
    public static final String LAZY_NBT = "lazy";
    @NotNull
    public static final String TARGET_STATE_BLOCK_NBT = "target_state_block";
    @NotNull
    public static final String LAZY_BLOCKS = "lazy_blocks";
    @NotNull
    public static final String ALREADY_CHECKED_NBT = "already_checked";
    @NotNull
    public static final String TO_CHECK_NBT = "to_check";
    @NotNull
    public static final String TARGET_BLOCKS_NBT = "target_blocks";
    @NotNull
    public static final String DROP_COUNTER_NBT = "drop_counter";
    @NotNull
    public static final String TARGET_BLOCKS_SORTED_NBT = "target_blocks_sorted";
    public static final int CONTAINER_DATA_SIZE = 3;
    public static final int LAZY_INDEX = 0;
    public static final int SHOW_LAZY_INDEX = 1;
    public static final int RESET_LAZY_INDEX = 2;

    public BlockDestabilizerBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntities.INSTANCE.getBLOCK_DESTABILIZER().get(), pPos, pBlockState);
        this.state = State.IDLE;
        this.alreadyChecked = new HashSet();
        this.toCheck = new ArrayList();
        this.targetBlockPositions = new HashSet();
        this.targetBlocksSorted = new ArrayList();
        this.lazyBlocks = new LinkedHashSet();
        this.containerData = new ContainerData(this){
            final /* synthetic */ BlockDestabilizerBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public int get(int index) {
                return index == 0 ? (this.this$0.isLazy() ? 1 : 0) : 0;
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        BlockDestabilizerBlockEntity.access$toggleLazy(this.this$0);
                        break;
                    }
                    case 1: {
                        BlockDestabilizerBlockEntity.access$showLazyShape(this.this$0);
                        break;
                    }
                    case 2: {
                        BlockDestabilizerBlockEntity.access$resetLazyShape(this.this$0);
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final boolean isLazy() {
        return this.isLazy;
    }

    public final void setLazy(boolean value) {
        this.isLazy = value;
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        LongTag longTag;
        long posLong;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putInt(STATE_NBT, this.state.ordinal());
        tag.putBoolean(LAZY_NBT, this.isLazy);
        if (!((Collection)this.lazyBlocks).isEmpty()) {
            ListTag invalidBlocksTag = new ListTag();
            for (BlockPos blockPos : this.lazyBlocks) {
                posLong = blockPos.asLong();
                longTag = LongTag.valueOf((long)posLong);
                invalidBlocksTag.add((Object)longTag);
            }
            tag.put(LAZY_BLOCKS, (Tag)invalidBlocksTag);
        }
        if (this.state == State.SEARCHING) {
            ListTag alreadyCheckedTag = new ListTag();
            Iterator<BlockPos> iterator = this.alreadyChecked.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<BlockPos> iterator2 = iterator;
            while (iterator2.hasNext()) {
                BlockPos blockPos = iterator2.next();
                posLong = blockPos.asLong();
                longTag = LongTag.valueOf((long)posLong);
                alreadyCheckedTag.add((Object)longTag);
            }
            tag.put(ALREADY_CHECKED_NBT, (Tag)alreadyCheckedTag);
            ListTag toCheckTag = new ListTag();
            Iterator<BlockPos> iterator3 = this.toCheck.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
            Iterator<BlockPos> iterator4 = iterator3;
            while (iterator4.hasNext()) {
                BlockPos blockPos2 = iterator4.next();
                long posLong2 = blockPos2.asLong();
                LongTag longTag2 = LongTag.valueOf((long)posLong2);
                toCheckTag.add((Object)longTag2);
            }
            tag.put(TO_CHECK_NBT, (Tag)toCheckTag);
            ListTag listTag = new ListTag();
            Iterator<BlockPos> iterator5 = this.targetBlockPositions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
            Iterator<BlockPos> blockPos2 = iterator5;
            while (blockPos2.hasNext()) {
                BlockPos blockPos3 = blockPos2.next();
                long posLong3 = blockPos3.asLong();
                LongTag longTag3 = LongTag.valueOf((long)posLong3);
                listTag.add((Object)longTag3);
            }
            tag.put(TARGET_BLOCKS_NBT, (Tag)listTag);
        }
        if (this.state == State.DROPPING) {
            tag.putInt(DROP_COUNTER_NBT, this.dropCounter);
            ListTag targetBlocksSortedTag = new ListTag();
            for (BlockPos blockPos : this.targetBlocksSorted) {
                long posLong4 = blockPos.asLong();
                LongTag longTag4 = LongTag.valueOf((long)posLong4);
                targetBlocksSortedTag.add((Object)longTag4);
            }
            tag.put(TARGET_BLOCKS_SORTED_NBT, (Tag)targetBlocksSortedTag);
        }
        if (this.targetBlock != null) {
            Block block = this.targetBlock;
            Intrinsics.checkNotNull((Object)block);
            String string = BuiltInRegistries.BLOCK.getKey((Object)block).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String targetBlockStateName = string;
            tag.putString(TARGET_STATE_BLOCK_NBT, targetBlockStateName);
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        BlockPos blockPos;
        BlockPos blockPos2;
        long posLong;
        Object tagElement;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        int stateOrdinal = tag.getInt(STATE_NBT);
        this.state = (State)((Object)State.getEntries().get(stateOrdinal));
        boolean lazy = tag.getBoolean(LAZY_NBT);
        this.setLazy(lazy);
        if (tag.contains(LAZY_BLOCKS)) {
            ListTag invalidBlocksTag = tag.getList(LAZY_BLOCKS, 4);
            Iterator iterator2 = invalidBlocksTag.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
            iterator = iterator2;
            while (iterator.hasNext()) {
                tagElement = (Tag)iterator.next();
                Intrinsics.checkNotNull((Object)tagElement, (String)"null cannot be cast to non-null type net.minecraft.nbt.LongTag");
                posLong = ((LongTag)tagElement).getAsLong();
                blockPos2 = BlockPos.of((long)posLong);
                Intrinsics.checkNotNull((Object)blockPos2);
                this.lazyBlocks.add(blockPos2);
            }
        }
        if (this.state == State.SEARCHING) {
            ListTag alreadyCheckedTag = tag.getList(ALREADY_CHECKED_NBT, 4);
            Iterator iterator3 = alreadyCheckedTag.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"iterator(...)");
            iterator = iterator3;
            while (iterator.hasNext()) {
                tagElement = (Tag)iterator.next();
                Intrinsics.checkNotNull((Object)tagElement, (String)"null cannot be cast to non-null type net.minecraft.nbt.LongTag");
                posLong = ((LongTag)tagElement).getAsLong();
                blockPos2 = BlockPos.of((long)posLong);
                this.alreadyChecked.add(blockPos2);
            }
            ListTag toCheckTag = tag.getList(TO_CHECK_NBT, 4);
            Iterator iterator4 = toCheckTag.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator4, (String)"iterator(...)");
            tagElement = iterator4;
            while (tagElement.hasNext()) {
                Tag tagElement2 = (Tag)tagElement.next();
                Intrinsics.checkNotNull((Object)tagElement2, (String)"null cannot be cast to non-null type net.minecraft.nbt.LongTag");
                long posLong2 = ((LongTag)tagElement2).getAsLong();
                blockPos = BlockPos.of((long)posLong2);
                this.toCheck.add(blockPos);
            }
            ListTag targetBlocksTag = tag.getList(TARGET_BLOCKS_NBT, 4);
            Iterator iterator5 = targetBlocksTag.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator5, (String)"iterator(...)");
            Iterator tagElement2 = iterator5;
            while (tagElement2.hasNext()) {
                Tag tagElement3 = (Tag)tagElement2.next();
                Intrinsics.checkNotNull((Object)tagElement3, (String)"null cannot be cast to non-null type net.minecraft.nbt.LongTag");
                long posLong3 = ((LongTag)tagElement3).getAsLong();
                BlockPos blockPos3 = BlockPos.of((long)posLong3);
                this.targetBlockPositions.add(blockPos3);
            }
        }
        if (this.state == State.DROPPING) {
            int dropCounter;
            this.dropCounter = dropCounter = tag.getInt(DROP_COUNTER_NBT);
            ListTag targetBlocksSortedTag = tag.getList(TARGET_BLOCKS_SORTED_NBT, 4);
            Iterator iterator6 = targetBlocksSortedTag.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator6, (String)"iterator(...)");
            Iterator iterator7 = iterator6;
            while (iterator7.hasNext()) {
                Tag tagElement4 = (Tag)iterator7.next();
                Intrinsics.checkNotNull((Object)tagElement4, (String)"null cannot be cast to non-null type net.minecraft.nbt.LongTag");
                long posLong4 = ((LongTag)tagElement4).getAsLong();
                blockPos = BlockPos.of((long)posLong4);
                Intrinsics.checkNotNull((Object)blockPos);
                this.targetBlocksSorted.add(blockPos);
            }
        }
        if (tag.contains(TARGET_STATE_BLOCK_NBT)) {
            Block targetBlock;
            ResourceLocation targetBlockStateName = ResourceLocation.parse((String)tag.getString(TARGET_STATE_BLOCK_NBT));
            Object object = BuiltInRegistries.BLOCK.get(targetBlockStateName);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.targetBlock = targetBlock = (Block)object;
        }
    }

    public final void initStart() {
        if (this.isLazy && !((Collection)this.lazyBlocks).isEmpty()) {
            this.targetBlockPositions.clear();
            this.targetBlockPositions.addAll((Collection<BlockPos>)this.lazyBlocks);
            this.initDrop();
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        Direction facing = (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING);
        BlockPos targetBlockPos = this.getBlockPos().relative(facing);
        BlockState targetBlockState = level2.getBlockState(targetBlockPos);
        if (targetBlockState.isAir() || targetBlockState.is(ModBlockTagsProvider.Companion.getBLOCK_DESTABILIZER_BLACKLIST()) || targetBlockState.getDestroySpeed((BlockGetter)level2, targetBlockPos) <= 0.0f || level2.getBlockEntity(targetBlockPos) != null) {
            return;
        }
        this.targetBlock = targetBlockState.getBlock();
        this.state = State.SEARCHING;
        this.toCheck.add(targetBlockPos);
    }

    private final void stepSearch() {
        boolean doneSearching;
        boolean bl = doneSearching = this.toCheck.isEmpty() || ((Collection)this.targetBlockPositions).size() >= ((Number)ServerConfig.Companion.getCONFIG().getBlockDestabilizerLimit().get()).intValue();
        if (doneSearching) {
            this.initDrop();
            return;
        }
        BlockPos blockPos = this.toCheck.removeFirst();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"removeFirst(...)");
        BlockPos nextPos = blockPos;
        if (this.alreadyChecked.contains(nextPos)) {
            return;
        }
        this.alreadyChecked.add(nextPos);
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        BlockState checkedState = level2.getBlockState(nextPos);
        boolean shouldAdd = Intrinsics.areEqual((Object)checkedState.getBlock(), (Object)this.targetBlock);
        if (shouldAdd) {
            this.targetBlockPositions.add(nextPos);
            for (Direction direction : EntriesMappings.entries$0) {
                BlockPos offsetPos = nextPos.relative(direction);
                if (this.alreadyChecked.contains(offsetPos)) continue;
                this.toCheck.add(offsetPos);
            }
        }
        int color = shouldAdd ? 65280 : 0xFF0000;
        AddIndicatorsPacket packet = new AddIndicatorsPacket(nextPos, 5, color, null, 8, null);
        BlockPos blockPos2 = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        packet.messageNearbyPlayers(level2, blockPos2, 32.0);
    }

    private final void initDrop() {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                BlockPos it = (BlockPos)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getY());
                it = (BlockPos)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getY()));
            }
        };
        this.targetBlocksSorted = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)this.targetBlockPositions, (Comparator)new Comparator(comparator, this){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ BlockDestabilizerBlockEntity this$0;
            {
                this.$this_thenBy = $receiver;
                this.this$0 = blockDestabilizerBlockEntity;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    BlockPos it = (BlockPos)a;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.distSqr((Vec3i)this.this$0.getBlockPos()));
                    it = (BlockPos)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.distSqr((Vec3i)this.this$0.getBlockPos())));
                }
                return n;
            }
        }));
        this.lazyBlocks.clear();
        this.lazyBlocks.addAll((Collection<BlockPos>)this.targetBlocksSorted);
        this.state = State.DROPPING;
        this.dropCounter = 0;
        this.targetBlockPositions.clear();
        this.toCheck.clear();
        this.alreadyChecked.clear();
    }

    private final void dropNextBlock() {
        boolean shouldDrop;
        if (this.dropCounter >= this.targetBlocksSorted.size()) {
            this.state = State.IDLE;
            this.targetBlocksSorted.clear();
            this.targetBlock = null;
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        BlockPos blockPos = (BlockPos)CollectionsKt.getOrNull(this.targetBlocksSorted, (int)this.dropCounter);
        if (blockPos == null) {
            return;
        }
        BlockPos checkedPos = blockPos;
        BlockState checkedState = level2.getBlockState(checkedPos);
        boolean bl = shouldDrop = (Intrinsics.areEqual((Object)checkedState.getBlock(), (Object)this.targetBlock) || this.isLazy) && level2.getBlockEntity(checkedPos) == null;
        if (shouldDrop) {
            FallingBlockEntity.fall((Level)level2, (BlockPos)checkedPos, (BlockState)checkedState);
        }
        int n = this.dropCounter;
        this.dropCounter = n + 1;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new BlockDestabilizerMenu(containerId, this.containerData);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    private final void toggleLazy() {
        if (this.state != State.IDLE) {
            return;
        }
        this.setLazy(!this.isLazy);
    }

    private final boolean showLazyShape() {
        if (this.state != State.IDLE) {
            return false;
        }
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return false;
        }
        ServerLevel level2 = serverLevel;
        AddIndicatorsPacket packet = new AddIndicatorsPacket(CollectionsKt.toList((Iterable)this.lazyBlocks), 200, 0x33FFFFFF, new Vec3(0.99, 0.99, 0.99));
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        packet.messageNearbyPlayers(level2, blockPos, 32.0);
        return true;
    }

    private final boolean removeLazyIndicators() {
        if (this.lazyBlocks.isEmpty()) {
            return false;
        }
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return false;
        }
        ServerLevel level2 = serverLevel;
        RemoveIndicatorsPacket packet = new RemoveIndicatorsPacket(CollectionsKt.toList((Iterable)this.lazyBlocks));
        BlockPos blockPos = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        packet.messageNearbyPlayers(level2, blockPos, 32.0);
        return true;
    }

    private final void resetLazyShape() {
        if (this.state != State.IDLE) {
            return;
        }
        this.removeLazyIndicators();
        this.lazyBlocks.clear();
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    public static final /* synthetic */ void access$toggleLazy(BlockDestabilizerBlockEntity $this) {
        $this.toggleLazy();
    }

    public static final /* synthetic */ boolean access$showLazyShape(BlockDestabilizerBlockEntity $this) {
        return $this.showLazyShape();
    }

    public static final /* synthetic */ void access$resetLazyShape(BlockDestabilizerBlockEntity $this) {
        $this.resetLazyShape();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockDestabilizerBlockEntity$Companion;", "", "<init>", "()V", "STATE_NBT", "", "LAZY_NBT", "TARGET_STATE_BLOCK_NBT", "LAZY_BLOCKS", "ALREADY_CHECKED_NBT", "TO_CHECK_NBT", "TARGET_BLOCKS_NBT", "DROP_COUNTER_NBT", "TARGET_BLOCKS_SORTED_NBT", "CONTAINER_DATA_SIZE", "", "LAZY_INDEX", "SHOW_LAZY_INDEX", "RESET_LAZY_INDEX", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockDestabilizerBlockEntity;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull BlockDestabilizerBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            if (blockEntity.getState() == State.SEARCHING) {
                blockEntity.stepSearch();
            } else if (blockEntity.getState() == State.DROPPING) {
                blockEntity.dropNextBlock();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/BlockDestabilizerBlockEntity$State;", "", "<init>", "(Ljava/lang/String;I)V", "IDLE", "SEARCHING", "DROPPING", "irregular-implements-1.21.1"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State IDLE = new State();
        public static final /* enum */ State SEARCHING = new State();
        public static final /* enum */ State DROPPING = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.IDLE, State.SEARCHING, State.DROPPING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

