/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.block.ChatDetectorBlock;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.ChatDetectorBlockEntity;
import dev.aaronhowser.mods.irregular_implements.menu.chat_detector.ChatDetectorMenu;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.UpdateClientScreenString;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntities;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.ServerChatEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u00010\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0001=B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\u0017H\u0002J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0014J\u0018\u0010-\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0014J\b\u0010.\u001a\u00020\u0017H\u0016J \u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u0002062\u0006\u0010#\u001a\u00020$H\u0016J\b\u00107\u001a\u00020&H\u0016J\u0010\u00108\u001a\u00020*2\u0006\u00109\u001a\u00020,H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u001e@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b \u0010!R\u0010\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101\u00a8\u0006>"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ChatDetectorBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "ownerUuid", "Ljava/util/UUID;", "getOwnerUuid", "()Ljava/util/UUID;", "setOwnerUuid", "(Ljava/util/UUID;)V", "value", "", "regexString", "getRegexString", "()Ljava/lang/String;", "setRegexString", "(Ljava/lang/String;)V", "sendStringUpdate", "", "", "stopsMessage", "getStopsMessage", "()Z", "setStopsMessage", "(Z)V", "", "timeOn", "setTimeOn", "(I)V", "processMessage", "player", "Lnet/minecraft/world/entity/player/Player;", "message", "Lnet/minecraft/network/chat/Component;", "pulse", "loadAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "onLoad", "containerData", "dev/aaronhowser/mods/irregular_implements/block/block_entity/ChatDetectorBlockEntity$containerData$1", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ChatDetectorBlockEntity$containerData$1;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "getDisplayName", "getUpdateTag", "pRegistries", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nChatDetectorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatDetectorBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/ChatDetectorBlockEntity\n+ 2 OtherUtil.kt\ndev/aaronhowser/mods/irregular_implements/util/OtherUtil\n*L\n1#1,191:1\n49#2:192\n*S KotlinDebug\n*F\n+ 1 ChatDetectorBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/ChatDetectorBlockEntity\n*L\n112#1:192\n*E\n"})
public final class ChatDetectorBlockEntity
extends BlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private UUID ownerUuid;
    @NotNull
    private String regexString;
    private boolean stopsMessage;
    private int timeOn;
    @NotNull
    private final containerData.1 containerData;
    @NotNull
    private static final Set<ChatDetectorBlockEntity> detectors = new LinkedHashSet();
    @NotNull
    public static final String OWNER_UUID_NBT = "OwnerUuid";
    @NotNull
    public static final String STOPS_MESSAGE_NBT = "StopsMessage";
    @NotNull
    public static final String MESSAGE_REGEX_NBT = "MessageRegex";
    @NotNull
    public static final String TIME_ON_NBT = "TimeOn";
    public static final int CONTAINER_DATA_SIZE = 1;
    public static final int STOPS_MESSAGE_INDEX = 0;

    public ChatDetectorBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntities.INSTANCE.getCHAT_DETECTOR().get(), pPos, pBlockState);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.ownerUuid = uUID;
        this.regexString = "";
        this.containerData = new ContainerData(this){
            final /* synthetic */ ChatDetectorBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public void set(int index, int value) {
                if (index == 0) {
                    this.this$0.setStopsMessage(value == 1);
                }
            }

            public int get(int index) {
                return index == 0 ? (this.this$0.getStopsMessage() ? 1 : 0) : 0;
            }

            public int getCount() {
                return 1;
            }
        };
    }

    @NotNull
    public final UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public final void setOwnerUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.ownerUuid = uUID;
    }

    @NotNull
    public final String getRegexString() {
        return this.regexString;
    }

    public final void setRegexString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.regexString = value;
        this.setChanged();
        this.sendStringUpdate();
    }

    public final void sendStringUpdate() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        UpdateClientScreenString packet = new UpdateClientScreenString(0, this.regexString);
        Vec3 vec3 = this.getBlockPos().getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        packet.messageNearbyPlayers(level2, vec3, 16.0);
    }

    public final boolean getStopsMessage() {
        return this.stopsMessage;
    }

    public final void setStopsMessage(boolean value) {
        this.stopsMessage = value;
        this.setChanged();
    }

    private final void setTimeOn(int value) {
        this.timeOn = value;
        this.setChanged();
    }

    public final boolean processMessage(@NotNull Player player, @NotNull Component message) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (((CharSequence)this.regexString).length() == 0 || !Intrinsics.areEqual((Object)player.getUUID(), (Object)this.ownerUuid)) {
            return false;
        }
        String messageString = message.getString();
        Regex regex = new Regex(this.regexString);
        Intrinsics.checkNotNull((Object)messageString);
        if (regex.containsMatchIn((CharSequence)messageString)) {
            this.pulse();
            if (this.stopsMessage) {
                return true;
            }
        }
        return false;
    }

    private final void pulse() {
        block0: {
            this.setTimeOn(60);
            Level level = this.level;
            if (level == null) break block0;
            level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)ChatDetectorBlock.Companion.getENABLED(), (Comparable)Boolean.valueOf(true)));
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        UUID uuid = OtherUtil.INSTANCE.getUuidOrNull(tag, OWNER_UUID_NBT);
        if (uuid != null) {
            this.ownerUuid = uuid;
        }
        String string = tag.getString(MESSAGE_REGEX_NBT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.setRegexString(string);
        this.setStopsMessage(tag.getBoolean(STOPS_MESSAGE_NBT));
        this.setTimeOn(tag.getInt(TIME_ON_NBT));
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putUUID(OWNER_UUID_NBT, this.ownerUuid);
        tag.putString(MESSAGE_REGEX_NBT, this.regexString);
        tag.putBoolean(STOPS_MESSAGE_NBT, this.stopsMessage);
        tag.putInt(TIME_ON_NBT, this.timeOn);
    }

    public void onLoad() {
        super.onLoad();
        OtherUtil otherUtil = OtherUtil.INSTANCE;
        Level level = this.level;
        Boolean $this$isTrue$iv = level != null ? Boolean.valueOf(level.isClientSide) : null;
        boolean $i$f$isTrue = false;
        if (!Intrinsics.areEqual((Object)$this$isTrue$iv, (Object)true)) {
            detectors.add(this);
        }
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.sendStringUpdate();
        ContainerData containerData2 = this.containerData;
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        ContainerLevelAccess containerLevelAccess = ContainerLevelAccess.create((Level)level, (BlockPos)this.getBlockPos());
        Intrinsics.checkNotNullExpressionValue((Object)containerLevelAccess, (String)"create(...)");
        return new ChatDetectorMenu(containerId, containerData2, containerLevelAccess);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ChatDetectorBlockEntity$Companion;", "", "<init>", "()V", "detectors", "", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ChatDetectorBlockEntity;", "processMessage", "", "event", "Lnet/neoforged/neoforge/event/ServerChatEvent;", "tick", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "OWNER_UUID_NBT", "", "STOPS_MESSAGE_NBT", "MESSAGE_REGEX_NBT", "TIME_ON_NBT", "CONTAINER_DATA_SIZE", "", "STOPS_MESSAGE_INDEX", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void processMessage(@NotNull ServerChatEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCanceled()) {
                return;
            }
            Component message = event.getMessage();
            ServerPlayer sender = event.getPlayer();
            Iterator iterator = detectors.iterator();
            while (iterator.hasNext()) {
                ChatDetectorBlockEntity detector = (ChatDetectorBlockEntity)((Object)iterator.next());
                if (detector.isRemoved()) {
                    iterator.remove();
                    continue;
                }
                Intrinsics.checkNotNull((Object)sender);
                Player player = (Player)sender;
                Intrinsics.checkNotNull((Object)message);
                if (!detector.processMessage(player, message)) continue;
                event.setCanceled(true);
            }
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ChatDetectorBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (blockEntity.timeOn > 0) {
                int n = blockEntity.timeOn;
                blockEntity.setTimeOn(n + -1);
                if (blockEntity.timeOn == 0) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ChatDetectorBlock.Companion.getENABLED(), (Comparable)Boolean.valueOf(false)));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

