/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.IgniterBlockEntity;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.menu.igniter.IgniterMenu;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntities;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000s\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u001c\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0002-.B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0019H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u0006/"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/IgniterBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "value", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/IgniterBlockEntity$Mode;", "mode", "getMode", "()Ldev/aaronhowser/mods/irregular_implements/block/block_entity/IgniterBlockEntity$Mode;", "setMode", "(Ldev/aaronhowser/mods/irregular_implements/block/block_entity/IgniterBlockEntity$Mode;)V", "blockUpdated", "", "isPowered", "", "wasEnabled", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "containerData", "dev/aaronhowser/mods/irregular_implements/block/block_entity/IgniterBlockEntity$containerData$1", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/IgniterBlockEntity$containerData$1;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "getUpdateTag", "pRegistries", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "Mode", "Companion", "irregular-implements-1.21.1"})
public final class IgniterBlockEntity
extends BlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Mode mode;
    @NotNull
    private final containerData.1 containerData;
    @NotNull
    public static final String MODE_NBT = "Mode";
    public static final int CONTAINER_DATA_SIZE = 1;
    public static final int MODE_INDEX = 0;

    public IgniterBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntities.INSTANCE.getIGNITER().get(), pPos, pBlockState);
        this.mode = Mode.TOGGLE;
        this.containerData = new ContainerData(this){
            final /* synthetic */ IgniterBlockEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public void set(int index, int value) {
                Mode mode;
                if (index == 0) {
                    mode = (Mode)((Object)CollectionsKt.getOrNull((List)((List)Mode.getEntries()), (int)value));
                    if (mode == null) {
                        mode = Mode.TOGGLE;
                    }
                } else {
                    throw new IllegalStateException(("Unknown index: " + index).toString());
                }
                IgniterBlockEntity.access$setMode(this.this$0, mode);
            }

            public int get(int index) {
                if (index != 0) {
                    throw new IllegalStateException(("Unknown index: " + index).toString());
                }
                return this.this$0.getMode().ordinal();
            }

            public int getCount() {
                return 1;
            }
        };
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    private final void setMode(Mode value) {
        this.mode = value;
        this.setChanged();
    }

    public final void blockUpdated(boolean isPowered, boolean wasEnabled) {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        boolean isTurningOn = isPowered && !wasEnabled;
        boolean isTurningOff = !isPowered && wasEnabled;
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!isPowered) break;
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                BlockState blockState = this.getBlockState();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                Companion.ignite(level2, blockPos, blockState);
                break;
            }
            case 2: {
                if (!isTurningOn) break;
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                BlockState blockState = this.getBlockState();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                Companion.ignite(level2, blockPos, blockState);
                break;
            }
            case 3: {
                if (isTurningOn) {
                    BlockPos blockPos = this.getBlockPos();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                    BlockState blockState = this.getBlockState();
                    Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                    Companion.ignite(level2, blockPos, blockState);
                    break;
                }
                if (!isTurningOff) break;
                BlockPos blockPos = this.getBlockPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                BlockState blockState = this.getBlockState();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
                Companion.extinguish(level2, blockPos, blockState);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putInt(MODE_NBT, this.mode.ordinal());
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.setMode((Mode)((Object)Mode.getEntries().get(tag.getInt(MODE_NBT))));
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new IgniterMenu(containerId, this.containerData);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    public static final /* synthetic */ void access$setMode(IgniterBlockEntity $this, Mode value) {
        $this.setMode(value);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/IgniterBlockEntity$Companion;", "", "<init>", "()V", "MODE_NBT", "", "ignite", "", "level", "Lnet/minecraft/world/level/Level;", "igniterPos", "Lnet/minecraft/core/BlockPos;", "igniterState", "Lnet/minecraft/world/level/block/state/BlockState;", "extinguish", "CONTAINER_DATA_SIZE", "", "MODE_INDEX", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void ignite(@NotNull Level level, @NotNull BlockPos igniterPos, @NotNull BlockState igniterState) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)igniterPos, (String)"igniterPos");
            Intrinsics.checkNotNullParameter((Object)igniterState, (String)"igniterState");
            if (level.isClientSide) {
                return;
            }
            Direction facing = (Direction)igniterState.getValue((Property)DirectionalBlock.FACING);
            BlockPos targetPos = igniterPos.relative(facing);
            BlockState targetState = level.getBlockState(targetPos);
            boolean canPlaceFire = targetState.canBeReplaced();
            if (canPlaceFire) {
                Block block = Blocks.FIRE;
                Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.FireBlock");
                BlockState fireState = ((FireBlock)block).getStateForPlacement((BlockGetter)level, targetPos);
                level.setBlockAndUpdate(targetPos, fireState);
            }
        }

        public final void extinguish(@NotNull Level level, @NotNull BlockPos igniterPos, @NotNull BlockState igniterState) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)igniterPos, (String)"igniterPos");
            Intrinsics.checkNotNullParameter((Object)igniterState, (String)"igniterState");
            if (level.isClientSide) {
                return;
            }
            Direction facing = (Direction)igniterState.getValue((Property)DirectionalBlock.FACING);
            BlockPos targetPos = igniterPos.relative(facing);
            BlockState targetState = level.getBlockState(targetPos);
            if (targetState.is(BlockTags.FIRE)) {
                level.removeBlock(targetPos, false);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/IgniterBlockEntity$Mode;", "", "nameComponent", "Lnet/minecraft/network/chat/Component;", "<init>", "(Ljava/lang/String;ILnet/minecraft/network/chat/Component;)V", "getNameComponent", "()Lnet/minecraft/network/chat/Component;", "TOGGLE", "IGNITE", "KEEP_IGNITED", "irregular-implements-1.21.1"})
    public static final class Mode
    extends Enum<Mode> {
        @NotNull
        private final Component nameComponent;
        public static final /* enum */ Mode TOGGLE = new Mode((Component)ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.igniter_toggle", new Object[0]));
        public static final /* enum */ Mode IGNITE = new Mode((Component)ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.igniter_ignite", new Object[0]));
        public static final /* enum */ Mode KEEP_IGNITED = new Mode((Component)ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.igniter_keep_ignited", new Object[0]));
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Mode(Component nameComponent) {
            this.nameComponent = nameComponent;
        }

        @NotNull
        public final Component getNameComponent() {
            return this.nameComponent;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.TOGGLE, Mode.IGNITE, Mode.KEEP_IGNITED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.KEEP_IGNITED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.IGNITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.TOGGLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

