/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.base.ImprovedSimpleContainer;
import dev.aaronhowser.mods.irregular_implements.menu.notification_interface.NotificationInterfaceMenu;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.SendClientToast;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.UpdateClientScreenString;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntities;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010#\u001a\u00020\u001aJ\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/NotificationInterfaceBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "value", "Ljava/util/UUID;", "ownerUuid", "getOwnerUuid", "()Ljava/util/UUID;", "setOwnerUuid", "(Ljava/util/UUID;)V", "", "toastTitle", "getToastTitle", "()Ljava/lang/String;", "setToastTitle", "(Ljava/lang/String;)V", "toastDescription", "getToastDescription", "setToastDescription", "sendStringUpdate", "", "container", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/base/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/irregular_implements/block/block_entity/base/ImprovedSimpleContainer;", "icon", "Lnet/minecraft/world/item/ItemStack;", "getIcon", "()Lnet/minecraft/world/item/ItemStack;", "notifyOwner", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "Companion", "irregular-implements-1.21.1"})
public final class NotificationInterfaceBlockEntity
extends BlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private UUID ownerUuid;
    @NotNull
    private String toastTitle;
    @NotNull
    private String toastDescription;
    @NotNull
    private final ImprovedSimpleContainer container;
    @NotNull
    public static final String TOAST_TITLE_NBT = "ToastTitle";
    @NotNull
    public static final String TOAST_DESCRIPTION_NBT = "ToastDescription";
    @NotNull
    public static final String OWNER_UUID_NBT = "OwnerUUID";

    public NotificationInterfaceBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntities.INSTANCE.getNOTIFICATION_INTERFACE().get(), pPos, pBlockState);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.ownerUuid = uUID;
        this.toastTitle = "";
        this.toastDescription = "";
        this.container = new ImprovedSimpleContainer(this, 1);
    }

    @NotNull
    public final UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public final void setOwnerUuid(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.ownerUuid = value;
        this.setChanged();
    }

    @NotNull
    public final String getToastTitle() {
        return this.toastTitle;
    }

    public final void setToastTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.toastTitle = value;
        this.setChanged();
        this.sendStringUpdate();
    }

    @NotNull
    public final String getToastDescription() {
        return this.toastDescription;
    }

    public final void setToastDescription(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.toastDescription = value;
        this.setChanged();
        this.sendStringUpdate();
    }

    public final void sendStringUpdate() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        UpdateClientScreenString titlePacket = new UpdateClientScreenString(0, this.toastTitle);
        Vec3 vec3 = this.getBlockPos().getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        titlePacket.messageNearbyPlayers(level2, vec3, 16.0);
        UpdateClientScreenString descriptionPacket = new UpdateClientScreenString(1, this.toastDescription);
        Vec3 vec32 = this.getBlockPos().getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getCenter(...)");
        descriptionPacket.messageNearbyPlayers(level2, vec32, 16.0);
    }

    @NotNull
    public final ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    @NotNull
    public final ItemStack getIcon() {
        ItemStack itemStack = this.container.getItem(0);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        return itemStack;
    }

    public final void notifyOwner() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        ServerPlayer serverPlayer = level2.getServer().getPlayerList().getPlayer(this.ownerUuid);
        if (serverPlayer == null) {
            return;
        }
        ServerPlayer owner = serverPlayer;
        SendClientToast packet = new SendClientToast(this.toastTitle, this.toastDescription, this.getIcon());
        packet.messagePlayer(owner);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putUUID(OWNER_UUID_NBT, this.ownerUuid);
        tag.putString(TOAST_TITLE_NBT, this.toastTitle);
        tag.putString(TOAST_DESCRIPTION_NBT, this.toastDescription);
        if (!this.container.isEmpty()) {
            ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.container.getItems(), (HolderLookup.Provider)registries);
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        UUID uuid = OtherUtil.INSTANCE.getUuidOrNull(tag, OWNER_UUID_NBT);
        if (uuid != null) {
            this.setOwnerUuid(uuid);
        }
        String string = tag.getString(TOAST_TITLE_NBT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.setToastTitle(string);
        String string2 = tag.getString(TOAST_DESCRIPTION_NBT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this.setToastDescription(string2);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.container.getItems(), (HolderLookup.Provider)registries);
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Container container2 = (Container)this.container;
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        ContainerLevelAccess containerLevelAccess = ContainerLevelAccess.create((Level)level, (BlockPos)this.getBlockPos());
        Intrinsics.checkNotNullExpressionValue((Object)containerLevelAccess, (String)"create(...)");
        return new NotificationInterfaceMenu(containerId, playerInventory, container2, containerLevelAccess);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/NotificationInterfaceBlockEntity$Companion;", "", "<init>", "()V", "TOAST_TITLE_NBT", "", "TOAST_DESCRIPTION_NBT", "OWNER_UUID_NBT", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

