/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.PeaceCandleCarrier;
import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntities;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PeaceCandleBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "irregular-implements-1.21.1"})
public final class PeaceCandleBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public PeaceCandleBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntities.INSTANCE.getPEACE_CANDLE().get(), pPos, pBlockState);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PeaceCandleBlockEntity$Companion;", "", "<init>", "()V", "getPeaceCandleChunks", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "Ldev/aaronhowser/mods/irregular_implements/PeaceCandleCarrier;", "chunkIsPreventingMonsterSpawns", "", "level", "Lnet/minecraft/world/level/LevelReader;", "blockPos", "Lnet/minecraft/core/BlockPos;", "onSpawnPlacementCheck", "", "event", "Lnet/neoforged/neoforge/event/entity/living/MobSpawnEvent$SpawnPlacementCheck;", "tick", "Lnet/minecraft/world/level/Level;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PeaceCandleBlockEntity;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongOpenHashSet getPeaceCandleChunks(@NotNull PeaceCandleCarrier $this$getPeaceCandleChunks) {
            Intrinsics.checkNotNullParameter((Object)$this$getPeaceCandleChunks, (String)"<this>");
            LongOpenHashSet longOpenHashSet = $this$getPeaceCandleChunks.irregular_implements$getPeaceCandleChunks();
            Intrinsics.checkNotNullExpressionValue((Object)longOpenHashSet, (String)"irregular_implements$getPeaceCandleChunks(...)");
            return longOpenHashSet;
        }

        public final boolean chunkIsPreventingMonsterSpawns(@NotNull LevelReader level, @NotNull BlockPos blockPos) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            if (!level.isAreaLoaded(blockPos, 1)) {
                return false;
            }
            if (!(level instanceof PeaceCandleCarrier)) {
                return false;
            }
            long chunkPos = level.getChunk(blockPos).getPos().toLong();
            return this.getPeaceCandleChunks((PeaceCandleCarrier)level).contains(chunkPos);
        }

        public final void onSpawnPlacementCheck(@NotNull MobSpawnEvent.SpawnPlacementCheck event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getSpawnType() != MobSpawnType.NATURAL || event.getResult() == MobSpawnEvent.SpawnPlacementCheck.Result.FAIL || event.getEntityType().getCategory().isFriendly()) {
                return;
            }
            ServerLevelAccessor serverLevelAccessor = event.getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevelAccessor, (String)"getLevel(...)");
            LevelReader levelReader = (LevelReader)serverLevelAccessor;
            BlockPos blockPos = event.getPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            if (this.chunkIsPreventingMonsterSpawns(levelReader, blockPos)) {
                event.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
            }
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull PeaceCandleBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (!(level instanceof PeaceCandleCarrier)) {
                return;
            }
            ChunkPos chunkPos = new ChunkPos(blockPos.getX() >> 4, blockPos.getZ() >> 4);
            Integer checkRadius = (Integer)ServerConfig.Companion.getCONFIG().getPeaceCandleChunkRadius().get();
            int chunkX = chunkPos.x;
            int chunkZ = chunkPos.z;
            Intrinsics.checkNotNull((Object)checkRadius);
            int x = chunkX - checkRadius;
            int n = chunkX + checkRadius;
            if (x <= n) {
                while (true) {
                    int n2;
                    int z;
                    if ((z = chunkZ - checkRadius) <= (n2 = chunkZ + checkRadius)) {
                        while (true) {
                            this.getPeaceCandleChunks((PeaceCandleCarrier)level).add(ChunkPos.asLong((int)x, (int)z));
                            if (z == n2) break;
                            ++z;
                        }
                    }
                    if (x == n) break;
                    ++x;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

