/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntities;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.PlayerOffhandInvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0003+,-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0018\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020$H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006."}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PlayerInterfaceBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "ownerUuid", "Ljava/util/UUID;", "getOwnerUuid", "()Ljava/util/UUID;", "setOwnerUuid", "(Ljava/util/UUID;)V", "ownerHead", "Lnet/minecraft/world/item/ItemStack;", "getOwnerHead", "()Lnet/minecraft/world/item/ItemStack;", "setOwnerHead", "(Lnet/minecraft/world/item/ItemStack;)V", "getPlayer", "Lnet/minecraft/world/entity/player/Player;", "getItemHandler", "Lnet/neoforged/neoforge/items/IItemHandler;", "direction", "Lnet/minecraft/core/Direction;", "getHotbarHandler", "owner", "getMainHandler", "getOffhandHandler", "getArmorHandler", "loadAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "getUpdateTag", "pRegistries", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "InventorySection", "LimitedInventoryWrapper", "Companion", "irregular-implements-1.21.1"})
public final class PlayerInterfaceBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private UUID ownerUuid;
    @NotNull
    private ItemStack ownerHead;
    @NotNull
    public static final String OWNER_UUID_NBT = "OwnerUuid";
    @NotNull
    public static final String OWNER_HEAD_NBT = "OwnerHead";
    @NotNull
    private static Function2<? super Player, ? super BlockEntity, Boolean> PLAYER_PREDICATE = PlayerInterfaceBlockEntity::PLAYER_PREDICATE$lambda$0;

    public PlayerInterfaceBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntities.INSTANCE.getPLAYER_INTERFACE().get(), pPos, pBlockState);
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.ownerUuid = uUID;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.ownerHead = itemStack;
    }

    @NotNull
    public final UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public final void setOwnerUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.ownerUuid = uUID;
    }

    @NotNull
    public final ItemStack getOwnerHead() {
        return this.ownerHead;
    }

    public final void setOwnerHead(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.ownerHead = itemStack;
    }

    private final Player getPlayer() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return null;
        }
        ServerLevel level2 = serverLevel;
        return (Player)level2.getServer().getPlayerList().getPlayer(this.ownerUuid);
    }

    @Nullable
    public final IItemHandler getItemHandler(@Nullable Direction direction) {
        Player player = this.getPlayer();
        if (player == null) {
            return null;
        }
        Player owner = player;
        if (!((Boolean)PLAYER_PREDICATE.invoke((Object)owner, (Object)this)).booleanValue()) {
            return null;
        }
        InventorySection section = InventorySection.Companion.fromDirection(direction);
        return switch (WhenMappings.$EnumSwitchMapping$0[section.ordinal()]) {
            case 1 -> this.getArmorHandler(owner);
            case 2 -> this.getHotbarHandler(owner);
            case 3 -> this.getOffhandHandler(owner);
            case 4 -> this.getMainHandler(owner);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final IItemHandler getHotbarHandler(Player owner) {
        Inventory inventory = owner.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
        return (IItemHandler)new LimitedInventoryWrapper(inventory, 0, 9);
    }

    private final IItemHandler getMainHandler(Player owner) {
        Inventory inventory = owner.getInventory();
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
        return (IItemHandler)new LimitedInventoryWrapper(inventory, 9, 27);
    }

    private final IItemHandler getOffhandHandler(Player owner) {
        return (IItemHandler)new PlayerOffhandInvWrapper(owner.getInventory());
    }

    private final IItemHandler getArmorHandler(Player owner) {
        return (IItemHandler)new PlayerArmorInvWrapper(owner.getInventory());
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        UUID uuid = OtherUtil.INSTANCE.getUuidOrNull(tag, OWNER_UUID_NBT);
        if (uuid != null) {
            this.ownerUuid = uuid;
        }
        if (tag.contains(OWNER_HEAD_NBT)) {
            ItemStack itemStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(OWNER_HEAD_NBT));
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"parseOptional(...)");
            this.ownerHead = itemStack;
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putUUID(OWNER_UUID_NBT, this.ownerUuid);
        tag.put(OWNER_HEAD_NBT, this.ownerHead.saveOptional(registries));
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    private static final boolean PLAYER_PREDICATE$lambda$0(Player player, BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"<unused var>");
        return true;
    }

    @JvmStatic
    public static final void setPlayerPredicate(@NotNull Function2<? super Player, ? super BlockEntity, Boolean> predicate) {
        Companion.setPlayerPredicate(predicate);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\"\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PlayerInterfaceBlockEntity$Companion;", "", "<init>", "()V", "OWNER_UUID_NBT", "", "OWNER_HEAD_NBT", "getCapability", "Lnet/neoforged/neoforge/items/IItemHandler;", "playerInterfaceBlockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PlayerInterfaceBlockEntity;", "direction", "Lnet/minecraft/core/Direction;", "PLAYER_PREDICATE", "Lkotlin/Function2;", "Lnet/minecraft/world/entity/player/Player;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "", "setPlayerPredicate", "", "predicate", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final IItemHandler getCapability(@NotNull PlayerInterfaceBlockEntity playerInterfaceBlockEntity, @Nullable Direction direction) {
            Intrinsics.checkNotNullParameter((Object)((Object)playerInterfaceBlockEntity), (String)"playerInterfaceBlockEntity");
            return playerInterfaceBlockEntity.getItemHandler(direction);
        }

        @JvmStatic
        public final void setPlayerPredicate(@NotNull Function2<? super Player, ? super BlockEntity, Boolean> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            PLAYER_PREDICATE = predicate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PlayerInterfaceBlockEntity$InventorySection;", "", "<init>", "(Ljava/lang/String;I)V", "ARMOR", "HOTBAR", "OFFHAND", "MAIN", "Companion", "irregular-implements-1.21.1"})
    private static final class InventorySection
    extends Enum<InventorySection> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ InventorySection ARMOR;
        public static final /* enum */ InventorySection HOTBAR;
        public static final /* enum */ InventorySection OFFHAND;
        public static final /* enum */ InventorySection MAIN;
        private static final /* synthetic */ InventorySection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static InventorySection[] values() {
            return (InventorySection[])$VALUES.clone();
        }

        public static InventorySection valueOf(String value) {
            return Enum.valueOf(InventorySection.class, value);
        }

        @NotNull
        public static EnumEntries<InventorySection> getEntries() {
            return $ENTRIES;
        }

        static {
            ARMOR = new InventorySection();
            HOTBAR = new InventorySection();
            OFFHAND = new InventorySection();
            MAIN = new InventorySection();
            $VALUES = inventorySectionArray = new InventorySection[]{InventorySection.ARMOR, InventorySection.HOTBAR, InventorySection.OFFHAND, InventorySection.MAIN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PlayerInterfaceBlockEntity$InventorySection$Companion;", "", "<init>", "()V", "fromDirection", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PlayerInterfaceBlockEntity$InventorySection;", "direction", "Lnet/minecraft/core/Direction;", "irregular-implements-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final InventorySection fromDirection(@Nullable Direction direction) {
                Direction direction2 = direction;
                return switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
                    case 1 -> ARMOR;
                    case 2 -> HOTBAR;
                    case 3 -> OFFHAND;
                    default -> MAIN;
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Direction.values().length];
                    try {
                        nArray[Direction.UP.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Direction.DOWN.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[Direction.NORTH.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/PlayerInterfaceBlockEntity$LimitedInventoryWrapper;", "Lnet/neoforged/neoforge/items/wrapper/RangedWrapper;", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "minSlot", "", "maxSlot", "<init>", "(Lnet/minecraft/world/entity/player/Inventory;II)V", "insertItem", "Lnet/minecraft/world/item/ItemStack;", "slot", "stack", "simulate", "", "irregular-implements-1.21.1"})
    private static final class LimitedInventoryWrapper
    extends RangedWrapper {
        @NotNull
        private final Inventory inventory;

        public LimitedInventoryWrapper(@NotNull Inventory inventory, int minSlot, int maxSlot) {
            Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
            super((IItemHandlerModifiable)new InvWrapper((Container)inventory), minSlot, maxSlot);
            this.inventory = inventory;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            ItemStack inSlot;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            ItemStack rest = super.insertItem(slot, stack, simulate);
            if (rest.getCount() != stack.getCount() && !(inSlot = this.getStackInSlot(slot)).isEmpty()) {
                Player player = this.inventory.player;
                if (player.level().isClientSide) {
                    inSlot.setPopTime(5);
                } else if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).containerMenu.broadcastChanges();
                }
            }
            Intrinsics.checkNotNull((Object)rest);
            return rest;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InventorySection.values().length];
            try {
                nArray[InventorySection.ARMOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventorySection.HOTBAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventorySection.OFFHAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventorySection.MAIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

