/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.aaronhowser.mods.irregular_implements.util.RenderUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/CubeIndicatorRenderer;", "", "<init>", "()V", "indicators", "", "Ldev/aaronhowser/mods/irregular_implements/client/render/CubeIndicatorRenderer$Indicator;", "addIndicator", "", "target", "Lnet/minecraft/core/BlockPos;", "duration", "", "color", "size", "", "removeIndicatorsAt", "afterClientTick", "event", "Lnet/neoforged/neoforge/client/event/ClientTickEvent$Post;", "onRenderLevel", "Lnet/neoforged/neoforge/client/event/RenderLevelStageEvent;", "Indicator", "irregular-implements-1.21.1"})
public final class CubeIndicatorRenderer {
    @NotNull
    public static final CubeIndicatorRenderer INSTANCE = new CubeIndicatorRenderer();
    @NotNull
    private static final List<Indicator> indicators = new ArrayList();

    private CubeIndicatorRenderer() {
    }

    public final void addIndicator(@NotNull BlockPos target, int duration, int color, float size) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        indicators.add(new Indicator(target, duration, color, size));
    }

    public static /* synthetic */ void addIndicator$default(CubeIndicatorRenderer cubeIndicatorRenderer, BlockPos blockPos, int n, int n2, float f, int n3, Object object) {
        if ((n3 & 8) != 0) {
            f = 0.99f;
        }
        cubeIndicatorRenderer.addIndicator(blockPos, n, n2, f);
    }

    public final void removeIndicatorsAt(@NotNull BlockPos target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        indicators.removeIf(arg_0 -> CubeIndicatorRenderer.removeIndicatorsAt$lambda$1(arg_0 -> CubeIndicatorRenderer.removeIndicatorsAt$lambda$0(target, arg_0), arg_0));
    }

    public final void afterClientTick(@NotNull ClientTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        Iterator<Indicator> iterator = indicators.iterator();
        while (iterator.hasNext()) {
            Indicator indicator = iterator.next();
            int n = indicator.getDuration();
            indicator.setDuration(n + -1);
            if (indicator.getDuration() > 0) continue;
            iterator.remove();
        }
    }

    public final void onRenderLevel(@NotNull RenderLevelStageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getStage(), (Object)RenderLevelStageEvent.Stage.AFTER_LEVEL)) {
            return;
        }
        if (indicators.isEmpty()) {
            return;
        }
        Vec3 cameraPos = event.getCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        for (Indicator indicator : indicators) {
            Intrinsics.checkNotNull((Object)poseStack);
            Vec3 vec3 = indicator.getTarget().getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            RenderUtil.INSTANCE.renderDebugCube(poseStack, vec3, indicator.getSize(), indicator.getColor());
        }
        poseStack.popPose();
    }

    private static final boolean removeIndicatorsAt$lambda$0(BlockPos $target, Indicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getTarget(), (Object)$target);
    }

    private static final boolean removeIndicatorsAt$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/CubeIndicatorRenderer$Indicator;", "", "target", "Lnet/minecraft/core/BlockPos;", "duration", "", "color", "size", "", "<init>", "(Lnet/minecraft/core/BlockPos;IIF)V", "getTarget", "()Lnet/minecraft/core/BlockPos;", "getDuration", "()I", "setDuration", "(I)V", "getColor", "getSize", "()F", "irregular-implements-1.21.1"})
    private static final class Indicator {
        @NotNull
        private final BlockPos target;
        private int duration;
        private final int color;
        private final float size;

        public Indicator(@NotNull BlockPos target, int duration, int color, float size) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
            this.duration = duration;
            this.color = color;
            this.size = size;
        }

        @NotNull
        public final BlockPos getTarget() {
            return this.target;
        }

        public final int getDuration() {
            return this.duration;
        }

        public final void setDuration(int n) {
            this.duration = n;
        }

        public final int getColor() {
            return this.color;
        }

        public final float getSize() {
            return this.size;
        }
    }
}

