/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.compatibility.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002&'B]\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "id", "Lnet/minecraft/resources/ResourceLocation;", "recipePattern", "", "mutations", "", "Lnet/minecraft/world/item/ItemStack;", "patternKeys", "", "Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue;", "virtualInput", "", "Ldev/emi/emi/api/stack/EmiIngredient;", "virtualOutputs", "<init>", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "getInputs", "getOutputs", "Ldev/emi/emi/api/stack/EmiStack;", "getDisplayWidth", "", "getDisplayHeight", "supportsRecipeTree", "", "uniqueId", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "getMutatingStack", "random", "Ljava/util/Random;", "isInput", "PatternValue", "Builder", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nMutatingEmiRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutatingEmiRecipe.kt\ndev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1#2:156\n1563#3:157\n1634#3,3:158\n*S KotlinDebug\n*F\n+ 1 MutatingEmiRecipe.kt\ndev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe\n*L\n91#1:157\n91#1:158,3\n*E\n"})
public final class MutatingEmiRecipe
implements EmiRecipe {
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private final String recipePattern;
    @NotNull
    private final Map<ItemStack, ItemStack> mutations;
    @NotNull
    private final Map<Character, PatternValue> patternKeys;
    @NotNull
    private final List<EmiIngredient> virtualInput;
    @NotNull
    private final List<ItemStack> virtualOutputs;
    private final int uniqueId;

    private MutatingEmiRecipe(ResourceLocation id, String recipePattern, Map<ItemStack, ItemStack> mutations, Map<Character, ? extends PatternValue> patternKeys, List<? extends EmiIngredient> virtualInput, List<ItemStack> virtualOutputs) {
        this.id = id;
        this.recipePattern = recipePattern;
        this.mutations = mutations;
        this.patternKeys = patternKeys;
        this.virtualInput = virtualInput;
        this.virtualOutputs = virtualOutputs;
        if (!(this.recipePattern.length() <= 9)) {
            boolean bl = false;
            String string = "Recipe pattern must be 9 characters long or less";
            throw new IllegalArgumentException(string.toString());
        }
        this.uniqueId = new Random().nextInt();
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        EmiRecipeCategory emiRecipeCategory = VanillaEmiRecipeCategories.CRAFTING;
        Intrinsics.checkNotNullExpressionValue((Object)emiRecipeCategory, (String)"CRAFTING");
        return emiRecipeCategory;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        return this.virtualInput;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<EmiStack> getOutputs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.virtualOutputs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ItemStack itemStack = (ItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(EmiStack.of((ItemStack)it));
        }
        return (List)destination$iv$iv;
    }

    public int getDisplayWidth() {
        return 118;
    }

    public int getDisplayHeight() {
        return 54;
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 60, 18);
        widgets.addTexture(EmiTexture.SHAPELESS, 97, 0);
        for (int i = 0; i < 9; ++i) {
            SlotWidget slotWidget;
            int x = i % 3 * 18;
            int y = i / 3 * 18;
            Character patternChar = StringsKt.getOrNull((CharSequence)this.recipePattern, (int)i);
            PatternValue patternValue = this.patternKeys.getOrDefault(patternChar, PatternValue.EmptyValue.INSTANCE);
            PatternValue patternValue2 = patternValue;
            if (patternValue2 instanceof PatternValue.EmptyValue) {
                slotWidget = widgets.addSlot(x, y);
                continue;
            }
            if (patternValue2 instanceof PatternValue.IngredientValue) {
                slotWidget = widgets.addSlot(EmiIngredient.of((Ingredient)((PatternValue.IngredientValue)patternValue).getIngredient()), x, y);
                continue;
            }
            if (patternValue2 instanceof PatternValue.MutatingValue) {
                slotWidget = (SlotWidget)widgets.addGeneratedSlot(arg_0 -> MutatingEmiRecipe.addWidgets$lambda$2(this, arg_0), this.uniqueId, x, y);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        widgets.addGeneratedSlot(arg_0 -> MutatingEmiRecipe.addWidgets$lambda$3(this, arg_0), this.uniqueId, 92, 14).large(true).recipeContext((EmiRecipe)this);
    }

    private final EmiStack getMutatingStack(Random random, boolean isInput) {
        int randomIndex = random.nextInt(this.mutations.size());
        Map.Entry pair = (Map.Entry)CollectionsKt.elementAt((Iterable)this.mutations.entrySet(), (int)randomIndex);
        EmiStack emiStack = EmiStack.of((ItemStack)(isInput ? (ItemStack)pair.getKey() : (ItemStack)pair.getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
        return emiStack;
    }

    private static final EmiIngredient addWidgets$lambda$2(MutatingEmiRecipe this$0, Random random) {
        Intrinsics.checkNotNull((Object)random);
        return (EmiIngredient)this$0.getMutatingStack(random, true);
    }

    private static final EmiIngredient addWidgets$lambda$3(MutatingEmiRecipe this$0, Random random) {
        Intrinsics.checkNotNull((Object)random);
        return (EmiIngredient)this$0.getMutatingStack(random, false);
    }

    public /* synthetic */ MutatingEmiRecipe(ResourceLocation id, String recipePattern, Map mutations, Map patternKeys, List virtualInput, List virtualOutputs, DefaultConstructorMarker $constructor_marker) {
        this(id, recipePattern, mutations, patternKeys, virtualInput, virtualOutputs);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u001a\u0010\u0010\u001a\u00020\u00002\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0011J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000eJ\u001f\u0010\u000f\u001a\u00020\u00002\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0019\"\u00020\u000e\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$Builder;", "", "<init>", "()V", "recipePattern", "", "patternKeys", "", "", "Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue;", "virtualInput", "", "Ldev/emi/emi/api/stack/EmiIngredient;", "mutations", "Lnet/minecraft/world/item/ItemStack;", "virtualOutputs", "associations", "", "patternKey", "key", "patternValue", "input", "Lnet/minecraft/world/item/crafting/Ingredient;", "itemStack", "output", "", "([Lnet/minecraft/world/item/ItemStack;)Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$Builder;", "build", "Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe;", "id", "Lnet/minecraft/resources/ResourceLocation;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nMutatingEmiRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutatingEmiRecipe.kt\ndev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$Builder\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,155:1\n488#2,11:156\n*S KotlinDebug\n*F\n+ 1 MutatingEmiRecipe.kt\ndev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$Builder\n*L\n45#1:156,11\n*E\n"})
    public static final class Builder {
        @NotNull
        private String recipePattern = "";
        @NotNull
        private final Map<Character, PatternValue> patternKeys = new LinkedHashMap();
        @NotNull
        private final List<EmiIngredient> virtualInput = new ArrayList();
        @NotNull
        private final Map<ItemStack, ItemStack> mutations = new LinkedHashMap();
        @NotNull
        private final List<ItemStack> virtualOutputs = new ArrayList();

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder recipePattern(@NotNull String recipePattern) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Intrinsics.checkNotNullParameter((Object)recipePattern, (String)"recipePattern");
            String string = recipePattern;
            Builder builder = this;
            boolean $i$f$filterNot = false;
            CharSequence charSequence = (CharSequence)$this$filterNot$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterNotTo = false;
            for (int i = 0; i < $this$filterNotTo$iv$iv.length(); ++i) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(i);
                boolean bl = false;
                if (it == ',') continue;
                destination$iv$iv.append(element$iv$iv);
            }
            builder.recipePattern = ((StringBuilder)destination$iv$iv).toString();
            return this;
        }

        @NotNull
        public final Builder associations(@NotNull Map<ItemStack, ItemStack> mutations) {
            Intrinsics.checkNotNullParameter(mutations, (String)"mutations");
            this.mutations.putAll(mutations);
            return this;
        }

        @NotNull
        public final Builder patternKey(char key, @NotNull PatternValue patternValue) {
            Intrinsics.checkNotNullParameter((Object)patternValue, (String)"patternValue");
            Character c = Character.valueOf(key);
            this.patternKeys.put(c, patternValue);
            return this;
        }

        @NotNull
        public final Builder virtualInput(@NotNull Ingredient input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)input);
            Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
            this.virtualInput.add(emiIngredient);
            return this;
        }

        @NotNull
        public final Builder virtualInput(@NotNull ItemStack itemStack) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            ItemStack[] itemStackArray = new ItemStack[]{itemStack};
            Ingredient ingredient = Ingredient.of((ItemStack[])itemStackArray);
            Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
            return this.virtualInput(ingredient);
        }

        @NotNull
        public final Builder virtualOutputs(ItemStack ... output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            CollectionsKt.addAll((Collection)this.virtualOutputs, (Object[])output);
            return this;
        }

        @NotNull
        public final MutatingEmiRecipe build(@NotNull ResourceLocation id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new MutatingEmiRecipe(id, this.recipePattern, this.mutations, this.patternKeys, this.virtualInput, this.virtualOutputs, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue;", "", "IngredientValue", "EmptyValue", "MutatingValue", "Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue$EmptyValue;", "Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue$IngredientValue;", "Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue$MutatingValue;", "irregular-implements-1.21.1"})
    public static sealed interface PatternValue {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue$EmptyValue;", "Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "irregular-implements-1.21.1"})
        public static final class EmptyValue
        implements PatternValue {
            @NotNull
            public static final EmptyValue INSTANCE = new EmptyValue();

            private EmptyValue() {
            }

            @NotNull
            public String toString() {
                return "EmptyValue";
            }

            public int hashCode() {
                return 805599253;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EmptyValue)) {
                    return false;
                }
                EmptyValue cfr_ignored_0 = (EmptyValue)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue$IngredientValue;", "Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue;", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "<init>", "(Lnet/minecraft/world/item/crafting/Ingredient;)V", "stack", "Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/world/item/ItemStack;)V", "getIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "irregular-implements-1.21.1"})
        public static final class IngredientValue
        implements PatternValue {
            @NotNull
            private final Ingredient ingredient;

            public IngredientValue(@NotNull Ingredient ingredient) {
                Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
                this.ingredient = ingredient;
            }

            @NotNull
            public final Ingredient getIngredient() {
                return this.ingredient;
            }

            public IngredientValue(@NotNull ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                ItemStack[] itemStackArray = new ItemStack[]{stack};
                Ingredient ingredient = Ingredient.of((ItemStack[])itemStackArray);
                Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
                this(ingredient);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue$MutatingValue;", "Ldev/aaronhowser/mods/irregular_implements/compatibility/emi/recipe/MutatingEmiRecipe$PatternValue;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "irregular-implements-1.21.1"})
        public static final class MutatingValue
        implements PatternValue {
            @NotNull
            public static final MutatingValue INSTANCE = new MutatingValue();

            private MutatingValue() {
            }

            @NotNull
            public String toString() {
                return "MutatingValue";
            }

            public int hashCode() {
                return 833274653;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MutatingValue)) {
                    return false;
                }
                MutatingValue cfr_ignored_0 = (MutatingValue)other;
                return true;
            }
        }
    }
}

