/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModFluidTagsProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.FallLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J,\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010*H\u0007J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J\u0012\u0010;\u001a\u0004\u0018\u00010:2\u0006\u0010<\u001a\u00020&H\u0007J\u0010\u0010=\u001a\u00020>2\u0006\u0010<\u001a\u00020&H\u0007J\u000e\u0010?\u001a\u0002062\u0006\u00107\u001a\u00020@J\u0010\u0010A\u001a\u00020$2\u0006\u0010<\u001a\u00020&H\u0002J\u000e\u0010B\u001a\u00020$2\u0006\u0010<\u001a\u00020&R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\u001f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R\u0011\u0010!\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013R\u001a\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020*03X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u00020:8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/ModArmorItems;", "", "<init>", "()V", "registerArmorItem", "Lnet/neoforged/neoforge/registries/DeferredItem;", "Lnet/minecraft/world/item/ArmorItem;", "name", "", "material", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/ArmorMaterial;", "type", "Lnet/minecraft/world/item/ArmorItem$Type;", "properties", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/Item$Properties;", "MAGIC_HOOD_PROPERTIES", "getMAGIC_HOOD_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "WATER_WALKING_BOOTS_PROPERTIES", "getWATER_WALKING_BOOTS_PROPERTIES", "()Ljava/util/function/Supplier;", "OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES", "getOBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES", "LAVA_WADERS_PROPERTIES", "getLAVA_WADERS_PROPERTIES", "SPECTRE_HELMET_PROPERTIES", "getSPECTRE_HELMET_PROPERTIES", "SPECTRE_CHESTPLATE_PROPERTIES", "getSPECTRE_CHESTPLATE_PROPERTIES", "SPECTRE_LEGGINGS_PROPERTIES", "getSPECTRE_LEGGINGS_PROPERTIES", "SPECTRE_BOOTS_PROPERTIES", "getSPECTRE_BOOTS_PROPERTIES", "shouldEntityStandOnFluid", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "fluidState", "Lnet/minecraft/world/level/material/FluidState;", "checkCollisionShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "original", "FLUID_SHAPES", "", "", "lubricatedTooltip", "", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "FLUID_BOOT_FALL", "Lnet/minecraft/world/damagesource/FallLocation;", "fluidWalkingFallLocation", "entity", "fluidWalkingDeathMessage", "Lnet/minecraft/network/chat/Component;", "tryBlockFireDamage", "Lnet/neoforged/neoforge/event/entity/living/LivingIncomingDamageEvent;", "canBlockFireDamage", "isWearingFullSpectreArmor", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nModArmorItems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModArmorItems.kt\ndev/aaronhowser/mods/irregular_implements/item/ModArmorItems\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 OtherUtil.kt\ndev/aaronhowser/mods/irregular_implements/util/OtherUtil\n*L\n1#1,238:1\n1761#2,3:239\n1761#2,3:242\n1761#2,3:247\n1761#2,3:250\n49#3:245\n49#3:246\n*S KotlinDebug\n*F\n+ 1 ModArmorItems.kt\ndev/aaronhowser/mods/irregular_implements/item/ModArmorItems\n*L\n126#1:239,3\n182#1:242,3\n226#1:247,3\n228#1:250,3\n182#1:245\n223#1:246\n*E\n"})
public final class ModArmorItems {
    @NotNull
    public static final ModArmorItems INSTANCE = new ModArmorItems();
    @NotNull
    private static final Item.Properties MAGIC_HOOD_PROPERTIES;
    @NotNull
    private static final Supplier<Item.Properties> WATER_WALKING_BOOTS_PROPERTIES;
    @NotNull
    private static final Supplier<Item.Properties> OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES;
    @NotNull
    private static final Supplier<Item.Properties> LAVA_WADERS_PROPERTIES;
    @NotNull
    private static final Item.Properties SPECTRE_HELMET_PROPERTIES;
    @NotNull
    private static final Item.Properties SPECTRE_CHESTPLATE_PROPERTIES;
    @NotNull
    private static final Item.Properties SPECTRE_LEGGINGS_PROPERTIES;
    @NotNull
    private static final Item.Properties SPECTRE_BOOTS_PROPERTIES;
    @NotNull
    private static final Map<Float, VoxelShape> FLUID_SHAPES;
    @JvmField
    @NotNull
    public static final FallLocation FLUID_BOOT_FALL;

    private ModArmorItems() {
    }

    @NotNull
    public final DeferredItem<ArmorItem> registerArmorItem(@NotNull String name, @NotNull Holder<ArmorMaterial> material, @NotNull ArmorItem.Type type, @NotNull Supplier<Item.Properties> properties) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        DeferredItem deferredItem = ModItems.INSTANCE.getITEM_REGISTRY().registerItem(name, arg_0 -> ModArmorItems.registerArmorItem$lambda$0(material, type, properties, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)deferredItem, (String)"registerItem(...)");
        return deferredItem;
    }

    @NotNull
    public final DeferredItem<ArmorItem> registerArmorItem(@NotNull String name, @NotNull Holder<ArmorMaterial> material, @NotNull ArmorItem.Type type, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(material, (String)"material");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        DeferredItem deferredItem = ModItems.INSTANCE.getITEM_REGISTRY().registerItem(name, arg_0 -> ModArmorItems.registerArmorItem$lambda$1(material, type, properties, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)deferredItem, (String)"registerItem(...)");
        return deferredItem;
    }

    @NotNull
    public final Item.Properties getMAGIC_HOOD_PROPERTIES() {
        return MAGIC_HOOD_PROPERTIES;
    }

    @NotNull
    public final Supplier<Item.Properties> getWATER_WALKING_BOOTS_PROPERTIES() {
        return WATER_WALKING_BOOTS_PROPERTIES;
    }

    @NotNull
    public final Supplier<Item.Properties> getOBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES() {
        return OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES;
    }

    @NotNull
    public final Supplier<Item.Properties> getLAVA_WADERS_PROPERTIES() {
        return LAVA_WADERS_PROPERTIES;
    }

    @NotNull
    public final Item.Properties getSPECTRE_HELMET_PROPERTIES() {
        return SPECTRE_HELMET_PROPERTIES;
    }

    @NotNull
    public final Item.Properties getSPECTRE_CHESTPLATE_PROPERTIES() {
        return SPECTRE_CHESTPLATE_PROPERTIES;
    }

    @NotNull
    public final Item.Properties getSPECTRE_LEGGINGS_PROPERTIES() {
        return SPECTRE_LEGGINGS_PROPERTIES;
    }

    @NotNull
    public final Item.Properties getSPECTRE_BOOTS_PROPERTIES() {
        return SPECTRE_BOOTS_PROPERTIES;
    }

    public final boolean shouldEntityStandOnFluid(@NotNull LivingEntity livingEntity, @NotNull FluidState fluidState) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
            Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
            if (livingEntity.isCrouching() || livingEntity.isUnderWater()) {
                return false;
            }
            ItemStack footArmor = livingEntity.getItemBySlot(EquipmentSlot.FEET);
            List list = (List)footArmor.get((Supplier)ModDataComponents.INSTANCE.getFLUID_TAGS());
            if (list == null) {
                return false;
            }
            List fluidTags = list;
            Iterable $this$any$iv = fluidTags;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey it = (TagKey)element$iv;
                    boolean bl2 = false;
                    if (!fluidState.is(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final VoxelShape checkCollisionShape(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context, @Nullable VoxelShape original) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context instanceof EntityCollisionContext)) {
            return null;
        }
        FluidState fluidState = level.getFluidState(pos);
        float fluidHeight = fluidState.getHeight(level, pos);
        if (fluidHeight <= 0.0f) {
            return null;
        }
        Entity entity = ((EntityCollisionContext)context).getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return null;
        }
        LivingEntity entity2 = livingEntity;
        Intrinsics.checkNotNull((Object)fluidState);
        if (!INSTANCE.shouldEntityStandOnFluid(entity2, fluidState)) {
            return null;
        }
        VoxelShape voxelShape = FLUID_SHAPES.computeIfAbsent(Float.valueOf(fluidHeight), arg_0 -> ModArmorItems.checkCollisionShape$lambda$7(ModArmorItems::checkCollisionShape$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"computeIfAbsent(...)");
        VoxelShape shape = voxelShape;
        if (!((EntityCollisionContext)context).isAbove(shape, pos, true)) {
            return null;
        }
        VoxelShape voxelShape2 = original;
        return voxelShape2 == null ? shape : Shapes.or((VoxelShape)voxelShape2, (VoxelShape)shape);
    }

    public final void lubricatedTooltip(@NotNull ItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getItemStack().has((Supplier)ModDataComponents.LUBRICATED)) {
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.lubricated", new Object[0]).withColor(16577757));
        }
    }

    @JvmStatic
    @Nullable
    public static final FallLocation fluidWalkingFallLocation(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        FluidState fluidBelow = entity.level().getFluidState(entity.blockPosition());
        Intrinsics.checkNotNull((Object)fluidBelow);
        if (!INSTANCE.shouldEntityStandOnFluid(entity, fluidBelow)) {
            return null;
        }
        return FLUID_BOOT_FALL;
    }

    @JvmStatic
    @NotNull
    public static final Component fluidWalkingDeathMessage(@NotNull LivingEntity entity) {
        Component component;
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        FluidState fluidBelow = entity.level().getFluidState(entity.blockPosition());
        ItemStack bootArmor = entity.getItemBySlot(EquipmentSlot.FEET);
        Object[] objectArray = OtherUtil.INSTANCE;
        List list = (List)bootArmor.get((Supplier)ModDataComponents.INSTANCE.getFLUID_TAGS());
        if (list != null) {
            boolean bl2;
            block9: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TagKey it = (TagKey)element$iv;
                        boolean bl3 = false;
                        if (!fluidBelow.is(it)) continue;
                        bl2 = true;
                        break block9;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = null;
        }
        Boolean $this$isTrue$iv = bl;
        boolean $i$f$isTrue = false;
        boolean bootWasResponsible = Intrinsics.areEqual($this$isTrue$iv, (Object)true);
        if (bootWasResponsible) {
            objectArray = new Object[3];
            Component component2 = entity.getDisplayName();
            if (component2 == null) {
                component2 = entity.getName();
            }
            objectArray[0] = component2;
            objectArray[1] = fluidBelow.getFluidType().getDescription();
            objectArray[2] = bootArmor.getDisplayName();
            component = (Component)ModLanguageProvider.Companion.toComponent("death.fell.accident.fluid_fall.boot", objectArray);
        } else {
            objectArray = new Object[2];
            Component component3 = entity.getDisplayName();
            if (component3 == null) {
                component3 = entity.getName();
            }
            objectArray[0] = component3;
            objectArray[1] = fluidBelow.getFluidType().getDescription();
            component = (Component)ModLanguageProvider.Companion.toComponent("death.fell.accident.fluid_fall.generic", objectArray);
        }
        return component;
    }

    public final void tryBlockFireDamage(@NotNull LivingIncomingDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled()) {
            return;
        }
        LivingEntity target = event.getEntity();
        DamageSource damageSource = event.getSource();
        if (!damageSource.is(DamageTypeTags.IS_FIRE)) {
            return;
        }
        float amount = event.getAmount();
        float chance = amount * amount * amount / (float)100;
        if (target.getRandom().nextFloat() <= chance) {
            return;
        }
        Intrinsics.checkNotNull((Object)target);
        if (this.canBlockFireDamage(target)) {
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canBlockFireDamage(LivingEntity entity) {
        boolean bl;
        block11: {
            ItemStack it;
            Iterable $this$any$iv;
            void $this$isTrue$iv;
            ItemStack footItem = entity.getItemBySlot(EquipmentSlot.FEET);
            if (footItem.is((Holder)ModItems.INSTANCE.getLAVA_WADERS()) || footItem.is((Holder)ModItems.INSTANCE.getOBSIDIAN_WATER_WALKING_BOOTS())) {
                return true;
            }
            OtherUtil otherUtil = OtherUtil.INSTANCE;
            Optional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getCuriosInventory(...)");
            ICuriosItemHandler iCuriosItemHandler = (ICuriosItemHandler)OptionalsKt.getOrNull((Optional)optional);
            iCuriosItemHandler = iCuriosItemHandler != null ? Boolean.valueOf(iCuriosItemHandler.isEquipped((Item)ModItems.INSTANCE.getOBSIDIAN_SKULL().get())) : null;
            boolean $i$f$isTrue = false;
            boolean hasObsidianSkullRing = Intrinsics.areEqual((Object)$this$isTrue$iv, (Object)true);
            if (hasObsidianSkullRing) {
                return true;
            }
            if (entity instanceof Player) {
                boolean bl2;
                block10: {
                    NonNullList nonNullList = ((Player)entity).getInventory().items;
                    Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
                    $this$any$iv = (Iterable)nonNullList;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (ItemStack)element$iv;
                            boolean bl3 = false;
                            if (!it.is((Holder)ModItems.INSTANCE.getOBSIDIAN_SKULL())) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return true;
                }
            }
            Iterable iterable = entity.getHandSlots();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getHandSlots(...)");
            $this$any$iv = iterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (ItemStack)element$iv;
                    boolean bl4 = false;
                    if (!it.is((Holder)ModItems.INSTANCE.getOBSIDIAN_SKULL())) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isWearingFullSpectreArmor(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getItemBySlot(EquipmentSlot.HEAD).is((Item)ModItems.INSTANCE.getSPECTRE_HELMET().get()) && entity.getItemBySlot(EquipmentSlot.CHEST).is((Item)ModItems.INSTANCE.getSPECTRE_CHESTPLATE().get()) && entity.getItemBySlot(EquipmentSlot.LEGS).is((Item)ModItems.INSTANCE.getSPECTRE_LEGGINGS().get()) && entity.getItemBySlot(EquipmentSlot.FEET).is((Item)ModItems.INSTANCE.getSPECTRE_BOOTS().get());
    }

    private static final ArmorItem registerArmorItem$lambda$0(Holder $material, ArmorItem.Type $type, Supplier $properties, Item.Properties it) {
        return new ArmorItem($material, $type, (Item.Properties)$properties.get());
    }

    private static final ArmorItem registerArmorItem$lambda$1(Holder $material, ArmorItem.Type $type, Item.Properties $properties, Item.Properties it) {
        return new ArmorItem($material, $type, $properties);
    }

    private static final Item.Properties WATER_WALKING_BOOTS_PROPERTIES$lambda$2() {
        return new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(15)).rarity(Rarity.RARE).component((Supplier)ModDataComponents.INSTANCE.getFLUID_TAGS(), (Object)CollectionsKt.listOf(ModFluidTagsProvider.ALLOWS_WATER_WALKING));
    }

    private static final Item.Properties OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES$lambda$3() {
        return new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(15)).rarity(Rarity.RARE).fireResistant().component((Supplier)ModDataComponents.INSTANCE.getFLUID_TAGS(), (Object)CollectionsKt.listOf(ModFluidTagsProvider.ALLOWS_WATER_WALKING));
    }

    private static final Item.Properties LAVA_WADERS_PROPERTIES$lambda$4() {
        Object[] objectArray = new TagKey[]{ModFluidTagsProvider.ALLOWS_LAVA_WALKING, ModFluidTagsProvider.ALLOWS_WATER_WALKING};
        return new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(15)).rarity(Rarity.RARE).fireResistant().component((Supplier)ModDataComponents.INSTANCE.getFLUID_TAGS(), (Object)CollectionsKt.listOf((Object[])objectArray)).component((Supplier)ModDataComponents.INSTANCE.getCHARGE(), (Object)200).component((Supplier)ModDataComponents.INSTANCE.getCOOLDOWN(), (Object)0);
    }

    private static final VoxelShape checkCollisionShape$lambda$6(Float it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(it.floatValue() * (float)16), (double)16.0);
    }

    private static final VoxelShape checkCollisionShape$lambda$7(Function1 $tmp0, Object p0) {
        return (VoxelShape)$tmp0.invoke(p0);
    }

    static {
        Item.Properties properties = new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(15)).rarity(Rarity.RARE);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"rarity(...)");
        MAGIC_HOOD_PROPERTIES = properties;
        WATER_WALKING_BOOTS_PROPERTIES = ModArmorItems::WATER_WALKING_BOOTS_PROPERTIES$lambda$2;
        OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES = ModArmorItems::OBSIDIAN_WATER_WALKING_BOOTS_PROPERTIES$lambda$3;
        LAVA_WADERS_PROPERTIES = ModArmorItems::LAVA_WADERS_PROPERTIES$lambda$4;
        Item.Properties properties2 = new Item.Properties().durability(Mth.floor((double)((double)Items.DIAMOND_HELMET.getDefaultInstance().getMaxDamage() * 1.25))).rarity(Rarity.UNCOMMON);
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"rarity(...)");
        SPECTRE_HELMET_PROPERTIES = properties2;
        Item.Properties properties3 = new Item.Properties().durability(Mth.floor((double)((double)Items.DIAMOND_CHESTPLATE.getDefaultInstance().getMaxDamage() * 1.25))).rarity(Rarity.UNCOMMON);
        Intrinsics.checkNotNullExpressionValue((Object)properties3, (String)"rarity(...)");
        SPECTRE_CHESTPLATE_PROPERTIES = properties3;
        Item.Properties properties4 = new Item.Properties().durability(Mth.floor((double)((double)Items.DIAMOND_LEGGINGS.getDefaultInstance().getMaxDamage() * 1.25))).rarity(Rarity.UNCOMMON);
        Intrinsics.checkNotNullExpressionValue((Object)properties4, (String)"rarity(...)");
        SPECTRE_LEGGINGS_PROPERTIES = properties4;
        Item.Properties properties5 = new Item.Properties().durability(Mth.floor((double)((double)Items.DIAMOND_BOOTS.getDefaultInstance().getMaxDamage() * 1.25))).rarity(Rarity.UNCOMMON);
        Intrinsics.checkNotNullExpressionValue((Object)properties5, (String)"rarity(...)");
        SPECTRE_BOOTS_PROPERTIES = properties5;
        FLUID_SHAPES = new HashMap();
        FLUID_BOOT_FALL = new FallLocation("fluid_boot_fall");
    }
}

