/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.base.RedstoneToolLinkable;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/RedstoneToolItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "Companion", "irregular-implements-1.21.1"})
public final class RedstoneToolItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public RedstoneToolItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player player2 = player;
        Level level = context.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return InteractionResult.PASS;
        }
        ServerLevel level2 = serverLevel;
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = level2.getBlockState(clickedPos);
        MutableComponent clickedBlockName = clickedState.getBlock().getName();
        BlockEntity clickedBlockEntity = level2.getBlockEntity(clickedPos);
        ItemStack usedStack = context.getItemInHand();
        if (clickedBlockEntity instanceof RedstoneToolLinkable) {
            GlobalPos locationComponent = new GlobalPos(level2.dimension(), clickedPos);
            usedStack.set((Supplier)ModDataComponents.INSTANCE.getGLOBAL_POS(), (Object)locationComponent);
            Object[] objectArray = new Object[]{clickedBlockName, clickedPos.getX(), clickedPos.getY(), clickedPos.getZ()};
            OtherUtil.INSTANCE.status(player2, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.redstone_tool.base_block_set", objectArray));
            return InteractionResult.SUCCESS;
        }
        GlobalPos locationComponent = (GlobalPos)usedStack.get((Supplier)ModDataComponents.INSTANCE.getGLOBAL_POS());
        if (locationComponent == null) {
            OtherUtil.INSTANCE.status(player2, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.redstone_tool.no_base_block", new Object[0]));
            return InteractionResult.FAIL;
        }
        if (!Intrinsics.areEqual((Object)level2.dimension(), (Object)locationComponent.dimension())) {
            OtherUtil.INSTANCE.status(player2, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.redstone_tool.wrong_dimension", new Object[0]));
            return InteractionResult.FAIL;
        }
        BlockPos baseBlockPos = locationComponent.pos();
        MutableComponent baseBlockName = level2.getBlockState(baseBlockPos).getBlock().getName();
        BlockEntity baseBlockEntity = level2.getBlockEntity(baseBlockPos);
        if (!(baseBlockEntity instanceof RedstoneToolLinkable)) {
            Object[] objectArray = new Object[]{baseBlockName, level2.getBlockState(baseBlockPos).getBlock().getName()};
            OtherUtil.INSTANCE.status(player2, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.redstone_tool.base_not_linkable", objectArray));
            return InteractionResult.FAIL;
        }
        ((RedstoneToolLinkable)baseBlockEntity).setLinkedPos(clickedPos);
        Object[] objectArray = new Object[]{clickedBlockName, clickedPos.getX(), clickedPos.getY(), clickedPos.getZ(), baseBlockName, baseBlockPos.getX(), baseBlockPos.getY(), baseBlockPos.getZ()};
        OtherUtil.INSTANCE.status(player2, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.redstone_tool.linked", objectArray));
        return InteractionResult.SUCCESS;
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/RedstoneToolItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

