/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.util;

import com.mojang.serialization.Codec;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006J\n\u0010\u0007\u001a\u00020\u0005*\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J4\u0010$\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0'0%\"\u0004\b\u0000\u0010(2\u0014\u0010)\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H(0+0*J\u0014\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0018J\u0014\u00100\u001a\u00020-2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130*J\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u0016032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001603J\u0016\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u000208J \u00109\u001a\u00020\r2\u0006\u00106\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00102\b\b\u0002\u0010:\u001a\u00020\rJ(\u00109\u001a\u00020\r2\u0006\u00106\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u001b2\b\b\u0002\u0010:\u001a\u00020\rJ\u0014\u0010<\u001a\u0004\u0018\u00010=*\u00020>2\u0006\u0010?\u001a\u00020\u0005J\u0010\u0010@\u001a\u00020A*\b\u0012\u0004\u0012\u00020B0'J\u0012\u0010O\u001a\u00020P*\u0002082\u0006\u0010Q\u001a\u00020-J\u001a\u0010R\u001a\u00020S*\u00020T2\u0006\u0010U\u001a\u00020S2\u0006\u0010V\u001a\u00020SJ\u001a\u0010R\u001a\u00020W*\u00020T2\u0006\u0010U\u001a\u00020W2\u0006\u0010V\u001a\u00020WJ\u001a\u0010R\u001a\u00020X*\u00020T2\u0006\u0010U\u001a\u00020X2\u0006\u0010V\u001a\u00020XJ\u001e\u0010Y\u001a\u00020X2\u0006\u0010Z\u001a\u00020S2\u0006\u0010[\u001a\u00020X2\u0006\u0010\\\u001a\u00020XR\u0018\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\r8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0015\u0010\u000f\u001a\u00020\r*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0015\u0010\u0012\u001a\u00020\r*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001d\u0010C\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001b0%\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0017\u0010F\u001a\b\u0012\u0004\u0012\u00020=0G\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u001d\u0010J\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020=0%\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010ER#\u0010L\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160M0%\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010E\u00a8\u0006]"}, d2={"Ldev/aaronhowser/mods/irregular_implements/util/OtherUtil;", "", "<init>", "()V", "getDyeName", "", "Lnet/minecraft/world/item/DyeColor;", "getDirectionName", "Lnet/minecraft/core/Direction;", "modResource", "Lnet/minecraft/resources/ResourceLocation;", "path", "isTrue", "", "(Ljava/lang/Boolean;)Z", "isClientSide", "Lnet/minecraft/world/entity/Entity;", "(Lnet/minecraft/world/entity/Entity;)Z", "isServerSide", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/level/Level;)Z", "getPotionStack", "Lnet/minecraft/world/item/ItemStack;", "potion", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/alchemy/Potion;", "toVec3", "Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/core/Vec3i;", "getPovResult", "Lnet/minecraft/world/phys/BlockHitResult;", "level", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "range", "", "tagKeyStreamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "Lnet/minecraft/tags/TagKey;", "T", "registry", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "getBiomeComponent", "Lnet/minecraft/network/chat/Component;", "biomeHolder", "Lnet/minecraft/world/level/biome/Biome;", "getDimensionComponent", "dimensionResourceKey", "flattenStacks", "", "input", "giveOrDropStack", "itemStack", "player", "Lnet/minecraft/world/entity/player/Player;", "dropStackAt", "instantPickup", "pos", "getUuidOrNull", "Ljava/util/UUID;", "Lnet/minecraft/nbt/CompoundTag;", "key", "getComponent", "Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/world/item/Item;", "VEC3_STREAM_CODEC", "getVEC3_STREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "UUID_CODEC", "Lcom/mojang/serialization/Codec;", "getUUID_CODEC", "()Lcom/mojang/serialization/Codec;", "UUID_STREAM_CODEC", "getUUID_STREAM_CODEC", "STACK_LIST_STREAM_CODEC", "Lnet/minecraft/core/NonNullList;", "getSTACK_LIST_STREAM_CODEC", "status", "", "message", "nextRange", "", "Lnet/minecraft/util/RandomSource;", "min", "max", "", "", "lerpColor", "progress", "start", "end", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nOtherUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OtherUtil.kt\ndev/aaronhowser/mods/irregular_implements/util/OtherUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n774#2:213\n865#2,2:214\n1563#2:216\n1634#2,3:217\n295#2,2:220\n*S KotlinDebug\n*F\n+ 1 OtherUtil.kt\ndev/aaronhowser/mods/irregular_implements/util/OtherUtil\n*L\n113#1:213\n113#1:214,2\n113#1:216\n113#1:217,3\n114#1:220,2\n*E\n"})
public final class OtherUtil {
    @NotNull
    public static final OtherUtil INSTANCE = new OtherUtil();
    @NotNull
    private static final StreamCodec<ByteBuf, Vec3> VEC3_STREAM_CODEC = (StreamCodec)new StreamCodec<ByteBuf, Vec3>(){

        public Vec3 decode(ByteBuf buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }

        public void encode(ByteBuf buffer, Vec3 value) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            buffer.writeDouble(value.x);
            buffer.writeDouble(value.y);
            buffer.writeDouble(value.z);
        }
    };
    @NotNull
    private static final Codec<UUID> UUID_CODEC;
    @NotNull
    private static final StreamCodec<ByteBuf, UUID> UUID_STREAM_CODEC;
    @NotNull
    private static final StreamCodec<ByteBuf, NonNullList<ItemStack>> STACK_LIST_STREAM_CODEC;

    private OtherUtil() {
    }

    @NotNull
    public final String getDyeName(@NotNull DyeColor $this$getDyeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDyeName, (String)"<this>");
        String string = $this$getDyeName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public final String getDirectionName(@NotNull Direction $this$getDirectionName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectionName, (String)"<this>");
        String string = $this$getDirectionName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ResourceLocation modResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"irregular_implements", (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    public final boolean isTrue(@Nullable Boolean $this$isTrue) {
        boolean $i$f$isTrue = false;
        return Intrinsics.areEqual((Object)$this$isTrue, (Object)true);
    }

    public final boolean isClientSide(@NotNull Entity $this$isClientSide) {
        Intrinsics.checkNotNullParameter((Object)$this$isClientSide, (String)"<this>");
        return $this$isClientSide.level().isClientSide;
    }

    public final boolean isServerSide(@NotNull Level $this$isServerSide) {
        Intrinsics.checkNotNullParameter((Object)$this$isServerSide, (String)"<this>");
        return !$this$isServerSide.isClientSide;
    }

    @NotNull
    public final ItemStack getPotionStack(@NotNull Holder<Potion> potion) {
        Intrinsics.checkNotNullParameter(potion, (String)"potion");
        ItemStack itemStack = PotionContents.createItemStack((Item)Items.POTION, potion);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"createItemStack(...)");
        return itemStack;
    }

    @NotNull
    public final Vec3 toVec3(@NotNull Vec3i $this$toVec3) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3, (String)"<this>");
        return new Vec3((double)$this$toVec3.getX(), (double)$this$toVec3.getY(), (double)$this$toVec3.getZ());
    }

    @NotNull
    public final BlockHitResult getPovResult(@NotNull Level level, @NotNull LivingEntity entity, @NotNull Number range) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        BlockHitResult blockHitResult = level.clip(new ClipContext(entity.getEyePosition(), entity.getEyePosition().add(entity.getLookAngle().scale(range.doubleValue())), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"clip(...)");
        return blockHitResult;
    }

    @NotNull
    public final <T> StreamCodec<ByteBuf, TagKey<T>> tagKeyStreamCodec(@NotNull ResourceKey<? extends Registry<T>> registry) {
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        StreamCodec streamCodec = ResourceLocation.STREAM_CODEC.map(arg_0 -> OtherUtil.tagKeyStreamCodec$lambda$1(arg_0 -> OtherUtil.tagKeyStreamCodec$lambda$0(registry, arg_0), arg_0), arg_0 -> OtherUtil.tagKeyStreamCodec$lambda$3(OtherUtil::tagKeyStreamCodec$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"map(...)");
        return streamCodec;
    }

    @NotNull
    public final Component getBiomeComponent(@NotNull Holder<Biome> biomeHolder) {
        Intrinsics.checkNotNullParameter(biomeHolder, (String)"biomeHolder");
        ResourceKey resourceKey = biomeHolder.getKey();
        Intrinsics.checkNotNull((Object)resourceKey);
        ResourceKey biomeKey = resourceKey;
        String probableTranslationKey = "biome." + biomeKey.location().getNamespace() + "." + biomeKey.location().getPath();
        boolean hasTranslation = I18n.exists((String)probableTranslationKey);
        MutableComponent mutableComponent = (hasTranslation ? Component.translatable((String)probableTranslationKey) : Component.literal((String)biomeKey.location().toString())).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public final Component getDimensionComponent(@NotNull ResourceKey<Level> dimensionResourceKey) {
        Intrinsics.checkNotNullParameter(dimensionResourceKey, (String)"dimensionResourceKey");
        ResourceLocation location = dimensionResourceKey.location();
        String probableTranslationKey = "dimension." + location.getNamespace() + "." + location.getPath();
        boolean hasTranslation = I18n.exists((String)probableTranslationKey);
        MutableComponent mutableComponent = (hasTranslation ? Component.translatable((String)probableTranslationKey) : Component.literal((String)location.toString())).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        return (Component)mutableComponent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemStack> flattenStacks(@NotNull List<ItemStack> input) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ItemStack it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        List output = new ArrayList();
        Iterable $this$filter$iv = input;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.copy());
        }
        for (ItemStack stack : (List)destination$iv$iv) {
            int amountToAdd;
            Object v0;
            block5: {
                Iterable $this$firstOrNull$iv = output;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ItemStack it2 = (ItemStack)element$iv;
                    boolean bl = false;
                    if (!ItemStack.isSameItemSameComponents((ItemStack)it2, (ItemStack)stack)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            ItemStack matchingStack = v0;
            if (matchingStack != null && (amountToAdd = Math.min(stack.getCount(), matchingStack.getMaxStackSize() - matchingStack.getCount())) > 0) {
                matchingStack.grow(amountToAdd);
                stack.shrink(amountToAdd);
            }
            if (stack.isEmpty()) continue;
            Intrinsics.checkNotNull((Object)stack);
            output.add(stack);
        }
        return output;
    }

    public final boolean giveOrDropStack(@NotNull ItemStack itemStack, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.getInventory().add(itemStack) || this.dropStackAt(itemStack, (Entity)player, true);
    }

    public final boolean dropStackAt(@NotNull ItemStack itemStack, @NotNull Entity entity, boolean instantPickup) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Vec3 vec3 = entity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        return this.dropStackAt(itemStack, level, vec3, instantPickup);
    }

    public static /* synthetic */ boolean dropStackAt$default(OtherUtil otherUtil, ItemStack itemStack, Entity entity, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return otherUtil.dropStackAt(itemStack, entity, bl);
    }

    public final boolean dropStackAt(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Vec3 pos, boolean instantPickup) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        ItemEntity itemEntity = new ItemEntity(level, pos.x, pos.y, pos.z, itemStack);
        if (instantPickup) {
            itemEntity.setNoPickUpDelay();
        }
        return level.addFreshEntity((Entity)itemEntity);
    }

    public static /* synthetic */ boolean dropStackAt$default(OtherUtil otherUtil, ItemStack itemStack, Level level, Vec3 vec3, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return otherUtil.dropStackAt(itemStack, level, vec3, bl);
    }

    @Nullable
    public final UUID getUuidOrNull(@NotNull CompoundTag $this$getUuidOrNull, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getUuidOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return $this$getUuidOrNull.hasUUID(key) ? $this$getUuidOrNull.getUUID(key) : null;
    }

    @NotNull
    public final MutableComponent getComponent(@NotNull TagKey<Item> $this$getComponent) {
        MutableComponent mutableComponent;
        Intrinsics.checkNotNullParameter($this$getComponent, (String)"<this>");
        ResourceLocation tagLocation = $this$getComponent.location();
        String string = "tag.item." + tagLocation.getNamespace() + "." + tagLocation.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String possibleLangKey = string;
        if (I18n.exists((String)possibleLangKey)) {
            MutableComponent mutableComponent2 = Component.translatable((String)possibleLangKey);
            Intrinsics.checkNotNull((Object)mutableComponent2);
            mutableComponent = mutableComponent2;
        } else {
            MutableComponent mutableComponent3 = Component.literal((String)tagLocation.toString());
            Intrinsics.checkNotNull((Object)mutableComponent3);
            mutableComponent = mutableComponent3;
        }
        return mutableComponent;
    }

    @NotNull
    public final StreamCodec<ByteBuf, Vec3> getVEC3_STREAM_CODEC() {
        return VEC3_STREAM_CODEC;
    }

    @NotNull
    public final Codec<UUID> getUUID_CODEC() {
        return UUID_CODEC;
    }

    @NotNull
    public final StreamCodec<ByteBuf, UUID> getUUID_STREAM_CODEC() {
        return UUID_STREAM_CODEC;
    }

    @NotNull
    public final StreamCodec<ByteBuf, NonNullList<ItemStack>> getSTACK_LIST_STREAM_CODEC() {
        return STACK_LIST_STREAM_CODEC;
    }

    public final void status(@NotNull Player $this$status, @NotNull Component message) {
        Intrinsics.checkNotNullParameter((Object)$this$status, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$status.displayClientMessage(message, true);
    }

    public final float nextRange(@NotNull RandomSource $this$nextRange, float min, float max) {
        Intrinsics.checkNotNullParameter((Object)$this$nextRange, (String)"<this>");
        return Mth.lerp((float)$this$nextRange.nextFloat(), (float)min, (float)max);
    }

    public final double nextRange(@NotNull RandomSource $this$nextRange, double min, double max) {
        Intrinsics.checkNotNullParameter((Object)$this$nextRange, (String)"<this>");
        return Mth.lerp((double)$this$nextRange.nextDouble(), (double)min, (double)max);
    }

    public final int nextRange(@NotNull RandomSource $this$nextRange, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)$this$nextRange, (String)"<this>");
        return $this$nextRange.nextInt(max - min) + min;
    }

    public final int lerpColor(float progress, int start, int end) {
        int startR = start >> 16 & 0xFF;
        int startG = start >> 8 & 0xFF;
        int startB = start & 0xFF;
        int endR = end >> 16 & 0xFF;
        int endG = end >> 8 & 0xFF;
        int endB = end & 0xFF;
        int r = (int)Mth.lerp((float)progress, (float)startR, (float)endR);
        int g = (int)Mth.lerp((float)progress, (float)startG, (float)endG);
        int b = (int)Mth.lerp((float)progress, (float)startB, (float)endB);
        return r << 16 | g << 8 | b;
    }

    private static final TagKey tagKeyStreamCodec$lambda$0(ResourceKey $registry, ResourceLocation it) {
        return TagKey.create((ResourceKey)$registry, (ResourceLocation)it);
    }

    private static final TagKey tagKeyStreamCodec$lambda$1(Function1 $tmp0, Object p0) {
        return (TagKey)$tmp0.invoke(p0);
    }

    private static final ResourceLocation tagKeyStreamCodec$lambda$2(TagKey it) {
        return it.location();
    }

    private static final ResourceLocation tagKeyStreamCodec$lambda$3(Function1 $tmp0, Object p0) {
        return (ResourceLocation)$tmp0.invoke(p0);
    }

    private static final UUID UUID_CODEC$lambda$7(Function1 $tmp0, Object p0) {
        return (UUID)$tmp0.invoke(p0);
    }

    private static final String UUID_CODEC$lambda$8(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final UUID UUID_STREAM_CODEC$lambda$9(Function1 $tmp0, Object p0) {
        return (UUID)$tmp0.invoke(p0);
    }

    private static final String UUID_STREAM_CODEC$lambda$10(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    static {
        Codec codec = Codec.STRING.xmap(arg_0 -> OtherUtil.UUID_CODEC$lambda$7(UUID_CODEC.1.INSTANCE, arg_0), arg_0 -> OtherUtil.UUID_CODEC$lambda$8(UUID_CODEC.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"xmap(...)");
        UUID_CODEC = codec;
        codec = ByteBufCodecs.STRING_UTF8.map(arg_0 -> OtherUtil.UUID_STREAM_CODEC$lambda$9(UUID_STREAM_CODEC.1.INSTANCE, arg_0), arg_0 -> OtherUtil.UUID_STREAM_CODEC$lambda$10(UUID_STREAM_CODEC.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"map(...)");
        UUID_STREAM_CODEC = codec;
        StreamCodec streamCodec = ByteBufCodecs.fromCodec((Codec)NonNullList.codecOf((Codec)ItemStack.OPTIONAL_CODEC));
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"fromCodec(...)");
        STACK_LIST_STREAM_CODEC = streamCodec;
    }
}

