/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.world.placement_filters;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.irregular_implements.registry.ModPlacementModifierTypes;
import dev.aaronhowser.mods.irregular_implements.world.placement_filters.WeightedBiomeRarityFilter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B1\u0012\u0018\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u001b\u0010\u001a\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J9\u0010\u001d\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006%"}, d2={"Ldev/aaronhowser/mods/irregular_implements/world/placement_filters/WeightedBiomeRarityFilter;", "Lnet/minecraft/world/level/levelgen/placement/PlacementFilter;", "pointsPerBiomeTag", "", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/level/biome/Biome;", "", "basePoints", "chanceFactor", "<init>", "(Ljava/util/Map;II)V", "getPointsPerBiomeTag", "()Ljava/util/Map;", "getBasePoints", "()I", "getChanceFactor", "type", "Lnet/minecraft/world/level/levelgen/placement/PlacementModifierType;", "shouldPlace", "", "context", "Lnet/minecraft/world/level/levelgen/placement/PlacementContext;", "random", "Lnet/minecraft/util/RandomSource;", "pos", "Lnet/minecraft/core/BlockPos;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "Companion", "irregular-implements-1.21.1"})
public final class WeightedBiomeRarityFilter
extends PlacementFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<TagKey<Biome>, Integer> pointsPerBiomeTag;
    private final int basePoints;
    private final int chanceFactor;
    @NotNull
    private static final MapCodec<WeightedBiomeRarityFilter> CODEC;

    public WeightedBiomeRarityFilter(@NotNull Map<TagKey<Biome>, Integer> pointsPerBiomeTag, int basePoints, int chanceFactor) {
        Intrinsics.checkNotNullParameter(pointsPerBiomeTag, (String)"pointsPerBiomeTag");
        this.pointsPerBiomeTag = pointsPerBiomeTag;
        this.basePoints = basePoints;
        this.chanceFactor = chanceFactor;
    }

    @NotNull
    public final Map<TagKey<Biome>, Integer> getPointsPerBiomeTag() {
        return this.pointsPerBiomeTag;
    }

    public final int getBasePoints() {
        return this.basePoints;
    }

    public final int getChanceFactor() {
        return this.chanceFactor;
    }

    @NotNull
    public PlacementModifierType<?> type() {
        Object object = ModPlacementModifierTypes.INSTANCE.getWEIGHTED_BIOME_RARITY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (PlacementModifierType)object;
    }

    protected boolean shouldPlace(@NotNull PlacementContext context, @NotNull RandomSource random, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Holder biome = context.getLevel().getBiome(pos);
        int chanceMult = this.basePoints;
        for (Map.Entry<TagKey<Biome>, Integer> entry2 : this.pointsPerBiomeTag.entrySet()) {
            TagKey<Biome> tag = entry2.getKey();
            int points = ((Number)entry2.getValue()).intValue();
            if (!biome.is(tag)) continue;
            chanceMult += points;
        }
        return random.nextInt(this.chanceFactor * chanceMult) == 0;
    }

    @NotNull
    public final Map<TagKey<Biome>, Integer> component1() {
        return this.pointsPerBiomeTag;
    }

    public final int component2() {
        return this.basePoints;
    }

    public final int component3() {
        return this.chanceFactor;
    }

    @NotNull
    public final WeightedBiomeRarityFilter copy(@NotNull Map<TagKey<Biome>, Integer> pointsPerBiomeTag, int basePoints, int chanceFactor) {
        Intrinsics.checkNotNullParameter(pointsPerBiomeTag, (String)"pointsPerBiomeTag");
        return new WeightedBiomeRarityFilter(pointsPerBiomeTag, basePoints, chanceFactor);
    }

    public static /* synthetic */ WeightedBiomeRarityFilter copy$default(WeightedBiomeRarityFilter weightedBiomeRarityFilter, Map map, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            map = weightedBiomeRarityFilter.pointsPerBiomeTag;
        }
        if ((n3 & 2) != 0) {
            n = weightedBiomeRarityFilter.basePoints;
        }
        if ((n3 & 4) != 0) {
            n2 = weightedBiomeRarityFilter.chanceFactor;
        }
        return weightedBiomeRarityFilter.copy(map, n, n2);
    }

    @NotNull
    public String toString() {
        return "WeightedBiomeRarityFilter(pointsPerBiomeTag=" + this.pointsPerBiomeTag + ", basePoints=" + this.basePoints + ", chanceFactor=" + this.chanceFactor + ")";
    }

    public int hashCode() {
        int result = ((Object)this.pointsPerBiomeTag).hashCode();
        result = result * 31 + Integer.hashCode(this.basePoints);
        result = result * 31 + Integer.hashCode(this.chanceFactor);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WeightedBiomeRarityFilter)) {
            return false;
        }
        WeightedBiomeRarityFilter weightedBiomeRarityFilter = (WeightedBiomeRarityFilter)((Object)other);
        if (!Intrinsics.areEqual(this.pointsPerBiomeTag, weightedBiomeRarityFilter.pointsPerBiomeTag)) {
            return false;
        }
        if (this.basePoints != weightedBiomeRarityFilter.basePoints) {
            return false;
        }
        return this.chanceFactor == weightedBiomeRarityFilter.chanceFactor;
    }

    private static final Map CODEC$lambda$3$lambda$0(KProperty1 $tmp0, WeightedBiomeRarityFilter p0) {
        return (Map)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer CODEC$lambda$3$lambda$1(KProperty1 $tmp0, WeightedBiomeRarityFilter p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer CODEC$lambda$3$lambda$2(KProperty1 $tmp0, WeightedBiomeRarityFilter p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$3(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Codec.unboundedMap((Codec)TagKey.codec((ResourceKey)Registries.BIOME), (Codec)((Codec)Codec.INT)).fieldOf("points_per_biome_tag").forGetter(arg_0 -> WeightedBiomeRarityFilter.CODEC$lambda$3$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.INT.fieldOf("base_points").forGetter(arg_0 -> WeightedBiomeRarityFilter.CODEC$lambda$3$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)Codec.INT.fieldOf("chance_factor").forGetter(arg_0 -> WeightedBiomeRarityFilter.CODEC$lambda$3$lambda$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0))).apply((Applicative)instance, WeightedBiomeRarityFilter::new);
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(WeightedBiomeRarityFilter::CODEC$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/irregular_implements/world/placement_filters/WeightedBiomeRarityFilter$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/aaronhowser/mods/irregular_implements/world/placement_filters/WeightedBiomeRarityFilter;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<WeightedBiomeRarityFilter> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

