/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u0007H\u0014J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J*\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J(\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/CompressedSlimeBlock;", "Lnet/minecraft/world/level/block/Block;", "<init>", "()V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "world", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getCollisionShape", "level", "getToolModifiedState", "Lnet/minecraft/world/item/context/UseOnContext;", "itemAbility", "Lnet/neoforged/neoforge/common/ItemAbility;", "simulate", "", "isOcclusionShapeFullBlock", "entityInside", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "Companion", "irregular-implements-1.21.1"})
public final class CompressedSlimeBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape SHAPE_0;
    @NotNull
    private static final VoxelShape SHAPE_1;
    @NotNull
    private static final VoxelShape SHAPE_2;
    @NotNull
    private static final IntegerProperty COMPRESSION_LEVEL;

    public CompressedSlimeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.SLIME_BLOCK)));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)COMPRESSION_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{COMPRESSION_LEVEL};
        builder.add(propertyArray);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Integer n2 = n = (Integer)state.getValue((Property)COMPRESSION_LEVEL);
        if (n2 != null && n2 == 0) {
            voxelShape = SHAPE_0;
        } else {
            Integer n3 = n;
            int n4 = 1;
            if (n3 != null && n3 == n4) {
                voxelShape = SHAPE_1;
            } else {
                Integer n5 = n;
                n4 = 2;
                voxelShape = n5 != null && n5 == n4 ? SHAPE_2 : SHAPE_0;
            }
        }
        return voxelShape;
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape shape = this.getShape(state, level, pos, context);
        if (context.isAbove(shape, pos, true)) {
            voxelShape = shape;
        } else {
            VoxelShape voxelShape2 = Shapes.empty();
            voxelShape = voxelShape2;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"empty(...)");
        }
        return voxelShape;
    }

    @Nullable
    public BlockState getToolModifiedState(@NotNull BlockState state, @NotNull UseOnContext context, @NotNull ItemAbility itemAbility, boolean simulate) {
        BlockState blockState;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)itemAbility, (String)"itemAbility");
        if (!Intrinsics.areEqual((Object)itemAbility, (Object)ItemAbilities.SHOVEL_FLATTEN)) {
            return super.getToolModifiedState(state, context, itemAbility, simulate);
        }
        Integer n2 = n = (Integer)state.getValue((Property)COMPRESSION_LEVEL);
        if (n2 != null && n2 == 0) {
            blockState = (BlockState)state.setValue((Property)COMPRESSION_LEVEL, (Comparable)Integer.valueOf(1));
        } else {
            Integer n3 = n;
            int n4 = 1;
            if (n3 != null && n3 == n4) {
                blockState = (BlockState)state.setValue((Property)COMPRESSION_LEVEL, (Comparable)Integer.valueOf(2));
            } else {
                Integer n5 = n;
                n4 = 2;
                blockState = n5 != null && n5 == n4 ? Blocks.SLIME_BLOCK.defaultBlockState() : state;
            }
        }
        return blockState;
    }

    protected boolean isOcclusionShapeFullBlock(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return false;
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Integer compression = (Integer)state.getValue((Property)COMPRESSION_LEVEL);
        entity.setOnGround(false);
        entity.resetFallDistance();
        Intrinsics.checkNotNull((Object)compression);
        entity.addDeltaMovement(new Vec3(0.0, 0.8 + 0.4 * (double)compression.intValue(), 0.0));
    }

    static {
        VoxelShape voxelShape = Block.box((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)8.0, (double)15.99);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE_0 = voxelShape;
        VoxelShape voxelShape2 = Block.box((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)4.0, (double)15.99);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        SHAPE_1 = voxelShape2;
        VoxelShape voxelShape3 = Block.box((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)2.0, (double)15.99);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"box(...)");
        SHAPE_2 = voxelShape3;
        IntegerProperty integerProperty = IntegerProperty.create((String)"compression_level", (int)0, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"create(...)");
        COMPRESSION_LEVEL = integerProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/CompressedSlimeBlock$Companion;", "", "<init>", "()V", "SHAPE_0", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE_0", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "SHAPE_1", "getSHAPE_1", "SHAPE_2", "getSHAPE_2", "COMPRESSION_LEVEL", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getCOMPRESSION_LEVEL", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "modifySlimeBlock", "", "event", "Lnet/neoforged/neoforge/event/level/BlockEvent$BlockToolModificationEvent;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VoxelShape getSHAPE_0() {
            return SHAPE_0;
        }

        @NotNull
        public final VoxelShape getSHAPE_1() {
            return SHAPE_1;
        }

        @NotNull
        public final VoxelShape getSHAPE_2() {
            return SHAPE_2;
        }

        @NotNull
        public final IntegerProperty getCOMPRESSION_LEVEL() {
            return COMPRESSION_LEVEL;
        }

        public final void modifySlimeBlock(@NotNull BlockEvent.BlockToolModificationEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ItemAbility ability = event.getItemAbility();
            if (!Intrinsics.areEqual((Object)ability, (Object)ItemAbilities.SHOVEL_FLATTEN)) {
                return;
            }
            BlockState clickedState = event.getState();
            if (!Intrinsics.areEqual((Object)clickedState.getBlock(), (Object)Blocks.SLIME_BLOCK)) {
                return;
            }
            event.setFinalState(((CompressedSlimeBlock)((Object)ModBlocks.INSTANCE.getCOMPRESSED_SLIME_BLOCK().get())).defaultBlockState());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

