/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.ContactLeverBlock;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import dev.aaronhowser.mods.irregular_implements.registry.ModSounds;
import dev.aaronhowser.mods.irregular_implements.util.ServerScheduler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J8\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/EnderBridgeBlock;", "Lnet/minecraft/world/level/block/Block;", "distancePerTick", "", "<init>", "(I)V", "getDistancePerTick", "()I", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "neighborChanged", "state", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "block", "fromPos", "isMoving", "", "Companion", "irregular-implements-1.21.1"})
public final class EnderBridgeBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int distancePerTick;
    @NotNull
    private static final BooleanProperty ENABLED;
    @NotNull
    private static final DirectionProperty FACING;
    private static final int MAX_ITERATIONS = Integer.MAX_VALUE;

    public EnderBridgeBlock(int distancePerTick) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.OBSIDIAN)));
        this.distancePerTick = distancePerTick;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ContactLeverBlock.Companion.getENABLED(), (Comparable)Boolean.valueOf(false)));
    }

    public final int getDistancePerTick() {
        return this.distancePerTick;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{FACING, ENABLED};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        if (!(level instanceof ServerLevel)) {
            return;
        }
        boolean isPowered = level.hasNeighborSignal(pos);
        if (!isPowered) {
            return;
        }
        if (((Boolean)state.getValue((Property)ENABLED)).booleanValue()) {
            return;
        }
        BlockState newState = (BlockState)state.setValue((Property)ENABLED, (Comparable)Boolean.valueOf(true));
        level.setBlockAndUpdate(pos, newState);
        Direction direction = (Direction)state.getValue((Property)FACING);
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos blockPos = pos.relative(direction);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
        Intrinsics.checkNotNull((Object)direction);
        Companion.searchForAnchor(serverLevel, this.distancePerTick, pos, blockPos, direction, 0);
    }

    static {
        BooleanProperty booleanProperty = BlockStateProperties.ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"ENABLED");
        ENABLED = booleanProperty;
        DirectionProperty directionProperty = BlockStateProperties.FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"FACING");
        FACING = directionProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J6\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014J \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J \u0010\u001f\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/EnderBridgeBlock$Companion;", "", "<init>", "()V", "ENABLED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getENABLED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "FACING", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getFACING", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getEntities", "", "Lnet/minecraft/world/entity/Entity;", "level", "Lnet/minecraft/world/level/Level;", "bridgePos", "Lnet/minecraft/core/BlockPos;", "MAX_ITERATIONS", "", "searchForAnchor", "", "Lnet/minecraft/server/level/ServerLevel;", "blocksPerIteration", "searchOrigin", "direction", "Lnet/minecraft/core/Direction;", "iterations", "foundAnchor", "anchorPos", "turnOffBridge", "bridgeFailed", "", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getENABLED() {
            return ENABLED;
        }

        @NotNull
        public final DirectionProperty getFACING() {
            return FACING;
        }

        private final List<Entity> getEntities(Level level, BlockPos bridgePos) {
            List list = level.getEntities(null, AABB.ofSize((Vec3)bridgePos.getCenter(), (double)1.25, (double)2.5, (double)1.25));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
            return list;
        }

        public final void searchForAnchor(@NotNull ServerLevel level, int blocksPerIteration, @NotNull BlockPos bridgePos, @NotNull BlockPos searchOrigin, @NotNull Direction direction, int iterations) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)bridgePos, (String)"bridgePos");
            Intrinsics.checkNotNullParameter((Object)searchOrigin, (String)"searchOrigin");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            if (iterations >= Integer.MAX_VALUE) {
                this.turnOffBridge((Level)level, bridgePos, true);
                Object[] objectArray = new Object[]{iterations * blocksPerIteration};
                MutableComponent component = ModLanguageProvider.Companion.toComponent("message.irregular_implements.ender_bridge.iterations", objectArray);
                for (Entity entity : this.getEntities((Level)level, bridgePos)) {
                    entity.sendSystemMessage((Component)component);
                }
                return;
            }
            List players = level.players();
            for (int i = 0; i < blocksPerIteration; ++i) {
                BlockState state;
                BlockPos pos = searchOrigin.relative(direction, i);
                if (!level.isLoaded(pos)) continue;
                if (iterations % 4 == 0) {
                    int particleCount = RangesKt.coerceIn((int)(1 + Mth.ceil((double)((double)iterations / (double)20))), (int)1, (int)100);
                    double particleSpeed = RangesKt.coerceIn((double)(0.5 + (double)iterations / 30.0), (double)0.5, (double)3.0);
                    for (ServerPlayer player : players) {
                        level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)bridgePos.getX() + 0.5, (double)bridgePos.getY() + 2.0, (double)bridgePos.getZ() + 0.5, particleCount, 0.0, 0.0, 0.0, particleSpeed);
                    }
                }
                if ((state = level.getBlockState(pos)).is((Holder)ModBlocks.INSTANCE.getENDER_ANCHOR())) {
                    int particleCount = RangesKt.coerceIn((int)(1 + Mth.ceil((double)((double)iterations / (double)20))), (int)10, (int)100);
                    for (ServerPlayer player : players) {
                        level.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, particleCount, 0.0, 0.0, 0.0, 0.5);
                    }
                    Level level2 = (Level)level;
                    Intrinsics.checkNotNull((Object)pos);
                    this.foundAnchor(level2, bridgePos, pos);
                    return;
                }
                if (!state.isCollisionShapeFullBlock((BlockGetter)level, pos)) continue;
                this.turnOffBridge((Level)level, bridgePos, true);
                MutableComponent blockName = state.getBlock().getName();
                Object[] objectArray = new Object[]{blockName, pos.getX(), pos.getY(), pos.getZ()};
                MutableComponent component = ModLanguageProvider.Companion.toComponent("message.irregular_implements.ender_bridge.hit_block", objectArray);
                for (Entity entity : this.getEntities((Level)level, bridgePos)) {
                    entity.sendSystemMessage((Component)component);
                }
                return;
            }
            ServerScheduler.INSTANCE.scheduleTaskInTicks(1, () -> Companion.searchForAnchor$lambda$0(level, blocksPerIteration, bridgePos, searchOrigin, direction, iterations));
        }

        private final void foundAnchor(Level level, BlockPos bridgePos, BlockPos anchorPos) {
            for (Entity entity : this.getEntities(level, bridgePos)) {
                entity.teleportTo((double)anchorPos.getX() + 0.5, (double)anchorPos.getY() + 1.0, (double)anchorPos.getZ() + 0.5);
            }
            level.playSound(null, anchorPos.above(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS);
            this.turnOffBridge(level, bridgePos, false);
        }

        private final void turnOffBridge(Level level, BlockPos bridgePos, boolean bridgeFailed) {
            BlockState state = level.getBlockState(bridgePos);
            if (!((Boolean)state.getValue((Property)this.getENABLED())).booleanValue()) {
                return;
            }
            BlockState newState = (BlockState)state.setValue((Property)this.getENABLED(), (Comparable)Boolean.valueOf(false));
            level.setBlockAndUpdate(bridgePos, newState);
            SoundEvent soundEvent = bridgeFailed ? (SoundEvent)ModSounds.INSTANCE.getFART().get() : SoundEvents.ENDERMAN_TELEPORT;
            level.playSound(null, bridgePos.above(), soundEvent, SoundSource.BLOCKS);
        }

        private static final void searchForAnchor$lambda$0(ServerLevel $level, int $blocksPerIteration, BlockPos $bridgePos, BlockPos $searchOrigin, Direction $direction, int $iterations) {
            BlockPos blockPos = $searchOrigin.relative($direction);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
            Companion.searchForAnchor($level, $blocksPerIteration, $bridgePos, blockPos, $direction, $iterations + $blocksPerIteration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

