/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.datagen.datapack.ModDimensions;
import dev.aaronhowser.mods.irregular_implements.handler.spectre_cube.SpectreCube;
import dev.aaronhowser.mods.irregular_implements.handler.spectre_cube.SpectreCubeSavedData;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/SpectreCoreBlock;", "Lnet/minecraft/world/level/block/Block;", "<init>", "()V", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "irregular-implements-1.21.1"})
public final class SpectreCoreBlock
extends Block {
    public SpectreCoreBlock() {
        super(BlockBehaviour.Properties.of().strength(-1.0f, 3600000.0f).isValidSpawn((p0$p0, p1$p1, p2$p2, p3$p3) -> Blocks.never((BlockState)p0$p0, (BlockGetter)p1$p1, (BlockPos)p2$p2, (EntityType)p3$p3)));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (!(level instanceof ServerLevel) || !Intrinsics.areEqual((Object)level.dimension(), ModDimensions.INSTANCE.getSPECTRE_LEVEL_KEY())) {
            return ItemInteractionResult.SUCCESS;
        }
        SpectreCubeSavedData handler = SpectreCubeSavedData.Companion.get((ServerLevel)level);
        if (stack.is((Holder)ModItems.INSTANCE.getECTOPLASM())) {
            SpectreCube cube;
            SpectreCube spectreCube = cube = handler.getSpectreCubeFromBlockPos(level, pos);
            int amount = spectreCube != null ? spectreCube.increaseHeight(stack.getCount()) : 0;
            stack.consume(amount, (LivingEntity)player);
        } else if (stack.isEmpty() && hand == InteractionHand.MAIN_HAND) {
            handler.teleportPlayerBack((ServerPlayer)player);
        }
        return ItemInteractionResult.SUCCESS;
    }
}

