/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.block.ItemCollectorBlock;
import dev.aaronhowser.mods.irregular_implements.item.component.ItemFilterDataComponent;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntities;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0004J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ItemCollectorBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "pos", "blockState", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "tick", "", "getFilter", "Ldev/aaronhowser/mods/irregular_implements/item/component/ItemFilterDataComponent;", "getCollectionArea", "Lnet/minecraft/world/phys/AABB;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nItemCollectorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemCollectorBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/ItemCollectorBlockEntity\n+ 2 OtherUtil.kt\ndev/aaronhowser/mods/irregular_implements/util/OtherUtil\n*L\n1#1,86:1\n49#2:87\n*S KotlinDebug\n*F\n+ 1 ItemCollectorBlockEntity.kt\ndev/aaronhowser/mods/irregular_implements/block/block_entity/ItemCollectorBlockEntity\n*L\n45#1:87\n*E\n"})
public class ItemCollectorBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ItemCollectorBlockEntity(@NotNull BlockEntityType<? extends ItemCollectorBlockEntity> blockEntity, @NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter(blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super(blockEntity, pPos, pBlockState);
    }

    public ItemCollectorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = ModBlockEntities.INSTANCE.getITEM_COLLECTOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((BlockEntityType<? extends ItemCollectorBlockEntity>)((BlockEntityType)object), pos, blockState);
    }

    protected final void tick() {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        if (level2.isClientSide || level2.getGameTime() % (long)5 != 0L) {
            return;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)ItemCollectorBlock.Companion.getFACING());
        BlockPos onPos = this.getBlockPos().relative(facing);
        IItemHandler iItemHandler = (IItemHandler)level2.getCapability(Capabilities.ItemHandler.BLOCK, onPos, (Object)facing.getOpposite());
        if (iItemHandler == null) {
            return;
        }
        IItemHandler itemHandler = iItemHandler;
        List itemEntities = level2.getEntitiesOfClass(ItemEntity.class, this.getCollectionArea());
        ItemFilterDataComponent filter = this.getFilter();
        for (ItemEntity itemEntity : itemEntities) {
            ItemStack newStack;
            if (itemEntity.getTarget() != null || itemEntity.hasPickUpDelay()) continue;
            ItemStack stack = itemEntity.getItem();
            if (filter != null) {
                OtherUtil otherUtil = OtherUtil.INSTANCE;
                Intrinsics.checkNotNull((Object)stack);
                boolean $this$isTrue$iv = filter.test(stack);
                boolean $i$f$isTrue = false;
                if (!$this$isTrue$iv) continue;
            }
            if ((newStack = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false)).isEmpty()) {
                itemEntity.discard();
                continue;
            }
            itemEntity.setItem(newStack);
        }
    }

    @Nullable
    public ItemFilterDataComponent getFilter() {
        return null;
    }

    @NotNull
    public AABB getCollectionArea() {
        BlockPos pos = this.getBlockPos();
        double radius = 3.0;
        AABB aABB = AABB.ofSize((Vec3)pos.getCenter(), (double)((double)2 * radius), (double)((double)2 * radius), (double)((double)2 * radius));
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"ofSize(...)");
        return aABB;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ItemCollectorBlockEntity$Companion;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/ItemCollectorBlockEntity;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull ItemCollectorBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            blockEntity.tick();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

