/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client.render;

import dev.aaronhowser.mods.irregular_implements.client.render.CubeIndicatorRenderer;
import dev.aaronhowser.mods.irregular_implements.config.ClientConfig;
import dev.aaronhowser.mods.irregular_implements.item.BiomeCapsuleItem;
import dev.aaronhowser.mods.irregular_implements.item.BiomePainterItem;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/BiomePainterRenderer;", "", "<init>", "()V", "indicatePositions", "", "player", "Lnet/minecraft/world/entity/Entity;", "irregular-implements-1.21.1"})
public final class BiomePainterRenderer {
    @NotNull
    public static final BiomePainterRenderer INSTANCE = new BiomePainterRenderer();

    private BiomePainterRenderer() {
    }

    public final void indicatePositions(@NotNull Entity player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!(player instanceof Player) || !OtherUtil.INSTANCE.isClientSide(player)) {
            return;
        }
        Holder<Biome> holder = BiomeCapsuleItem.Companion.getBiomeToPaint((Player)player);
        if (holder == null) {
            return;
        }
        Holder<Biome> paintingBiome = holder;
        BiomePainterItem.Positions positions = BiomePainterItem.Positions.Companion.getPositions((Player)player, paintingBiome);
        Set<BlockPos> goodPositions = positions.getMatchingPositions();
        Set<BlockPos> badPositions = positions.getUntargetedUnmatchingPositions();
        BlockPos targetPos = positions.getTargetedUnmatchingPosition();
        Integer correctBiomeColor = (Integer)ClientConfig.CONFIG.getBiomePainterCorrectBiomeCubeColor().get();
        Integer incorrectBiomeColor = (Integer)ClientConfig.CONFIG.getBiomePainterIncorrectBiomeCubeColor().get();
        Integer selectedColor = (Integer)ClientConfig.CONFIG.getBiomePainterSelectedIncorrectBiomeCubeColor().get();
        float correctSize = (float)((Number)ClientConfig.CONFIG.getBiomePainterCorrectBiomeCubeSize().get()).doubleValue();
        float incorrectSize = (float)((Number)ClientConfig.CONFIG.getBiomePainterIncorrectBiomeCubeSize().get()).doubleValue();
        for (BlockPos pos : goodPositions) {
            Intrinsics.checkNotNull((Object)correctBiomeColor);
            CubeIndicatorRenderer.INSTANCE.addIndicator(pos, 2, correctBiomeColor, correctSize);
        }
        for (BlockPos pos : badPositions) {
            Intrinsics.checkNotNull((Object)incorrectBiomeColor);
            CubeIndicatorRenderer.INSTANCE.addIndicator(pos, 2, incorrectBiomeColor, incorrectSize);
        }
        if (targetPos != null) {
            Intrinsics.checkNotNull((Object)selectedColor);
            CubeIndicatorRenderer.INSTANCE.addIndicator(targetPos, 2, selectedColor, incorrectSize);
        }
    }
}

