/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.aaronhowser.mods.irregular_implements.entity.PortkeyItemEntity;
import dev.aaronhowser.mods.irregular_implements.item.component.PortkeyDisguiseDataComponent;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/entity/PortkeyItemEntityRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Ldev/aaronhowser/mods/irregular_implements/entity/PortkeyItemEntity;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "itemRenderer", "Lnet/minecraft/client/renderer/entity/ItemRenderer;", "random", "Lnet/minecraft/util/RandomSource;", "render", "", "entity", "entityYaw", "", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "irregular-implements-1.21.1"})
public final class PortkeyItemEntityRenderer
extends EntityRenderer<PortkeyItemEntity> {
    @NotNull
    private final ItemRenderer itemRenderer;
    @NotNull
    private final RandomSource random;

    public PortkeyItemEntityRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        ItemRenderer itemRenderer = context.getItemRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)itemRenderer, (String)"getItemRenderer(...)");
        this.itemRenderer = itemRenderer;
        RandomSource randomSource = RandomSource.create();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"create(...)");
        this.random = randomSource;
    }

    public void render(@NotNull PortkeyItemEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        ItemStack renderStack;
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        poseStack.pushPose();
        ItemStack portkeyStack = entity.getItem().copy();
        PortkeyDisguiseDataComponent disguise = (PortkeyDisguiseDataComponent)portkeyStack.get((Supplier)ModDataComponents.INSTANCE.getPORTKEY_DISGUISE());
        ItemStack itemStack = renderStack = disguise == null || entity.age < 100 ? portkeyStack : disguise.getStack().copy();
        if (portkeyStack.has((Supplier)ModDataComponents.INSTANCE.getGLOBAL_POS()) && entity.age < 100) {
            renderStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        }
        this.random.setSeed((long)ItemEntityRenderer.getSeedForItemStack((ItemStack)renderStack));
        BakedModel bakedmodel = this.itemRenderer.getModel(renderStack, entity.level(), null, entity.getId());
        boolean flag = bakedmodel.isGui3d();
        boolean shouldBob = IClientItemExtensions.of((ItemStack)renderStack).shouldBobAsEntity(renderStack);
        float f1 = shouldBob ? Mth.sin((float)(((float)entity.getAge() + partialTicks) / 10.0f + entity.bobOffs)) * 0.1f + 0.1f : 0.0f;
        float f2 = bakedmodel.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        poseStack.translate(0.0f, f1 + 0.25f * f2, 0.0f);
        float f3 = entity.getSpin(partialTicks);
        poseStack.mulPose(Axis.YP.rotation(f3));
        ItemEntityRenderer.renderMultipleFromCount((ItemRenderer)this.itemRenderer, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (ItemStack)renderStack, (BakedModel)bakedmodel, (boolean)flag, (RandomSource)this.random);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull PortkeyItemEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ResourceLocation resourceLocation = InventoryMenu.BLOCK_ATLAS;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"BLOCK_ATLAS");
        return resourceLocation;
    }
}

