/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.aaronhowser.mods.irregular_implements.entity.SpiritEntity;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001:\u0002\u001a\u001bB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/entity/SpiritEntityRenderer;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "Ldev/aaronhowser/mods/irregular_implements/entity/SpiritEntity;", "Lnet/minecraft/client/model/SlimeModel;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "render", "", "entity", "entityYaw", "", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "getBlockLightLevel", "pos", "Lnet/minecraft/core/BlockPos;", "getSkyLightLevel", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "Companion", "SpiritGelLayer", "irregular-implements-1.21.1"})
public final class SpiritEntityRenderer
extends MobRenderer<SpiritEntity, SlimeModel<SpiritEntity>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation TEXTURE = OtherUtil.modResource("textures/entity/spirit.png");

    public SpiritEntityRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, (EntityModel)new SlimeModel(context.bakeLayer(ModelLayers.SLIME)), 0.25f);
        RenderLayerParent renderLayerParent = (RenderLayerParent)this;
        EntityModelSet entityModelSet = context.getModelSet();
        Intrinsics.checkNotNullExpressionValue((Object)entityModelSet, (String)"getModelSet(...)");
        this.addLayer(new SpiritGelLayer((RenderLayerParent<SpiritEntity, SlimeModel<SpiritEntity>>)renderLayerParent, entityModelSet));
    }

    public void render(@NotNull SpiritEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        poseStack.pushPose();
        float scale = 0.5f;
        poseStack.scale(scale, scale, scale);
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.popPose();
    }

    protected int getBlockLightLevel(@NotNull SpiritEntity entity, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return 15;
    }

    protected int getSkyLightLevel(@NotNull SpiritEntity entity, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return 15;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SpiritEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        return TEXTURE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/entity/SpiritEntityRenderer$Companion;", "", "<init>", "()V", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "getTEXTURE", "()Lnet/minecraft/resources/ResourceLocation;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getTEXTURE() {
            return TEXTURE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B)\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJX\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/entity/SpiritEntityRenderer$SpiritGelLayer;", "Lnet/minecraft/client/renderer/entity/layers/RenderLayer;", "Ldev/aaronhowser/mods/irregular_implements/entity/SpiritEntity;", "Lnet/minecraft/client/model/SlimeModel;", "renderer", "Lnet/minecraft/client/renderer/entity/RenderLayerParent;", "modelSet", "Lnet/minecraft/client/model/geom/EntityModelSet;", "<init>", "(Lnet/minecraft/client/renderer/entity/RenderLayerParent;Lnet/minecraft/client/model/geom/EntityModelSet;)V", "model", "getModel", "()Lnet/minecraft/client/model/SlimeModel;", "render", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "livingEntity", "limbSwing", "", "limbSwingAmount", "partialTick", "ageInTicks", "netHeadYaw", "headPitch", "irregular-implements-1.21.1"})
    public static final class SpiritGelLayer
    extends RenderLayer<SpiritEntity, SlimeModel<SpiritEntity>> {
        @NotNull
        private final SlimeModel<SpiritEntity> model;

        public SpiritGelLayer(@NotNull RenderLayerParent<SpiritEntity, SlimeModel<SpiritEntity>> renderer, @NotNull EntityModelSet modelSet) {
            Intrinsics.checkNotNullParameter(renderer, (String)"renderer");
            Intrinsics.checkNotNullParameter((Object)modelSet, (String)"modelSet");
            super(renderer);
            this.model = new SlimeModel(modelSet.bakeLayer(ModelLayers.SLIME_OUTER));
        }

        @NotNull
        public final SlimeModel<SpiritEntity> getModel() {
            return this.model;
        }

        public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, @NotNull SpiritEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
            Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
            Intrinsics.checkNotNullParameter((Object)((Object)livingEntity), (String)"livingEntity");
            if (livingEntity.isInvisible()) {
                return;
            }
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)livingEntity)));
            ((SlimeModel)this.getParentModel()).copyPropertiesTo((EntityModel)this.model);
            this.model.prepareMobModel((Entity)livingEntity, limbSwing, limbSwingAmount, partialTick);
            this.model.setupAnim((Entity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.renderToBuffer(poseStack, consumer, packedLight, MobRenderer.getOverlayCoords((LivingEntity)((LivingEntity)livingEntity), (float)0.0f));
        }
    }
}

