/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.aaronhowser.mods.irregular_implements.command.ModCommands;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooFireplace;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooNetworkSavedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\bJ\u0012\u0010\n\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\bH\u0002J\u0012\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\bH\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00052\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/irregular_implements/command/FireplaceCommand;", "", "<init>", "()V", "FIREPLACE_NAME", "", "DIMENSION", "register", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lnet/minecraft/commands/CommandSourceStack;", "createListCommand", "createTeleportCommand", "teleportTo", "", "source", "target", "levelRk", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "listFireplaces", "SUGGEST_FIREPLACES", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "getSUGGEST_FIREPLACES", "()Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nFireplaceCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FireplaceCommand.kt\ndev/aaronhowser/mods/irregular_implements/command/FireplaceCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1617#2,9:156\n1869#2:165\n1870#2:167\n1626#2:168\n1#3:166\n*S KotlinDebug\n*F\n+ 1 FireplaceCommand.kt\ndev/aaronhowser/mods/irregular_implements/command/FireplaceCommand\n*L\n151#1:156,9\n151#1:165\n151#1:167\n151#1:168\n151#1:166\n*E\n"})
public final class FireplaceCommand {
    @NotNull
    public static final FireplaceCommand INSTANCE = new FireplaceCommand();
    @NotNull
    private static final String FIREPLACE_NAME = "fireplace_name";
    @NotNull
    private static final String DIMENSION = "dimension";
    @NotNull
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_FIREPLACES = FireplaceCommand::SUGGEST_FIREPLACES$lambda$8;

    private FireplaceCommand() {
    }

    @NotNull
    public final ArgumentBuilder<CommandSourceStack, ?> register() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)Commands.literal((String)"fireplace").then(this.createListCommand())).then(this.createTeleportCommand());
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    private final ArgumentBuilder<CommandSourceStack, ?> createListCommand() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)Commands.literal((String)"list").executes(FireplaceCommand::createListCommand$lambda$0)).then(Commands.argument((String)DIMENSION, (ArgumentType)((ArgumentType)ResourceLocationArgument.id())).suggests(ModCommands.INSTANCE.getSUGGEST_LEVEL_RKS()).executes(FireplaceCommand::createListCommand$lambda$1));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    private final ArgumentBuilder<CommandSourceStack, ?> createTeleportCommand() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"teleport").requires(FireplaceCommand::createTeleportCommand$lambda$2)).then(Commands.argument((String)FIREPLACE_NAME, (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(FireplaceCommand::createTeleportCommand$lambda$3))).then(Commands.argument((String)DIMENSION, (ArgumentType)((ArgumentType)ResourceLocationArgument.id())).suggests(ModCommands.INSTANCE.getSUGGEST_LEVEL_RKS()).then(Commands.argument((String)FIREPLACE_NAME, (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(FireplaceCommand::createTeleportCommand$lambda$4)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    private final int teleportTo(CommandSourceStack source, String target, ResourceKey<Level> levelRk) {
        ServerLevel level;
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel serverLevel = level = levelRk == null ? player.serverLevel() : player.server.getLevel(levelRk);
        if (level == null) {
            ResourceLocation resourceLocation = levelRk;
            Object[] objectArray = new Object[]{resourceLocation != null && (resourceLocation = resourceLocation.location()) != null ? (Comparable)resourceLocation : (Comparable)((Object)"null")};
            source.sendFailure((Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.command.level_not_found", objectArray));
            return 0;
        }
        FlooNetworkSavedData network = FlooNetworkSavedData.Companion.get(level);
        FlooFireplace fireplace = network.findFireplace(target);
        if (fireplace == null) {
            Object[] objectArray = new Object[]{target};
            source.sendFailure((Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.not_found", objectArray));
            return 0;
        }
        Intrinsics.checkNotNull((Object)player);
        fireplace.teleportToThis(player);
        return 1;
    }

    private final int listFireplaces(CommandSourceStack source, ResourceKey<Level> levelRk) {
        ServerLevel level = source.getServer().getLevel(levelRk);
        if (level == null) {
            Object[] objectArray = new Object[]{levelRk.location()};
            source.sendFailure((Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.command.level_not_found", objectArray));
            return 0;
        }
        FlooNetworkSavedData network = FlooNetworkSavedData.Companion.get(level);
        List<FlooFireplace> fireplaces = network.getFireplaces();
        Function0 message = () -> FireplaceCommand.listFireplaces$lambda$5(levelRk, fireplaces);
        source.sendSuccess(() -> FireplaceCommand.listFireplaces$lambda$6(message), false);
        return 1;
    }

    @NotNull
    public final SuggestionProvider<CommandSourceStack> getSUGGEST_FIREPLACES() {
        return SUGGEST_FIREPLACES;
    }

    private static final int createListCommand$lambda$0(CommandContext ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ResourceKey levelRk = source.getLevel().dimension();
        Intrinsics.checkNotNull((Object)source);
        Intrinsics.checkNotNull((Object)levelRk);
        return INSTANCE.listFireplaces(source, (ResourceKey<Level>)levelRk);
    }

    private static final int createListCommand$lambda$1(CommandContext ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ResourceLocation levelRl = ResourceLocationArgument.getId((CommandContext)ctx, (String)DIMENSION);
        ResourceKey levelRk = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)levelRl);
        Intrinsics.checkNotNull((Object)source);
        Intrinsics.checkNotNull((Object)levelRk);
        return INSTANCE.listFireplaces(source, (ResourceKey<Level>)levelRk);
    }

    private static final boolean createTeleportCommand$lambda$2(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int createTeleportCommand$lambda$3(CommandContext ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        String target = StringArgumentType.getString((CommandContext)ctx, (String)FIREPLACE_NAME);
        Intrinsics.checkNotNull((Object)source);
        Intrinsics.checkNotNull((Object)target);
        return INSTANCE.teleportTo(source, target, null);
    }

    private static final int createTeleportCommand$lambda$4(CommandContext ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        String target = StringArgumentType.getString((CommandContext)ctx, (String)FIREPLACE_NAME);
        ResourceLocation levelRl = ResourceLocationArgument.getId((CommandContext)ctx, (String)DIMENSION);
        ResourceKey levelRk = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)levelRl);
        Intrinsics.checkNotNull((Object)source);
        Intrinsics.checkNotNull((Object)target);
        return INSTANCE.teleportTo(source, target, (ResourceKey<Level>)levelRk);
    }

    private static final MutableComponent listFireplaces$lambda$5(ResourceKey $levelRk, List $fireplaces) {
        Object[] objectArray = new Object[]{$levelRk.location().toString(), $fireplaces.size()};
        MutableComponent component = ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.fireplaces_in_dimension", objectArray);
        for (FlooFireplace fireplace : $fireplaces) {
            String string = fireplace.getName();
            if (string == null) {
                string = "<unnamed>";
            }
            String name = string;
            BlockPos pos = fireplace.getMasterBlockPos();
            component.append("\n");
            Object[] objectArray2 = new Object[]{name, pos.getX(), pos.getY(), pos.getZ()};
            component.append((Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.list_entry", objectArray2));
        }
        return component;
    }

    private static final Component listFireplaces$lambda$6(Function0 $tmp0) {
        return (Component)$tmp0.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture SUGGEST_FIREPLACES$lambda$8(CommandContext ctx, SuggestionsBuilder builder) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        Intrinsics.checkNotNull((Object)level);
        FlooNetworkSavedData network = FlooNetworkSavedData.Companion.get(level);
        Iterable $this$mapNotNull$iv = network.getFireplaces();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FlooFireplace it = (FlooFireplace)element$iv$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fireplaceNames = (List)destination$iv$iv;
        return SharedSuggestionProvider.suggest((Iterable)fireplaceNames, (SuggestionsBuilder)builder);
    }
}

