/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.entity;

import dev.aaronhowser.mods.irregular_implements.registry.ModEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 F2\u00020\u0001:\u0001FB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\"H\u0016J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020\"H\u0014J\b\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0014J\b\u00100\u001a\u00020,H\u0014J\u0018\u00101\u001a\u00020\"2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0014J\u001a\u00106\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0004\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\"2\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010A\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u001a\u0010\u0017\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\rR\u000e\u0010\u001a\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006G"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/GoldenChickenEntity;", "Lnet/minecraft/world/entity/animal/Animal;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "flap", "", "getFlap", "()F", "setFlap", "(F)V", "flapSpeed", "getFlapSpeed", "setFlapSpeed", "oFlapSpeed", "getOFlapSpeed", "setOFlapSpeed", "oFlap", "getOFlap", "setOFlap", "flapping", "getFlapping", "setFlapping", "nextFlap", "eggTime", "", "getEggTime", "()I", "setEggTime", "(I)V", "registerGoals", "", "getDefaultDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "aiStep", "isFlapping", "", "onFlap", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "playStepSound", "pos", "Lnet/minecraft/core/BlockPos;", "block", "Lnet/minecraft/world/level/block/state/BlockState;", "getBreedOffspring", "Lnet/minecraft/server/level/ServerLevel;", "otherParent", "Lnet/minecraft/world/entity/AgeableMob;", "isFood", "stack", "Lnet/minecraft/world/item/ItemStack;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "positionRider", "passenger", "Lnet/minecraft/world/entity/Entity;", "callback", "Lnet/minecraft/world/entity/Entity$MoveFunction;", "Companion", "irregular-implements-1.21.1"})
public final class GoldenChickenEntity
extends Animal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float flap;
    private float flapSpeed;
    private float oFlapSpeed;
    private float oFlap;
    private float flapping;
    private float nextFlap;
    private int eggTime;
    @NotNull
    private static final EntityDimensions BABY_DIMENSIONS;

    public GoldenChickenEntity(@NotNull EntityType<GoldenChickenEntity> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.flapping = 1.0f;
        this.nextFlap = 1.0f;
        this.eggTime = this.random.nextInt(6000) + 6000;
    }

    public final float getFlap() {
        return this.flap;
    }

    public final void setFlap(float f) {
        this.flap = f;
    }

    public final float getFlapSpeed() {
        return this.flapSpeed;
    }

    public final void setFlapSpeed(float f) {
        this.flapSpeed = f;
    }

    public final float getOFlapSpeed() {
        return this.oFlapSpeed;
    }

    public final void setOFlapSpeed(float f) {
        this.oFlapSpeed = f;
    }

    public final float getOFlap() {
        return this.oFlap;
    }

    public final void setOFlap(float f) {
        this.oFlap = f;
    }

    public final float getFlapping() {
        return this.flapping;
    }

    public final void setFlapping(float f) {
        this.flapping = f;
    }

    public final int getEggTime() {
        return this.eggTime;
    }

    public final void setEggTime(int n) {
        this.eggTime = n;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, GoldenChickenEntity::registerGoals$lambda$0, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        EntityDimensions entityDimensions;
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        if (this.isBaby()) {
            entityDimensions = BABY_DIMENSIONS;
        } else {
            EntityDimensions entityDimensions2 = super.getDefaultDimensions(pose);
            entityDimensions = entityDimensions2;
            Intrinsics.checkNotNullExpressionValue((Object)entityDimensions2, (String)"getDefaultDimensions(...)");
        }
        return entityDimensions;
    }

    public void aiStep() {
        super.aiStep();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.onGround() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        if (!this.level().isClientSide && this.isAlive() && !this.isBaby()) {
            this.eggTime += -1;
            if (this.eggTime <= 0) {
                this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.spawnAtLocation((ItemLike)Items.GOLD_INGOT);
                this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
                this.eggTime = this.random.nextInt(6000) + 6000;
            }
        }
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    protected void onFlap() {
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        SoundEvent soundEvent = SoundEvents.CHICKEN_AMBIENT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"CHICKEN_AMBIENT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        SoundEvent soundEvent = SoundEvents.CHICKEN_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"CHICKEN_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.CHICKEN_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"CHICKEN_DEATH");
        return soundEvent;
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState block) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.playSound(SoundEvents.CHICKEN_STEP, 0.15f, 1.0f);
    }

    @Nullable
    public GoldenChickenEntity getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)otherParent, (String)"otherParent");
        return (GoldenChickenEntity)((EntityType)ModEntityTypes.INSTANCE.getGOLDEN_CHICKEN().get()).create((Level)level);
    }

    public boolean isFood(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.is(ItemTags.CHICKEN_FOOD);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        if (compound.contains("EggLayTime")) {
            this.eggTime = compound.getInt("EggLayTime");
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        compound.putInt("EggLayTime", this.eggTime);
    }

    protected void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        super.positionRider(passenger, callback);
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).yBodyRot = this.yBodyRot;
        }
    }

    private static final boolean registerGoals$lambda$0(ItemStack it) {
        return it.is(ItemTags.CHICKEN_FOOD);
    }

    static {
        EntityDimensions entityDimensions = ((EntityType)ModEntityTypes.INSTANCE.getGOLDEN_CHICKEN().get()).getDimensions().scale(0.5f).withEyeHeight(0.2975f);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"withEyeHeight(...)");
        BABY_DIMENSIONS = entityDimensions;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/GoldenChickenEntity$Companion;", "", "<init>", "()V", "BABY_DIMENSIONS", "Lnet/minecraft/world/entity/EntityDimensions;", "getBABY_DIMENSIONS", "()Lnet/minecraft/world/entity/EntityDimensions;", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDimensions getBABY_DIMENSIONS() {
            return BABY_DIMENSIONS;
        }

        @NotNull
        public final AttributeSupplier createAttributes() {
            AttributeSupplier attributeSupplier = Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25).build();
            Intrinsics.checkNotNullExpressionValue((Object)attributeSupplier, (String)"build(...)");
            return attributeSupplier;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

