/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.entity;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModItemTagsProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModEntityTypes;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0001-B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020\u0012H\u0016J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020\u0016H\u0014J\b\u0010,\u001a\u00020\u0012H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/SpiritEntity;", "Lnet/minecraft/world/entity/FlyingMob;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "age", "", "getAge", "()I", "setAge", "(I)V", "spawnPosition", "Lnet/minecraft/core/BlockPos;", "changePosCounter", "isInvulnerableTo", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "registerGoals", "", "tick", "spawnParticles", "aiStep", "createNavigation", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "ageAndDie", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "knockback", "strength", "", "x", "z", "canBeCollidedWith", "isPushable", "doPush", "entity", "Lnet/minecraft/world/entity/Entity;", "pushEntities", "isIgnoringBlockTriggers", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSpiritEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpiritEntity.kt\ndev/aaronhowser/mods/irregular_implements/entity/SpiritEntity\n+ 2 OtherUtil.kt\ndev/aaronhowser/mods/irregular_implements/util/OtherUtil\n*L\n1#1,195:1\n49#2:196\n49#2:197\n*S KotlinDebug\n*F\n+ 1 SpiritEntity.kt\ndev/aaronhowser/mods/irregular_implements/entity/SpiritEntity\n*L\n49#1:196\n50#1:197\n*E\n"})
public final class SpiritEntity
extends FlyingMob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int age;
    @Nullable
    private BlockPos spawnPosition;
    private int changePosCounter;
    @NotNull
    public static final String AGE_NBT = "Age";

    public SpiritEntity(@NotNull EntityType<? extends FlyingMob> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
        this.moveControl = (MoveControl)new FlyingMoveControl((Mob)this, 20, true);
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (super.isInvulnerableTo(source)) {
            return true;
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        OtherUtil otherUtil = OtherUtil.INSTANCE;
        ItemStack itemStack = source.getWeaponItem();
        Object $this$isTrue$iv = itemStack != null ? Boolean.valueOf(itemStack.is(ModItemTagsProvider.Companion.getDAMAGES_SPIRITS())) : null;
        boolean $i$f$isTrue = false;
        boolean usedSpecialWeapon = Intrinsics.areEqual((Object)$this$isTrue$iv, (Object)true);
        $this$isTrue$iv = OtherUtil.INSTANCE;
        ItemStack itemStack2 = source.getWeaponItem();
        Boolean $this$isTrue$iv2 = itemStack2 != null ? Boolean.valueOf(itemStack2.isEnchanted()) : null;
        boolean $i$f$isTrue2 = false;
        boolean usedEnchantedWeapon = Intrinsics.areEqual((Object)$this$isTrue$iv2, (Object)true);
        boolean usedMagic = source.is(Tags.DamageTypes.IS_MAGIC);
        return !usedSpecialWeapon && !usedEnchantedWeapon && !usedMagic;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    public void tick() {
        super.tick();
        this.ageAndDie();
        this.spawnParticles();
    }

    private final void spawnParticles() {
        if (!OtherUtil.INSTANCE.isClientSide((Entity)this)) {
            return;
        }
        if (this.getX() == this.xOld && this.getY() == this.yOld && this.getZ() == this.zOld) {
            return;
        }
        if ((double)this.random.nextFloat() < 0.5) {
            Level level = this.level();
            ParticleOptions particleOptions = (ParticleOptions)ParticleTypes.ENCHANT;
            double d = this.getX();
            double d2 = this.getY();
            double d3 = this.getZ();
            RandomSource randomSource = this.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
            double d4 = OtherUtil.INSTANCE.nextRange(randomSource, -0.01, 0.01);
            RandomSource randomSource2 = this.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource2, (String)"random");
            double d5 = OtherUtil.INSTANCE.nextRange(randomSource2, 0.0, 0.02);
            RandomSource randomSource3 = this.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource3, (String)"random");
            level.addParticle(particleOptions, d, d2, d3, d4, d5, OtherUtil.INSTANCE.nextRange(randomSource3, -0.01, 0.01));
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.spawnPosition == null) {
            this.spawnPosition = this.blockPosition();
        }
        BlockPos blockPos = this.spawnPosition;
        if (blockPos == null) {
            return;
        }
        BlockPos spawnPos = blockPos;
        int n = this.changePosCounter;
        this.changePosCounter = n + 1;
        if (this.changePosCounter >= 60) {
            this.changePosCounter = 0;
            Vec3 newTarget = null;
            for (int tries = 0; newTarget == null && tries < 10; ++tries) {
                RandomSource randomSource = this.random;
                Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
                double modX = OtherUtil.INSTANCE.nextRange(randomSource, -5.0, 5.0);
                RandomSource randomSource2 = this.random;
                Intrinsics.checkNotNullExpressionValue((Object)randomSource2, (String)"random");
                double modY = OtherUtil.INSTANCE.nextRange(randomSource2, -5.0, 5.0);
                RandomSource randomSource3 = this.random;
                Intrinsics.checkNotNullExpressionValue((Object)randomSource3, (String)"random");
                double modZ = OtherUtil.INSTANCE.nextRange(randomSource3, -5.0, 5.0);
                Vec3 modVec = spawnPos.getCenter().add(modX, modZ, modY);
                BlockPos modPos = BlockPos.containing((Position)((Position)modVec));
                if (!this.level().getBlockState(modPos).isAir()) continue;
                newTarget = modVec;
            }
            if (newTarget != null) {
                this.moveControl.setWantedPosition(newTarget.x + 0.5, newTarget.y + 0.5, newTarget.z + 0.5, 1.0);
            }
        }
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        FlyingPathNavigation flyingNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingNavigation.setCanOpenDoors(false);
        flyingNavigation.setCanFloat(true);
        flyingNavigation.setCanPassDoors(false);
        return (PathNavigation)flyingNavigation;
    }

    private final void ageAndDie() {
        if (this.hasCustomName()) {
            return;
        }
        int n = this.age;
        this.age = n + 1;
        if (this.age > ((Number)ServerConfig.Companion.getCONFIG().getSpiritMaxAge().get()).intValue()) {
            this.kill();
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        this.age = compound.getInt(AGE_NBT);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        compound.putInt(AGE_NBT, this.age);
    }

    public void knockback(double strength, double x, double z) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
    }

    protected void pushEntities() {
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/SpiritEntity$Companion;", "", "<init>", "()V", "AGE_NBT", "", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier;", "trySpawn", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "getSpawnChance", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier createAttributes() {
            AttributeSupplier attributeSupplier = FlyingMob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.FLYING_SPEED, 1.0).build();
            Intrinsics.checkNotNullExpressionValue((Object)attributeSupplier, (String)"build(...)");
            return attributeSupplier;
        }

        public final void trySpawn(@NotNull LivingDeathEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCanceled()) {
                return;
            }
            LivingEntity entity = event.getEntity();
            Level level = entity.level();
            ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (serverLevel == null) {
                return;
            }
            ServerLevel level2 = serverLevel;
            if (level2.random.nextDouble() < this.getSpawnChance(level2)) {
                ((EntityType)ModEntityTypes.INSTANCE.getSPIRIT().get()).spawn(level2, entity.blockPosition(), MobSpawnType.TRIGGERED);
            }
        }

        public final double getSpawnChance(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Double chance = (Double)ServerConfig.Companion.getCONFIG().getSpiritBaseSpawnChance().get();
            if (level.getServer().getWorldData().endDragonFightData().previouslyKilled()) {
                double d = chance;
                Object object = ServerConfig.Companion.getCONFIG().getSpiritSpawnChanceDragonKilledBonus().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                chance = d + ((Number)object).doubleValue();
            }
            int moonPhase = level.getMoonPhase();
            int distToFull = Math.min(moonPhase, 8 - moonPhase);
            double percentToFull = 1.0 - (double)distToFull / 4.0;
            double d = chance;
            Object object = ServerConfig.Companion.getCONFIG().getSpiritSpawnFullMoonBonus().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            chance = d + percentToFull * ((Number)object).doubleValue();
            return RangesKt.coerceIn((double)chance, (double)0.0, (double)1.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

