/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.entity;

import dev.aaronhowser.mods.irregular_implements.entity.GoldenChickenEntity;
import dev.aaronhowser.mods.irregular_implements.registry.ModEntityTypes;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0014\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/ThrownGoldenEggEntity;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "shooter", "Lnet/minecraft/world/entity/LivingEntity;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", "x", "", "y", "z", "(Lnet/minecraft/world/level/Level;DDD)V", "onHit", "", "result", "Lnet/minecraft/world/phys/HitResult;", "spawnGoldenChicken", "onHitEntity", "Lnet/minecraft/world/phys/EntityHitResult;", "handleEntityEvent", "id", "", "getDefaultItem", "Lnet/minecraft/world/item/Item;", "Companion", "irregular-implements-1.21.1"})
public final class ThrownGoldenEggEntity
extends ThrowableItemProjectile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDimensions ZERO_SIZED_DIMENSIONS;

    public ThrownGoldenEggEntity(@NotNull EntityType<ThrownGoldenEggEntity> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
    }

    public ThrownGoldenEggEntity(@NotNull Level level, @NotNull LivingEntity shooter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
        super((EntityType)ModEntityTypes.INSTANCE.getGOLDEN_EGG().get(), shooter, level);
    }

    public ThrownGoldenEggEntity(@NotNull Level level, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)ModEntityTypes.INSTANCE.getGOLDEN_EGG().get(), x, y, z, level);
    }

    protected void onHit(@NotNull HitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHit(result);
        if (this.level().isClientSide) {
            return;
        }
        this.spawnGoldenChicken();
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        this.discard();
    }

    private final void spawnGoldenChicken() {
        int i = 1;
        if (this.random.nextInt(32) == 0) {
            i = 4;
        }
        int n = i;
        for (int j = 0; j < n; ++j) {
            GoldenChickenEntity chicken = (GoldenChickenEntity)((EntityType)ModEntityTypes.INSTANCE.getGOLDEN_CHICKEN().get()).create(this.level());
            if (chicken == null) continue;
            chicken.setAge(-24000);
            chicken.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            if (!chicken.fudgePositionAfterSizeChange(ZERO_SIZED_DIMENSIONS)) break;
            this.level().addFreshEntity((Entity)chicken);
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08);
            }
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        Object object = ModItems.INSTANCE.getGOLDEN_EGG().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }

    static {
        EntityDimensions entityDimensions = EntityDimensions.fixed((float)0.0f, (float)0.0f);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"fixed(...)");
        ZERO_SIZED_DIMENSIONS = entityDimensions;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/ThrownGoldenEggEntity$Companion;", "", "<init>", "()V", "ZERO_SIZED_DIMENSIONS", "Lnet/minecraft/world/entity/EntityDimensions;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

