/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/SpectreCoilSavedData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "coilEntries", "", "Ljava/util/UUID;", "", "energyInjectors", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "coils", "getEnergyInjector", "ownerUuid", "getCoil", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "Companion", "irregular-implements-1.21.1"})
public final class SpectreCoilSavedData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UUID, Integer> coilEntries = new LinkedHashMap();
    @NotNull
    private final Map<UUID, IEnergyStorage> energyInjectors = new LinkedHashMap();
    @NotNull
    private final Map<UUID, IEnergyStorage> coils = new LinkedHashMap();
    @NotNull
    public static final String COIL_ENTRIES_NBT = "coil_entries";
    @NotNull
    public static final String UUID_NBT = "uuid";
    @NotNull
    public static final String ENERGY_NBT = "energy";

    @NotNull
    public final IEnergyStorage getEnergyInjector(@NotNull UUID ownerUuid) {
        Intrinsics.checkNotNullParameter((Object)ownerUuid, (String)"ownerUuid");
        IEnergyStorage existing = this.energyInjectors.get(ownerUuid);
        if (existing != null) {
            return existing;
        }
        IEnergyStorage iEnergyStorage = new IEnergyStorage(this, ownerUuid){
            final /* synthetic */ SpectreCoilSavedData this$0;
            final /* synthetic */ UUID $ownerUuid;
            {
                this.this$0 = $receiver;
                this.$ownerUuid = $ownerUuid;
            }

            public int receiveEnergy(int toReceive, boolean simulate) {
                int currentEnergy = ((Number)SpectreCoilSavedData.access$getCoilEntries$p(this.this$0).getOrDefault(this.$ownerUuid, 0)).intValue();
                int newEnergy = Math.min(this.getMaxEnergyStored(), currentEnergy + toReceive);
                if (!simulate) {
                    Integer n = newEnergy;
                    SpectreCoilSavedData.access$getCoilEntries$p(this.this$0).put(this.$ownerUuid, n);
                }
                this.this$0.setDirty();
                return newEnergy - currentEnergy;
            }

            public int extractEnergy(int toExtract, boolean simulate) {
                return 0;
            }

            public int getEnergyStored() {
                return ((Number)SpectreCoilSavedData.access$getCoilEntries$p(this.this$0).getOrDefault(this.$ownerUuid, 0)).intValue();
            }

            public int getMaxEnergyStored() {
                return SpectreCoilSavedData.Companion.getMAX_ENERGY();
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return true;
            }
        };
        this.energyInjectors.put(ownerUuid, iEnergyStorage);
        return iEnergyStorage;
    }

    @NotNull
    public final IEnergyStorage getCoil(@NotNull UUID ownerUuid) {
        Intrinsics.checkNotNullParameter((Object)ownerUuid, (String)"ownerUuid");
        IEnergyStorage existing = this.coils.get(ownerUuid);
        if (existing != null) {
            return existing;
        }
        IEnergyStorage iEnergyStorage = new IEnergyStorage(this, ownerUuid){
            final /* synthetic */ SpectreCoilSavedData this$0;
            final /* synthetic */ UUID $ownerUuid;
            {
                this.this$0 = $receiver;
                this.$ownerUuid = $ownerUuid;
            }

            public int receiveEnergy(int toReceive, boolean simulate) {
                return 0;
            }

            public int extractEnergy(int toExtract, boolean simulate) {
                int currentEntity = ((Number)SpectreCoilSavedData.access$getCoilEntries$p(this.this$0).getOrDefault(this.$ownerUuid, 0)).intValue();
                int newEnergy = Math.max(0, currentEntity - toExtract);
                if (!simulate) {
                    Integer n = newEnergy;
                    SpectreCoilSavedData.access$getCoilEntries$p(this.this$0).put(this.$ownerUuid, n);
                }
                this.this$0.setDirty();
                return currentEntity - newEnergy;
            }

            public int getEnergyStored() {
                return ((Number)SpectreCoilSavedData.access$getCoilEntries$p(this.this$0).getOrDefault(this.$ownerUuid, 0)).intValue();
            }

            public int getMaxEnergyStored() {
                return SpectreCoilSavedData.Companion.getMAX_ENERGY();
            }

            public boolean canExtract() {
                return true;
            }

            public boolean canReceive() {
                return false;
            }
        };
        this.coils.put(ownerUuid, iEnergyStorage);
        return iEnergyStorage;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ListTag listTag = tag.getList(COIL_ENTRIES_NBT, 10);
        for (Map.Entry<UUID, Integer> entry2 : this.coilEntries.entrySet()) {
            UUID uuid = entry2.getKey();
            int energy = ((Number)entry2.getValue()).intValue();
            CompoundTag entryTag = new CompoundTag();
            entryTag.putString(UUID_NBT, uuid.toString());
            entryTag.putInt(ENERGY_NBT, energy);
            listTag.add((Object)entryTag);
        }
        return tag;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/SpectreCoilSavedData$Companion;", "", "<init>", "()V", "load", "Ldev/aaronhowser/mods/irregular_implements/handler/SpectreCoilSavedData;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "get", "level", "Lnet/minecraft/server/level/ServerLevel;", "COIL_ENTRIES_NBT", "", "UUID_NBT", "ENERGY_NBT", "MAX_ENERGY", "", "getMAX_ENERGY", "()I", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final SpectreCoilSavedData load(CompoundTag tag, HolderLookup.Provider provider) {
            SpectreCoilSavedData spectreCoilSavedData = new SpectreCoilSavedData();
            ListTag listTag = tag.getList(SpectreCoilSavedData.COIL_ENTRIES_NBT, 10);
            Intrinsics.checkNotNull((Object)listTag);
            int n = ((Collection)listTag).size();
            for (int i = 0; i < n; ++i) {
                CompoundTag entryTag = listTag.getCompound(i);
                UUID uuid = UUID.fromString(entryTag.getString(SpectreCoilSavedData.UUID_NBT));
                int energy = entryTag.getInt(SpectreCoilSavedData.ENERGY_NBT);
                Integer n2 = energy;
                spectreCoilSavedData.coilEntries.put(uuid, n2);
            }
            return spectreCoilSavedData;
        }

        @NotNull
        public final SpectreCoilSavedData get(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (!Intrinsics.areEqual((Object)level, (Object)level.getServer().overworld())) {
                ServerLevel serverLevel = level.getServer().overworld();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
                return this.get(serverLevel);
            }
            SavedData savedData = level.getDataStorage().computeIfAbsent(new SavedData.Factory(SpectreCoilSavedData::new, this::load), "spectre_coil");
            Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"computeIfAbsent(...)");
            return (SpectreCoilSavedData)savedData;
        }

        public final int getMAX_ENERGY() {
            Object object = ServerConfig.Companion.getCONFIG().getSpectreBufferCapacity().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

