/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler.spectre_cube;

import dev.aaronhowser.mods.irregular_implements.handler.spectre_cube.SpectreCubeSavedData;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tJ\u0018\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020\tH\u0002J\u0006\u0010)\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCube;", "", "handler", "Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCubeSavedData;", "<init>", "(Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCubeSavedData;)V", "owner", "Ljava/util/UUID;", "cubeIndex", "", "(Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCubeSavedData;Ljava/util/UUID;I)V", "getHandler", "()Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCubeSavedData;", "getOwner", "()Ljava/util/UUID;", "setOwner", "(Ljava/util/UUID;)V", "guests", "", "getGuests", "()Ljava/util/List;", "interiorHeight", "getInteriorHeight", "()I", "setInteriorHeight", "(I)V", "getCubeIndex", "setCubeIndex", "spawnPos", "Lnet/minecraft/core/BlockPos;", "getSpawnPos", "toTag", "Lnet/minecraft/nbt/CompoundTag;", "generate", "", "level", "Lnet/minecraft/world/level/Level;", "increaseHeight", "amountToAdd", "changeHeight", "newHeight", "getOriginPos", "Companion", "irregular-implements-1.21.1"})
public final class SpectreCube {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpectreCubeSavedData handler;
    @Nullable
    private UUID owner;
    @NotNull
    private final List<UUID> guests;
    private int interiorHeight;
    private int cubeIndex;
    @NotNull
    private BlockPos spawnPos;
    @NotNull
    public static final String OWNER_NBT = "owner";
    @NotNull
    public static final String GUESTS_NBT = "guests";
    @NotNull
    public static final String UUID_NBT = "uuid";
    @NotNull
    public static final String INTERIOR_HEIGHT_NBT = "interior_height";
    @NotNull
    public static final String INDEX_NBT = "index";
    @NotNull
    public static final String SPAWN_BLOCK_NBT = "spawn_block";

    public SpectreCube(@NotNull SpectreCubeSavedData handler) {
        Intrinsics.checkNotNullParameter((Object)((Object)handler), (String)"handler");
        this.handler = handler;
        this.guests = new ArrayList();
        this.interiorHeight = 2;
        this.spawnPos = new BlockPos(8, 0, 8);
    }

    @NotNull
    public final SpectreCubeSavedData getHandler() {
        return this.handler;
    }

    @Nullable
    public final UUID getOwner() {
        return this.owner;
    }

    public final void setOwner(@Nullable UUID uUID) {
        this.owner = uUID;
    }

    @NotNull
    public final List<UUID> getGuests() {
        return this.guests;
    }

    public final int getInteriorHeight() {
        return this.interiorHeight;
    }

    public final void setInteriorHeight(int n) {
        this.interiorHeight = n;
    }

    public final int getCubeIndex() {
        return this.cubeIndex;
    }

    public final void setCubeIndex(int n) {
        this.cubeIndex = n;
    }

    @NotNull
    public final BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public SpectreCube(@NotNull SpectreCubeSavedData handler, @NotNull UUID owner, int cubeIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)handler), (String)"handler");
        Intrinsics.checkNotNullParameter((Object)owner, (String)OWNER_NBT);
        this(handler);
        this.owner = owner;
        this.cubeIndex = cubeIndex;
        BlockPos blockPos = this.getOriginPos().offset(8, 0, 8);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
        this.spawnPos = blockPos;
    }

    @NotNull
    public final CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        UUID owner = this.owner;
        if (owner != null) {
            tag.putUUID(OWNER_NBT, owner);
        }
        tag.putInt(INTERIOR_HEIGHT_NBT, this.interiorHeight);
        tag.putInt(INDEX_NBT, this.cubeIndex);
        ListTag guestList = tag.getList(GUESTS_NBT, 10);
        for (UUID guest : this.guests) {
            CompoundTag guestTag = new CompoundTag();
            guestTag.putUUID(UUID_NBT, guest);
            guestList.add((Object)guestTag);
        }
        tag.put(GUESTS_NBT, (Tag)guestList);
        tag.putLong(SPAWN_BLOCK_NBT, this.spawnPos.asLong());
        return tag;
    }

    public final void generate(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!(level instanceof ServerLevel)) {
            return;
        }
        BlockPos cornerOne = this.getOriginPos();
        BlockPos cornerTwo = cornerOne.offset(15, this.interiorHeight + 1, 15);
        Intrinsics.checkNotNull((Object)cornerTwo);
        BlockState blockState = ((Block)ModBlocks.INSTANCE.getSPECTRE_BLOCK().get()).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        SpectreCube.Companion.generateCubeShell(level, cornerOne, cornerTwo, blockState);
        BlockPos blockPos = cornerOne.offset(7, 0, 7);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
        BlockPos blockPos2 = cornerOne.offset(8, 0, 8);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"offset(...)");
        BlockState blockState2 = ((Block)ModBlocks.INSTANCE.getSPECTRE_CORE().get()).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        SpectreCube.Companion.generateCubeShell(level, blockPos, blockPos2, blockState2);
    }

    public final int increaseHeight(int amountToAdd) {
        Level level = this.handler.getSpectreLevel();
        if (level == null) {
            return 0;
        }
        Level level2 = level;
        int maxToAdd = level2.getMaxBuildHeight() - (this.interiorHeight + 2);
        int newHeight = RangesKt.coerceAtMost((int)(this.interiorHeight + amountToAdd), (int)(this.interiorHeight + maxToAdd));
        if (newHeight == this.interiorHeight) {
            return 0;
        }
        int delta = newHeight - this.interiorHeight;
        this.changeHeight(level2, newHeight);
        return delta;
    }

    private final void changeHeight(Level level, int newHeight) {
        BlockPos cornerOne = this.getOriginPos();
        BlockPos cornerTwo = cornerOne.offset(15, this.interiorHeight + 1, 15);
        Intrinsics.checkNotNull((Object)cornerTwo);
        BlockState blockState = Blocks.AIR.defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        SpectreCube.Companion.generateCubeShell(level, cornerOne, cornerTwo, blockState);
        this.interiorHeight = newHeight;
        this.generate(level);
        this.handler.setDirty();
    }

    @NotNull
    public final BlockPos getOriginPos() {
        return Companion.getCubeOriginPos(this.cubeIndex);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCube$Companion;", "", "<init>", "()V", "getCubeOriginPos", "Lnet/minecraft/core/BlockPos;", "cubeIndex", "", "OWNER_NBT", "", "GUESTS_NBT", "UUID_NBT", "INTERIOR_HEIGHT_NBT", "INDEX_NBT", "SPAWN_BLOCK_NBT", "generateCubeShell", "", "level", "Lnet/minecraft/world/level/Level;", "cornerOne", "cornerTwo", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "fromTag", "Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCube;", "handler", "Ldev/aaronhowser/mods/irregular_implements/handler/spectre_cube/SpectreCubeSavedData;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockPos getCubeOriginPos(int cubeIndex) {
            int x = cubeIndex * 16 * 16;
            return new BlockPos(x, 0, 0);
        }

        private final void generateCubeShell(Level level, BlockPos cornerOne, BlockPos cornerTwo, BlockState state) {
            block5: {
                int minX = Math.min(cornerOne.getX(), cornerTwo.getX());
                int minY = Math.min(cornerOne.getY(), cornerTwo.getY());
                int minZ = Math.min(cornerOne.getZ(), cornerTwo.getZ());
                int maxX = Math.max(cornerOne.getX(), cornerTwo.getX());
                int maxY = Math.max(cornerOne.getY(), cornerTwo.getY());
                int maxZ = Math.max(cornerOne.getZ(), cornerTwo.getZ());
                int x = minX;
                if (x > maxX) break block5;
                while (true) {
                    block6: {
                        int y;
                        if ((y = minY) > maxY) break block6;
                        while (true) {
                            block7: {
                                int z;
                                if ((z = minZ) > maxZ) break block7;
                                while (true) {
                                    block9: {
                                        block8: {
                                            Object[] objectArray = new Integer[]{minX, maxX};
                                            if (SetsKt.setOf((Object[])objectArray).contains(x)) break block8;
                                            objectArray = new Integer[]{minY, maxY};
                                            if (SetsKt.setOf((Object[])objectArray).contains(y)) break block8;
                                            objectArray = new Integer[]{minZ, maxZ};
                                            if (!SetsKt.setOf((Object[])objectArray).contains(z)) break block9;
                                        }
                                        level.setBlockAndUpdate(new BlockPos(x, y, z), state);
                                    }
                                    if (z == maxZ) break;
                                    ++z;
                                }
                            }
                            if (y == maxY) break;
                            ++y;
                        }
                    }
                    if (x == maxX) break;
                    ++x;
                }
            }
        }

        @NotNull
        public final SpectreCube fromTag(@NotNull SpectreCubeSavedData handler, @NotNull CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)((Object)handler), (String)"handler");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            SpectreCube cube = new SpectreCube(handler);
            cube.setOwner(OtherUtil.INSTANCE.getUuidOrNull(tag, SpectreCube.OWNER_NBT));
            cube.setInteriorHeight(tag.getInt(SpectreCube.INTERIOR_HEIGHT_NBT));
            cube.setCubeIndex(tag.getInt(SpectreCube.INDEX_NBT));
            BlockPos blockPos = BlockPos.of((long)tag.getLong(SpectreCube.SPAWN_BLOCK_NBT));
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"of(...)");
            cube.spawnPos = blockPos;
            ListTag guestList = tag.getList(SpectreCube.GUESTS_NBT, 10);
            int n = ((Collection)guestList).size();
            for (int i = 0; i < n; ++i) {
                CompoundTag guestTag = guestList.getCompound(i);
                Intrinsics.checkNotNull((Object)guestTag);
                UUID guestUuid = OtherUtil.INSTANCE.getUuidOrNull(guestTag, SpectreCube.UUID_NBT);
                if (guestUuid == null) continue;
                cube.getGuests().add(guestUuid);
            }
            return cube;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

