/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBlockTagsProvider;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006\""}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "overrideOtherStackedOnMe", "", "thisStack", "Lnet/minecraft/world/item/ItemStack;", "other", "slot", "Lnet/minecraft/world/inventory/Slot;", "action", "Lnet/minecraft/world/inventory/ClickAction;", "player", "Lnet/minecraft/world/entity/player/Player;", "access", "Lnet/minecraft/world/entity/SlotAccess;", "overrideStackedOnOther", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nBlockReplacerItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockReplacerItem.kt\ndev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n774#2:250\n865#2,2:251\n774#2:253\n865#2,2:254\n1761#2,3:256\n*S KotlinDebug\n*F\n+ 1 BlockReplacerItem.kt\ndev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem\n*L\n59#1:250\n59#1:251,2\n60#1:253\n60#1:254,2\n149#1:256,3\n*E\n"})
public final class BlockReplacerItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public BlockReplacerItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return InteractionResult.PASS;
        }
        ServerLevel level2 = serverLevel;
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player player2 = player;
        ItemStack usedStack = context.getItemInHand();
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = level2.getBlockState(clickedPos);
        if (clickedState.getDestroySpeed((BlockGetter)level2, clickedPos) == -1.0f || clickedState.is(ModBlockTagsProvider.Companion.getBLOCK_REPLACER_BLACKLIST())) {
            return InteractionResult.PASS;
        }
        if (!player2.mayUseItemAt(clickedPos, context.getClickedFace(), usedStack)) {
            return InteractionResult.PASS;
        }
        ItemContainerContents itemContainerContents = (ItemContainerContents)usedStack.get(DataComponents.CONTAINER);
        if (itemContainerContents == null) {
            Object[] objectArray = new ItemStack[]{Blocks.STONE.asItem().getDefaultInstance().copyWithCount(32), Blocks.GRASS_BLOCK.asItem().getDefaultInstance().copyWithCount(32), Items.DIAMOND_PICKAXE.getDefaultInstance()};
            itemContainerContents = ItemContainerContents.fromItems((List)CollectionsKt.listOf((Object[])objectArray));
        }
        ItemContainerContents component = itemContainerContents;
        Iterable iterable = component.nonEmptyItems();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"nonEmptyItems(...)");
        List storedStacks = CollectionsKt.toList((Iterable)iterable);
        if (storedStacks.isEmpty()) {
            return InteractionResult.PASS;
        }
        Iterable $this$filter$iv = storedStacks;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(it.getItem() instanceof BlockItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List storedBlockStacks = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = storedBlockStacks;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl = false;
            Item item = it.getItem();
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
            Block block = ((BlockItem)item).getBlock();
            if (!(!clickedState.is(block) && block.getStateForPlacement(new BlockPlaceContext(context)) != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List possibleBlocksToPlace = (List)destination$iv$iv2;
        ItemStack itemStack = (ItemStack)CollectionsKt.randomOrNull((Collection)possibleBlocksToPlace, (Random)((Random)Random.Default));
        if (itemStack == null) {
            return InteractionResult.PASS;
        }
        ItemStack stackToPlace = itemStack;
        Item item = stackToPlace.getItem();
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type net.minecraft.world.item.BlockItem");
        BlockState blockState = ((BlockItem)item).getBlock().getStateForPlacement(new BlockPlaceContext(context));
        if (blockState == null) {
            return InteractionResult.PASS;
        }
        BlockState stateToPlace = blockState;
        if (!stateToPlace.canSurvive((LevelReader)level2, clickedPos) && ((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent((Level)level2, clickedPos, clickedState, player2))).isCanceled()) {
            return InteractionResult.PASS;
        }
        List drops = player2.hasInfiniteMaterials() ? CollectionsKt.emptyList() : Block.getDrops((BlockState)clickedState, (ServerLevel)level2, (BlockPos)clickedPos, (BlockEntity)level2.getBlockEntity(clickedPos));
        level2.captureBlockSnapshots = true;
        level2.setBlockAndUpdate(clickedPos, stateToPlace);
        level2.captureBlockSnapshots = false;
        ArrayList arrayList = level2.capturedBlockSnapshots;
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"capturedBlockSnapshots");
        List snapshots = CollectionsKt.toList((Iterable)arrayList);
        level2.capturedBlockSnapshots.clear();
        for (BlockSnapshot snapshot : snapshots) {
            if (!((BlockEvent.EntityPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(snapshot, clickedState, (Entity)player2))).isCanceled()) continue;
            level2.restoringBlockSnapshots = true;
            snapshot.restore(snapshot.getFlags() | 2);
            level2.restoringBlockSnapshots = false;
            return InteractionResult.FAIL;
        }
        SoundType originalStateSoundType = clickedState.getSoundType((LevelReader)level2, clickedPos, (Entity)player2);
        level2.playSound(null, clickedPos, originalStateSoundType.getBreakSound(), SoundSource.BLOCKS, (originalStateSoundType.volume + 1.0f) / 2.0f, originalStateSoundType.pitch * 0.8f);
        SoundType newStateSoundType = stateToPlace.getSoundType((LevelReader)level2, clickedPos, (Entity)player2);
        level2.playSound(null, clickedPos, newStateSoundType.getPlaceSound(), SoundSource.BLOCKS, (newStateSoundType.volume + 1.0f) / 2.0f, newStateSoundType.pitch * 0.8f);
        for (ItemStack drop : drops) {
            Block.popResourceFromFace((Level)((Level)level2), (BlockPos)clickedPos, (Direction)context.getClickedFace(), (ItemStack)drop);
        }
        stackToPlace.consume(1, (LivingEntity)player2);
        usedStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)storedStacks));
        return InteractionResult.SUCCESS;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack thisStack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        boolean mayInsert;
        boolean bl;
        List storedStacks;
        block6: {
            Intrinsics.checkNotNullParameter((Object)thisStack, (String)"thisStack");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            if (action != ClickAction.SECONDARY || !slot.allowModification(player) || !(other.getItem() instanceof BlockItem)) {
                return false;
            }
            ItemContainerContents itemContainerContents = (ItemContainerContents)thisStack.get(DataComponents.CONTAINER);
            if (itemContainerContents == null) {
                itemContainerContents = ItemContainerContents.fromItems((List)CollectionsKt.emptyList());
            }
            ItemContainerContents currentContents = itemContainerContents;
            Iterable iterable = currentContents.nonEmptyItems();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"nonEmptyItems(...)");
            storedStacks = CollectionsKt.toList((Iterable)iterable);
            Iterable $this$any$iv = storedStacks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getItem(), (Object)other.getItem())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean bl3 = mayInsert = bl || storedStacks.size() + 1 <= ((Number)ServerConfig.Companion.getCONFIG().getBlockReplacerUniqueBlocks().get()).intValue();
        if (!mayInsert) {
            return false;
        }
        List<ItemStack> newContents = OtherUtil.INSTANCE.flattenStacks(CollectionsKt.plus((Collection)storedStacks, (Object)other.copy()));
        thisStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(newContents));
        other.setCount(0);
        player.level().playSound((Player)(player.level().isClientSide ? player : null), player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.33f);
        return true;
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack thisStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)thisStack, (String)"thisStack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        ItemStack otherStack = slot.getItem();
        if (!otherStack.isEmpty()) {
            return false;
        }
        ItemContainerContents itemContainerContents = (ItemContainerContents)thisStack.get(DataComponents.CONTAINER);
        if (itemContainerContents == null) {
            return false;
        }
        ItemContainerContents currentContents = itemContainerContents;
        Iterable iterable = currentContents.nonEmptyItems();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"nonEmptyItems(...)");
        List storedStacks = CollectionsKt.toMutableList((Iterable)iterable);
        if (storedStacks.isEmpty()) {
            return false;
        }
        ItemStack stackToInsert = (ItemStack)storedStacks.removeLast();
        slot.set(stackToInsert.copy());
        thisStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)storedStacks));
        player.level().playSound((Player)(player.level().isClientSide ? player : null), player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.33f);
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        if (!tooltipFlag.hasShiftDown()) {
            MutableComponent controlsComponent = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.shift_for_more", new Object[0]);
            v0 = tooltipComponents.add((Component)controlsComponent);
        } else {
            MutableComponent loadingComponent = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.block_replacer_loading", new Object[0]);
            MutableComponent unloadingComponent = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.block_replacer_unloading", new Object[0]);
            tooltipComponents.add((Component)loadingComponent);
            v0 = tooltipComponents.add((Component)unloadingComponent);
        }
        if ((object = (ItemContainerContents)stack.get(DataComponents.CONTAINER)) == null || (object = object.nonEmptyItems()) == null || (object = CollectionsKt.toList((Iterable)object)) == null) {
            return;
        }
        Object storedStacks = object;
        if (!tooltipFlag.hasAltDown()) {
            MutableComponent altComponent = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.block_replacer_alt_for_list", new Object[0]);
            tooltipComponents.add((Component)altComponent);
        } else {
            Map map = new LinkedHashMap();
            Iterator<Object> iterator = storedStacks.iterator();
            while (iterator.hasNext()) {
                ItemStack entry2 = (ItemStack)iterator.next();
                Item item = entry2.getItem();
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
                int count = ((Number)map.getOrDefault(item, 0)).intValue();
                map.put(entry2.getItem(), count + entry2.getCount());
            }
            for (Map.Entry entry2 : map.entrySet()) {
                Item item = (Item)entry2.getKey();
                int count = ((Number)entry2.getValue()).intValue();
                Component itemComponent = item.getDefaultInstance().getDisplayName();
                Object[] objectArray = new Object[]{itemComponent, count};
                MutableComponent component = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.item_count", objectArray);
                tooltipComponents.add((Component)component);
            }
        }
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BlockReplacerItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

