/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import java.time.LocalDate;
import java.time.Month;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J.\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/FlooPouchItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "getBarColor", "", "stack", "isBarVisible", "", "getBarWidth", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
public final class FlooPouchItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_FLOO_POWDER = 128;
    @NotNull
    private static final Function0<Item.Properties> DEFAULT_PROPERTIES = FlooPouchItem::DEFAULT_PROPERTIES$lambda$0;

    public FlooPouchItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack usedStack = player.getItemInHand(usedHand);
        if (level.isClientSide || !player.isSecondaryUseActive()) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)usedStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
            return interactionResultHolder;
        }
        Integer currentFlooPowder = (Integer)usedStack.getOrDefault((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER(), (Object)0);
        if (currentFlooPowder >= 128) {
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)usedStack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
            return interactionResultHolder;
        }
        Iterator iterator = player.getInventory().items.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack invStack = (ItemStack)iterator2.next();
            if (!invStack.is((Holder)ModItems.INSTANCE.getFLOO_POWDER())) continue;
            Integer newCurrentFlooPowder = (Integer)usedStack.getOrDefault((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER(), (Object)0);
            Intrinsics.checkNotNull((Object)newCurrentFlooPowder);
            int toTransfer = Math.min(128 - newCurrentFlooPowder, invStack.getCount());
            invStack.shrink(toTransfer);
            int newFlooPowder = newCurrentFlooPowder + toTransfer;
            usedStack.set((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER(), (Object)newFlooPowder);
            if (newFlooPowder < 128) continue;
        }
        Integer newFlooPowder = (Integer)usedStack.getOrDefault((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER(), (Object)0);
        float pitch = Mth.lerp((float)(1.0f - (float)(newFlooPowder / 128)), (float)0.7f, (float)1.5f);
        level.playSound(null, player.blockPosition(), SoundEvents.BUNDLE_DROP_CONTENTS, player.getSoundSource(), 0.75f, pitch);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)usedStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    public int getBarColor(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return 65280;
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Integer n = (Integer)stack.get((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER());
        int currentFlooPowder = n != null ? n : 0;
        return (int)(13.0f * (float)currentFlooPowder / (float)128);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        Integer currentFlooPowder = (Integer)stack.getOrDefault((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER(), (Object)0);
        Object[] objectArray = new Object[]{currentFlooPowder, 128};
        tooltipComponents.add((Component)ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.floo_pouch.amount", objectArray));
        Companion.fuckJkr(tooltipComponents);
    }

    private static final Item.Properties DEFAULT_PROPERTIES$lambda$0() {
        return new Item.Properties().stacksTo(1).component((Supplier)ModDataComponents.INSTANCE.getFLOO_POWDER(), (Object)0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/FlooPouchItem$Companion;", "", "<init>", "()V", "MAX_FLOO_POWDER", "", "DEFAULT_PROPERTIES", "Lkotlin/Function0;", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lkotlin/jvm/functions/Function0;", "fuckJkr", "", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function0<Item.Properties> getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public final void fuckJkr(@NotNull List<Component> tooltipComponents) {
            Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
            LocalDate now = LocalDate.now();
            if (now.getMonth() == Month.JULY && now.getDayOfMonth() == 31) {
                tooltipComponents.add((Component)ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.trans_rights", new Object[0]));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

