/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.block.FlooBrickBlock;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.FlooBrickBlockEntity;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBlockTagsProvider;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooNetworkSavedData;
import dev.aaronhowser.mods.irregular_implements.item.FlooPouchItem;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/FlooSignItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
public final class FlooSignItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public FlooSignItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player player2 = player;
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (!clickedState.is(ModBlockTagsProvider.Companion.getCONVERTS_TO_FLOO_BRICK())) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = context.getItemInHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        Intrinsics.checkNotNull((Object)clickedPos);
        if (FlooSignItem.Companion.createFlooBricks(itemStack, player2, clickedPos)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        FlooPouchItem.Companion.fuckJkr(tooltipComponents);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/FlooSignItem$Companion;", "", "<init>", "()V", "createFlooBricks", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "clickedPos", "Lnet/minecraft/core/BlockPos;", "findConvertibleBlocks", "", "level", "Lnet/minecraft/world/level/Level;", "startPos", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean createFlooBricks(ItemStack stack, Player player, BlockPos clickedPos) {
            Level level = player.level();
            ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
            if (serverLevel == null) {
                return false;
            }
            ServerLevel level2 = serverLevel;
            Component component = (Component)stack.get(DataComponents.CUSTOM_NAME);
            String name = component != null ? component.getString() : null;
            Direction facing = player.getDirection();
            List blocksToConvert = CollectionsKt.toList((Iterable)this.findConvertibleBlocks((Level)level2, clickedPos));
            if (blocksToConvert.isEmpty()) {
                return false;
            }
            UUID masterUuid = UUID.randomUUID();
            FlooNetworkSavedData flooNetworkSavedData = FlooNetworkSavedData.Companion.get(level2);
            Intrinsics.checkNotNull((Object)masterUuid);
            boolean canCreate = flooNetworkSavedData.createFireplace(masterUuid, name, clickedPos, blocksToConvert);
            if (!canCreate) {
                return false;
            }
            for (BlockPos pos : blocksToConvert) {
                FlooBrickBlockEntity blockEntity;
                level2.setBlockAndUpdate(pos, ((FlooBrickBlock)((Object)ModBlocks.INSTANCE.getFLOO_BRICK().get())).defaultBlockState());
                BlockEntity blockEntity2 = level2.getBlockEntity(pos);
                if ((blockEntity2 instanceof FlooBrickBlockEntity ? (FlooBrickBlockEntity)blockEntity2 : null) == null) continue;
                blockEntity = blockEntity;
                if (Intrinsics.areEqual((Object)pos, (Object)clickedPos)) {
                    Direction direction = facing.getOpposite();
                    Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getOpposite(...)");
                    blockEntity.setupMaster(masterUuid, direction, CollectionsKt.minus((Iterable)blocksToConvert, (Object)clickedPos));
                    continue;
                }
                blockEntity.setupChild(masterUuid);
            }
            stack.consume(1, (LivingEntity)player);
            return true;
        }

        private final Set<BlockPos> findConvertibleBlocks(Level level, BlockPos startPos) {
            Object[] objectArray = new BlockPos[]{startPos};
            List toCheck = CollectionsKt.mutableListOf((Object[])objectArray);
            Set checked = new LinkedHashSet();
            Set found = new LinkedHashSet();
            while (!((Collection)toCheck).isEmpty() && found.size() < 256) {
                Object e = toCheck.removeFirst();
                Intrinsics.checkNotNullExpressionValue(e, (String)"removeFirst(...)");
                BlockPos checkedPos = (BlockPos)e;
                checked.add(checkedPos);
                BlockState state = level.getBlockState(checkedPos);
                if (!state.is(ModBlockTagsProvider.Companion.getCONVERTS_TO_FLOO_BRICK())) continue;
                found.add(checkedPos);
                for (Direction dir : EntriesMappings.entries$0) {
                    BlockPos offsetPos;
                    if (dir.getAxis().isVertical() || checked.contains(offsetPos = checkedPos.relative(dir)) || toCheck.contains(offsetPos)) continue;
                    Intrinsics.checkNotNull((Object)offsetPos);
                    toCheck.add(offsetPos);
                }
            }
            return found;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<Direction> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
            }
        }
    }
}

