/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModEntityTypeTagsProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/SummoningPendulumItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "interactLivingEntity", "Lnet/minecraft/world/InteractionResult;", "stackIgnoreIgnoreIgnore", "Lnet/minecraft/world/item/ItemStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "interactionTarget", "Lnet/minecraft/world/entity/LivingEntity;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "useOn", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
public final class SummoningPendulumItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public SummoningPendulumItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stackIgnoreIgnoreIgnore, @NotNull Player player, @NotNull LivingEntity interactionTarget, @NotNull InteractionHand usedHand) {
        List entityList;
        Intrinsics.checkNotNullParameter((Object)stackIgnoreIgnoreIgnore, (String)"stackIgnoreIgnoreIgnore");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)interactionTarget, (String)"interactionTarget");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        if (player.level().isClientSide || interactionTarget.getType().is(ModEntityTypeTagsProvider.Companion.getSUMMONING_PENDULUM_BLACKLIST())) {
            return InteractionResult.PASS;
        }
        ItemStack usedStack = player.getItemInHand(usedHand);
        List list = (List)usedStack.get((Supplier)ModDataComponents.INSTANCE.getENTITY_LIST());
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            list = new ArrayList();
        }
        if ((entityList = list).size() >= ((Number)ServerConfig.Companion.getCONFIG().getSummoningPendulumCapacity().get()).intValue()) {
            return InteractionResult.FAIL;
        }
        CompoundTag entityNbt = new CompoundTag();
        if (!interactionTarget.save(entityNbt)) {
            return InteractionResult.FAIL;
        }
        CustomData customData = CustomData.of((CompoundTag)entityNbt);
        Intrinsics.checkNotNull((Object)customData);
        entityList.add(customData);
        usedStack.set((Supplier)ModDataComponents.INSTANCE.getENTITY_LIST(), (Object)entityList);
        interactionTarget.remove(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        BlockPos blockPos;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ItemStack stack = context.getItemInHand();
        List list = (List)stack.get((Supplier)ModDataComponents.INSTANCE.getENTITY_LIST());
        if (list == null) {
            return InteractionResult.PASS;
        }
        List component = list;
        CustomData customData = (CustomData)CollectionsKt.lastOrNull((List)component);
        if (customData == null) {
            return InteractionResult.PASS;
        }
        CustomData entityData = customData;
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction clickedFace = context.getClickedFace();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (clickedState.isSuffocating((BlockGetter)level, clickedPos)) {
            BlockPos relative = clickedPos.relative(clickedFace);
            if (level.getBlockState(relative).isSuffocating((BlockGetter)level, relative)) {
                return InteractionResult.FAIL;
            }
            blockPos = relative;
        } else {
            blockPos = clickedPos;
        }
        BlockPos posToSpawn = blockPos;
        String entityTypeString = entityData.copyTag().getString("id");
        EntityType entityType = (EntityType)level.registryAccess().registryOrThrow(Registries.ENTITY_TYPE).get(ResourceLocation.parse((String)entityTypeString));
        if (entityType == null) {
            return InteractionResult.FAIL;
        }
        EntityType entityType2 = entityType;
        Entity entity = entityType2.create(level);
        if (entity == null) {
            return InteractionResult.FAIL;
        }
        Entity entity2 = entity;
        List newEntityList = CollectionsKt.dropLast((List)component, (int)1);
        if (stack.set((Supplier)ModDataComponents.INSTANCE.getENTITY_LIST(), (Object)newEntityList) == null) {
            return InteractionResult.FAIL;
        }
        entityData.loadInto(entity2);
        entity2.moveTo(posToSpawn.getBottomCenter());
        level.addFreshEntity(entity2);
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        List list = (List)stack.get((Supplier)ModDataComponents.INSTANCE.getENTITY_LIST());
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List customDataList = list;
        int amount = customDataList.size();
        Integer capacity = (Integer)ServerConfig.Companion.getCONFIG().getSummoningPendulumCapacity().get();
        Object[] objectArray = new Object[]{amount, capacity};
        tooltipComponents.add((Component)ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.summoning_pendulum_fraction", objectArray));
        if (tooltipFlag.hasShiftDown()) {
            for (CustomData customData : customDataList) {
                Component component;
                CompoundTag entityNbt = customData.copyTag();
                if (entityNbt.contains("CustomName")) {
                    String customName = entityNbt.getString("CustomName");
                    component = (Component)Component.literal((String)customName);
                } else {
                    EntityType entityType;
                    Registry registry;
                    RegistryAccess registryAccess;
                    String entityTypeString = entityNbt.getString("id");
                    Level level = context.level();
                    if (level == null || (registryAccess = level.registryAccess()) == null || (registry = registryAccess.registryOrThrow(Registries.ENTITY_TYPE)) == null || (entityType = (EntityType)registry.get(ResourceLocation.parse((String)entityTypeString))) == null) continue;
                    EntityType entityType2 = entityType;
                    component = entityType2.getDescription();
                }
                Component entityName = component;
                Object[] objectArray2 = new Object[]{entityName};
                tooltipComponents.add((Component)ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.summoning_pendulum_list_each", objectArray2));
            }
        }
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/SummoningPendulumItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

