/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.packet;

import dev.aaronhowser.mods.irregular_implements.packet.ModPacket;
import dev.aaronhowser.mods.irregular_implements.packet.client_to_server.ClientChangedMenuString;
import dev.aaronhowser.mods.irregular_implements.packet.client_to_server.ClientClickedMenuButton;
import dev.aaronhowser.mods.irregular_implements.packet.client_to_server.PaintBiomePacket;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.AddIndicatorsPacket;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.BurningFlooFireplacePacket;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.FlooTokenActivatedPacket;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.RemoveIndicatorsPacket;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.SendClientToast;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.UpdateClientScreenString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ>\u0010\u0017\u001a\u00020\u0005\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001d2\u0014\u0010\u001e\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020 \u0012\u0004\u0012\u0002H\u00180\u001fH\u0002J>\u0010!\u001a\u00020\u0005\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001d2\u0014\u0010\u001e\u001a\u0010\u0012\u0006\b\u0000\u0012\u00020 \u0012\u0004\u0012\u0002H\u00180\u001fH\u0002\u00a8\u0006\""}, d2={"Ldev/aaronhowser/mods/irregular_implements/packet/ModPacketHandler;", "", "<init>", "()V", "registerPayloads", "", "event", "Lnet/neoforged/neoforge/network/event/RegisterPayloadHandlersEvent;", "messageNearbyPlayers", "packet", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "origin", "Lnet/minecraft/core/BlockPos;", "radius", "", "Lnet/minecraft/world/phys/Vec3;", "messagePlayer", "player", "Lnet/minecraft/server/level/ServerPlayer;", "messageAllPlayers", "messageServer", "toClient", "T", "Ldev/aaronhowser/mods/irregular_implements/packet/ModPacket;", "registrar", "Lnet/neoforged/neoforge/network/registration/PayloadRegistrar;", "packetType", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "toServer", "irregular-implements-1.21.1"})
public final class ModPacketHandler {
    @NotNull
    public static final ModPacketHandler INSTANCE = new ModPacketHandler();

    private ModPacketHandler() {
    }

    public final void registerPayloads(@NotNull RegisterPayloadHandlersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PayloadRegistrar registrar = event.registrar("1");
        Intrinsics.checkNotNull((Object)registrar);
        this.toServer(registrar, ClientChangedMenuString.Companion.getTYPE(), ClientChangedMenuString.Companion.getSTREAM_CODEC());
        this.toClient(registrar, UpdateClientScreenString.Companion.getTYPE(), UpdateClientScreenString.Companion.getSTREAM_CODEC());
        this.toServer(registrar, ClientClickedMenuButton.Companion.getTYPE(), ClientClickedMenuButton.Companion.getSTREAM_CODEC());
        this.toClient(registrar, SendClientToast.Companion.getTYPE(), SendClientToast.Companion.getSTREAM_CODEC());
        this.toClient(registrar, BurningFlooFireplacePacket.Companion.getTYPE(), BurningFlooFireplacePacket.Companion.getSTREAM_CODEC());
        this.toClient(registrar, FlooTokenActivatedPacket.Companion.getTYPE(), FlooTokenActivatedPacket.Companion.getSTREAM_CODEC());
        this.toClient(registrar, AddIndicatorsPacket.Companion.getTYPE(), AddIndicatorsPacket.Companion.getSTREAM_CODEC());
        this.toClient(registrar, RemoveIndicatorsPacket.Companion.getTYPE(), RemoveIndicatorsPacket.Companion.getSTREAM_CODEC());
        this.toServer(registrar, PaintBiomePacket.Companion.getTYPE(), PaintBiomePacket.Companion.getSTREAM_CODEC());
    }

    public final void messageNearbyPlayers(@NotNull CustomPacketPayload packet, @NotNull ServerLevel serverLevel, @NotNull BlockPos origin, double radius) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Vec3 vec3 = origin.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        this.messageNearbyPlayers(packet, serverLevel, vec3, radius);
    }

    public final void messageNearbyPlayers(@NotNull CustomPacketPayload packet, @NotNull ServerLevel serverLevel, @NotNull Vec3 origin, double radius) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        for (ServerPlayer player : serverLevel.players()) {
            if (!player.position().closerThan((Position)origin, radius)) continue;
            Intrinsics.checkNotNull((Object)player);
            this.messagePlayer(player, packet);
        }
    }

    public final void messagePlayer(@NotNull ServerPlayer player, @NotNull CustomPacketPayload packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void messageAllPlayers(@NotNull CustomPacketPayload packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void messageServer(@NotNull CustomPacketPayload packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private final <T extends ModPacket> void toClient(PayloadRegistrar registrar, CustomPacketPayload.Type<T> packetType, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        registrar.playToClient(packetType, streamCodec, ModPacketHandler::toClient$lambda$0);
    }

    private final <T extends ModPacket> void toServer(PayloadRegistrar registrar, CustomPacketPayload.Type<T> packetType, StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec) {
        registrar.playToServer(packetType, streamCodec, ModPacketHandler::toServer$lambda$1);
    }

    private static final void toClient$lambda$0(ModPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveOnClient(context);
    }

    private static final void toServer$lambda$1(ModPacket packet, IPayloadContext context) {
        Intrinsics.checkNotNull((Object)context);
        packet.receiveOnServer(context);
    }
}

