/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.util;

import com.google.common.collect.HashMultimap;
import dev.aaronhowser.mods.irregular_implements.IrregularImplements;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0007H\u0002R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/aaronhowser/mods/irregular_implements/util/ServerScheduler;", "", "<init>", "()V", "tick", "", "value", "", "currentTick", "setCurrentTick", "(I)V", "upcomingTasks", "Lcom/google/common/collect/HashMultimap;", "Ljava/lang/Runnable;", "scheduleTaskInTicks", "ticksInFuture", "runnable", "handleScheduledTasks", "irregular-implements-1.21.1"})
public final class ServerScheduler {
    @NotNull
    public static final ServerScheduler INSTANCE = new ServerScheduler();
    private static int currentTick;
    @NotNull
    private static final HashMultimap<Integer, Runnable> upcomingTasks;

    private ServerScheduler() {
    }

    public final void tick() {
        int n = currentTick;
        this.setCurrentTick(n + 1);
    }

    private final void setCurrentTick(int value) {
        currentTick = value;
        this.handleScheduledTasks(value);
    }

    public final void scheduleTaskInTicks(int ticksInFuture, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (ticksInFuture > 0) {
            upcomingTasks.put((Object)(currentTick + ticksInFuture), (Object)runnable);
        } else {
            runnable.run();
        }
    }

    private final void handleScheduledTasks(int tick) {
        if (!upcomingTasks.containsKey((Object)tick)) {
            return;
        }
        Iterator tasks = upcomingTasks.get((Object)tick).iterator();
        while (tasks.hasNext()) {
            try {
                ((Runnable)tasks.next()).run();
            }
            catch (Exception e) {
                IrregularImplements.LOGGER.error(e.toString());
            }
            tasks.remove();
        }
    }

    static {
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create(...)");
        upcomingTasks = hashMultimap;
    }
}

