/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.NoCodecBushBlock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/GlowingMushroomBlock;", "Ldev/aaronhowser/mods/irregular_implements/block/NoCodecBushBlock;", "<init>", "()V", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "mayPlaceOn", "", "canSurvive", "Lnet/minecraft/world/level/LevelReader;", "randomTick", "", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "Companion", "irregular-implements-1.21.1"})
public final class GlowingMushroomBlock
extends NoCodecBushBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape SHAPE;

    public GlowingMushroomBlock() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.RED_MUSHROOM));
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"ofFullCopy(...)");
        super(properties);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return state.isSolidRender(level, pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos belowPos = pos.below();
        BlockState stateBelow = level.getBlockState(belowPos);
        TriState soilDecision = stateBelow.canSustainPlant((BlockGetter)level, belowPos, Direction.UP, state);
        if (stateBelow.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
            return true;
        }
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        if (level.getRawBrightness(pos, 0) >= 13) return false;
        Intrinsics.checkNotNull((Object)stateBelow);
        BlockGetter blockGetter = (BlockGetter)level;
        Intrinsics.checkNotNull((Object)belowPos);
        if (!this.mayPlaceOn(stateBelow, blockGetter, belowPos)) return false;
        return true;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (random.nextInt(25) != 0) {
            return;
        }
        int mushroomsNearby = 0;
        BlockPos currentPos = pos;
        Iterable area = BlockPos.betweenClosed((BlockPos)currentPos.offset(-4, -1, -4), (BlockPos)currentPos.offset(4, 1, 4));
        for (BlockPos checkPos : area) {
            if (!level.getBlockState(checkPos).is((Block)this) || ++mushroomsNearby < 5) continue;
            return;
        }
        BlockPos candidatePos = currentPos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
        for (int attempt = 0; attempt < 4; ++attempt) {
            if (level.isEmptyBlock(candidatePos) && state.canSurvive((LevelReader)level, candidatePos)) {
                BlockPos blockPos = candidatePos;
                Intrinsics.checkNotNull((Object)blockPos);
                currentPos = blockPos;
            }
            candidatePos = currentPos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
        }
        if (level.isEmptyBlock(candidatePos) && state.canSurvive((LevelReader)level, candidatePos)) {
            level.setBlock(candidatePos, state, 2);
        }
    }

    static {
        VoxelShape voxelShape = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/GlowingMushroomBlock$Companion;", "", "<init>", "()V", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VoxelShape getSHAPE() {
            return SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

