/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.OnlineDetectorBlockEntity;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bH\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J:\u0010\u0012\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u0013\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018H\u0016J0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J*\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\tH\u0014J(\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0014J(\u0010'\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0014\u00a8\u0006)"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/OnlineDetectorBlock;", "Lnet/minecraft/world/level/block/EntityBlock;", "Lnet/minecraft/world/level/block/Block;", "<init>", "()V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "level", "Lnet/minecraft/world/level/Level;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "canConnectRedstone", "", "Lnet/minecraft/world/level/BlockGetter;", "direction", "Lnet/minecraft/core/Direction;", "isSignalSource", "getDirectSignal", "", "getSignal", "Companion", "irregular-implements-1.21.1"})
public final class OnlineDetectorBlock
extends Block
implements EntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BooleanProperty ENABLED;
    @NotNull
    private static final DirectionProperty HORIZONTAL_FACING;

    public OnlineDetectorBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.DISPENSER)));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{ENABLED, HORIZONTAL_FACING};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection());
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new OnlineDetectorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        BlockEntityTicker blockEntityTicker;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        if (level.isClientSide) {
            blockEntityTicker = null;
        } else {
            OnlineDetectorBlockEntity.Companion companion = OnlineDetectorBlockEntity.Companion;
            blockEntityTicker = BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.INSTANCE.getONLINE_DETECTOR().get()), (BlockEntityTicker)new BlockEntityTicker(companion){
                final /* synthetic */ OnlineDetectorBlockEntity.Companion $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void tick(Level p0, BlockPos p1, BlockState p2, OnlineDetectorBlockEntity p3) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                    this.$tmp0.tick(p0, p1, p2, p3);
                }
            });
        }
        return blockEntityTicker;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (OtherUtil.INSTANCE.isServerSide(level)) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            OnlineDetectorBlockEntity onlineDetectorBlockEntity = blockEntity instanceof OnlineDetectorBlockEntity ? (OnlineDetectorBlockEntity)blockEntity : null;
            if (onlineDetectorBlockEntity == null) {
                return InteractionResult.FAIL;
            }
            OnlineDetectorBlockEntity blockEntity2 = onlineDetectorBlockEntity;
            player.openMenu((MenuProvider)blockEntity2);
            blockEntity2.sendStringUpdate();
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canConnectRedstone(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    protected boolean isSignalSource(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    protected int getDirectSignal(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return (Boolean)state.getValue((Property)ENABLED) != false ? 15 : 0;
    }

    protected int getSignal(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.getDirectSignal(state, level, pos, direction);
    }

    static {
        BooleanProperty booleanProperty = BlockStateProperties.ENABLED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"ENABLED");
        ENABLED = booleanProperty;
        DirectionProperty directionProperty = BlockStateProperties.HORIZONTAL_FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"HORIZONTAL_FACING");
        HORIZONTAL_FACING = directionProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/OnlineDetectorBlock$Companion;", "", "<init>", "()V", "ENABLED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getENABLED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "HORIZONTAL_FACING", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getHORIZONTAL_FACING", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getENABLED() {
            return ENABLED;
        }

        @NotNull
        public final DirectionProperty getHORIZONTAL_FACING() {
            return HORIZONTAL_FACING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

