/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.PlayerInterfaceBlockEntity;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0013"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/PlayerInterfaceBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "<init>", "()V", "setPlacedBy", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "placer", "Lnet/minecraft/world/entity/LivingEntity;", "stack", "Lnet/minecraft/world/item/ItemStack;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "irregular-implements-1.21.1"})
public final class PlayerInterfaceBlock
extends Block
implements EntityBlock {
    public PlayerInterfaceBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.DISPENSER)));
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PlayerInterfaceBlockEntity && placer != null) {
            PlayerInterfaceBlockEntity playerInterfaceBlockEntity = (PlayerInterfaceBlockEntity)blockEntity;
            UUID uUID = placer.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            playerInterfaceBlockEntity.setOwnerUuid(uUID);
            if (placer instanceof Player) {
                ItemStack playerHead = Items.PLAYER_HEAD.getDefaultInstance();
                playerHead.set(DataComponents.PROFILE, (Object)new ResolvableProfile(((Player)placer).getGameProfile()));
                PlayerInterfaceBlockEntity playerInterfaceBlockEntity2 = (PlayerInterfaceBlockEntity)blockEntity;
                Intrinsics.checkNotNull((Object)playerHead);
                playerInterfaceBlockEntity2.setOwnerHead(playerHead);
            }
        }
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new PlayerInterfaceBlockEntity(pos, state);
    }
}

