/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.RedstoneInterfaceAdvancedBlockEntity;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.RedstoneInterfaceBasicBlockEntity;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.base.RedstoneInterfaceBlockEntity;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J:\u0010\u001b\u001a\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010\u001c\"\n\b\u0000\u0010\u001d*\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0007\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/RedstoneInterfaceBlock;", "Lnet/minecraft/world/level/block/EntityBlock;", "Lnet/minecraft/world/level/block/Block;", "isAdvanced", "", "<init>", "(Z)V", "()Z", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "neighborChanged", "", "level", "Lnet/minecraft/world/level/Level;", "neighborBlock", "neighborPos", "movedByPiston", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "irregular-implements-1.21.1"})
public final class RedstoneInterfaceBlock
extends Block
implements EntityBlock {
    private final boolean isAdvanced;

    public RedstoneInterfaceBlock(boolean isAdvanced) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.IRON_BLOCK)));
        this.isAdvanced = isAdvanced;
    }

    public final boolean isAdvanced() {
        return this.isAdvanced;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.isAdvanced ? (BlockEntity)new RedstoneInterfaceAdvancedBlockEntity(pos, state) : (BlockEntity)new RedstoneInterfaceBasicBlockEntity(pos, state);
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborBlock, (String)"neighborBlock");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RedstoneInterfaceBlockEntity) {
            ((RedstoneInterfaceBlockEntity)blockEntity).updateTargets();
        }
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MenuProvider) {
            player.openMenu((MenuProvider)blockEntity);
            InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level.isClientSide);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
            return interactionResult;
        }
        InteractionResult interactionResult = super.useWithoutItem(state, level, pos, player, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        BlockEntityType type = this.isAdvanced ? (BlockEntityType)ModBlockEntityTypes.INSTANCE.getADVANCED_REDSTONE_INTERFACE().get() : (BlockEntityType)ModBlockEntityTypes.INSTANCE.getBASIC_REDSTONE_INTERFACE().get();
        RedstoneInterfaceBlockEntity.Companion companion = RedstoneInterfaceBlockEntity.Companion;
        return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)type, (BlockEntityTicker)new BlockEntityTicker(companion){
            final /* synthetic */ RedstoneInterfaceBlockEntity.Companion $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void tick(Level p0, BlockPos p1, BlockState p2, RedstoneInterfaceBlockEntity p3) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                this.$tmp0.tick(p0, p1, p2, p3);
            }
        });
    }
}

