/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import dev.aaronhowser.mods.irregular_implements.block.SpectreCoilBlock;
import dev.aaronhowser.mods.irregular_implements.handler.SpectreCoilSavedData;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010!J\b\u0010\"\u001a\u00020\u0017H\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u001bH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016R\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/SpectreCoilBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "pos", "blockState", "coilType", "Ldev/aaronhowser/mods/irregular_implements/block/SpectreCoilBlock$Type;", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Ldev/aaronhowser/mods/irregular_implements/block/SpectreCoilBlock$Type;)V", "value", "setCoilType", "(Ldev/aaronhowser/mods/irregular_implements/block/SpectreCoilBlock$Type;)V", "Ljava/util/UUID;", "ownerUuid", "getOwnerUuid", "()Ljava/util/UUID;", "setOwnerUuid", "(Ljava/util/UUID;)V", "saveAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "cachedEnergyHandler", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "getEnergyHandler", "direction", "Lnet/minecraft/core/Direction;", "tick", "getUpdateTag", "pRegistries", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "Companion", "irregular-implements-1.21.1"})
public final class SpectreCoilBlockEntity
extends BlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SpectreCoilBlock.Type coilType;
    @NotNull
    private UUID ownerUuid;
    @Nullable
    private IEnergyStorage cachedEnergyHandler;
    @NotNull
    public static final String OWNER_UUID_NBT = "OwnerUuid";
    @NotNull
    public static final String COIL_TYPE_NBT = "CoilType";

    public SpectreCoilBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntityTypes.INSTANCE.getSPECTRE_COIL().get(), pPos, pBlockState);
        this.coilType = SpectreCoilBlock.Type.BASIC;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.ownerUuid = uUID;
    }

    public SpectreCoilBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull SpectreCoilBlock.Type coilType) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)((Object)coilType), (String)"coilType");
        this(pos, blockState);
        this.setCoilType(coilType);
    }

    private final void setCoilType(SpectreCoilBlock.Type value) {
        this.coilType = value;
        this.setChanged();
    }

    @NotNull
    public final UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public final void setOwnerUuid(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.ownerUuid = value;
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putUUID(OWNER_UUID_NBT, this.ownerUuid);
        tag.putInt(COIL_TYPE_NBT, this.coilType.ordinal());
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        UUID uuid = OtherUtil.INSTANCE.getUuidOrNull(tag, OWNER_UUID_NBT);
        if (uuid != null) {
            this.setOwnerUuid(uuid);
        }
        int coilTypeOrdinal = tag.getInt(COIL_TYPE_NBT);
        SpectreCoilBlock.Type coilType = (SpectreCoilBlock.Type)((Object)CollectionsKt.getOrNull((List)((List)SpectreCoilBlock.Type.getEntries()), (int)coilTypeOrdinal));
        if (coilType != null) {
            this.setCoilType(coilType);
        }
    }

    @Nullable
    public final IEnergyStorage getEnergyHandler(@Nullable Direction direction) {
        if (direction != this.getBlockState().getValue((Property)SpectreCoilBlock.Companion.getFACING())) {
            return null;
        }
        if (this.cachedEnergyHandler != null) {
            return this.cachedEnergyHandler;
        }
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return null;
        }
        ServerLevel level2 = serverLevel;
        IEnergyStorage coil = SpectreCoilSavedData.Companion.get(level2).getCoil(this.ownerUuid);
        this.cachedEnergyHandler = new IEnergyStorage(coil){
            final /* synthetic */ IEnergyStorage $coil;
            {
                this.$coil = $coil;
            }

            public int receiveEnergy(int toReceive, boolean simulate) {
                return 0;
            }

            public int extractEnergy(int toExtract, boolean simulate) {
                return 0;
            }

            public int getEnergyStored() {
                return this.$coil.getEnergyStored();
            }

            public int getMaxEnergyStored() {
                return this.$coil.getMaxEnergyStored();
            }

            public boolean canExtract() {
                return false;
            }

            public boolean canReceive() {
                return false;
            }
        };
        return this.cachedEnergyHandler;
    }

    private final void tick() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        Direction facing = (Direction)this.getBlockState().getValue((Property)SpectreCoilBlock.Companion.getFACING());
        BlockPos onBlockPos = this.getBlockPos().relative(facing);
        IEnergyStorage energyHandler = (IEnergyStorage)level2.getCapability(Capabilities.EnergyStorage.BLOCK, onBlockPos, (Object)facing.getOpposite());
        if (energyHandler == null || !energyHandler.canReceive()) {
            return;
        }
        Integer n = this.coilType.getAmountGetter().get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        int rate = ((Number)n).intValue();
        if (this.coilType.isGenerator()) {
            energyHandler.receiveEnergy(rate, false);
            return;
        }
        IEnergyStorage coil = SpectreCoilSavedData.Companion.get(level2).getCoil(this.ownerUuid);
        int available = coil.extractEnergy(rate, true);
        if (available <= 0) {
            return;
        }
        int sent = energyHandler.receiveEnergy(available, false);
        if (sent <= 0) {
            return;
        }
        coil.extractEnergy(sent, false);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        CompoundTag compoundTag = this.saveWithoutMetadata(pRegistries);
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"saveWithoutMetadata(...)");
        return compoundTag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/SpectreCoilBlockEntity$Companion;", "", "<init>", "()V", "OWNER_UUID_NBT", "", "COIL_TYPE_NBT", "getEnergyCapability", "Lnet/neoforged/neoforge/energy/IEnergyStorage;", "blockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/SpectreCoilBlockEntity;", "direction", "Lnet/minecraft/core/Direction;", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final IEnergyStorage getEnergyCapability(@NotNull SpectreCoilBlockEntity blockEntity, @Nullable Direction direction) {
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            return blockEntity.getEnergyHandler(direction);
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull SpectreCoilBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            blockEntity.tick();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

