/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.DiaphanousBlockEntity;
import dev.aaronhowser.mods.irregular_implements.util.ClientUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/irregular_implements/client/render/block_entity/DiaphanousBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/DiaphanousBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "getContext", "()Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "getViewDistance", "", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "packedOverlay", "irregular-implements-1.21.1"})
public final class DiaphanousBlockEntityRenderer
implements BlockEntityRenderer<DiaphanousBlockEntity> {
    @NotNull
    private final BlockEntityRendererProvider.Context context;

    public DiaphanousBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final BlockEntityRendererProvider.Context getContext() {
        return this.context;
    }

    public int getViewDistance() {
        return 256;
    }

    public void render(@NotNull DiaphanousBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        Level level2 = level;
        Player player = ClientUtil.getLocalPlayer();
        if (player == null) {
            return;
        }
        Player player2 = player;
        double distance = player2.getPosition(partialTick).distanceToSqr(blockEntity.getBlockPos().getCenter());
        float clampedDistance = (float)RangesKt.coerceIn((double)(distance - (double)8), (double)0.0, (double)25.0);
        float cosValue = (float)Math.cos((float)Math.PI * clampedDistance / (float)25);
        float baseAlpha = -0.5f * (cosValue - 1.0f);
        float diaphBlockAlpha = blockEntity.isInverted() ? 1.0f - baseAlpha : baseAlpha;
        poseStack.pushPose();
        BlockState stateToRender = blockEntity.getRenderedBlockState();
        BakedModel model = this.context.getBlockRenderDispatcher().getBlockModel(stateToRender);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.translucent());
        BlockState myState = blockEntity.getBlockState();
        for (Direction direction : EntriesMappings.entries$0) {
            BlockPos posThere = blockEntity.getBlockPos().relative(direction);
            BlockEntity blockEntity2 = level2.getBlockEntity(posThere);
            DiaphanousBlockEntity blockEntityThere = blockEntity2 instanceof DiaphanousBlockEntity ? (DiaphanousBlockEntity)blockEntity2 : null;
            BlockState blockStateThere = level2.getBlockState(posThere);
            DiaphanousBlockEntity diaphanousBlockEntity = blockEntityThere;
            boolean shouldSkip = (diaphanousBlockEntity != null ? diaphanousBlockEntity.isInverted() == blockEntity.isInverted() : false) || blockStateThere.hidesNeighborFace((BlockGetter)level2, posThere, myState, direction.getOpposite());
            if (shouldSkip) continue;
            List quads = model.getQuads(stateToRender, direction, (RandomSource)new XoroshiroRandomSource(0L, 0L), ModelData.EMPTY, null);
            BlockColors blockColors = Minecraft.getInstance().getBlockColors();
            for (BakedQuad quad : quads) {
                int tintIndex = quad.getTintIndex();
                int color = tintIndex == -1 ? -1 : blockColors.getColor(stateToRender, (BlockAndTintGetter)level2, blockEntity.getBlockPos(), tintIndex);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                float colorAlpha = (float)(color >> 24 & 0xFF) / 255.0f;
                if (colorAlpha == 0.0f) {
                    colorAlpha = 1.0f;
                }
                vertexConsumer.putBulkData(poseStack.last(), quad, red, green, blue, diaphBlockAlpha * colorAlpha, packedLight, packedOverlay, true);
            }
        }
        poseStack.popPose();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

