/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.datagen.model;

import dev.aaronhowser.mods.irregular_implements.item.DiviningRodItem;
import dev.aaronhowser.mods.irregular_implements.item.EmeraldCompassItem;
import dev.aaronhowser.mods.irregular_implements.item.EnderBucketItem;
import dev.aaronhowser.mods.irregular_implements.item.GoldenCompassItem;
import dev.aaronhowser.mods.irregular_implements.item.GrassSeedItem;
import dev.aaronhowser.mods.irregular_implements.item.RedstoneActivatorItem;
import dev.aaronhowser.mods.irregular_implements.item.ReinforcedEnderBucketItem;
import dev.aaronhowser.mods.irregular_implements.item.SpectreChargerItem;
import dev.aaronhowser.mods.irregular_implements.item.WeatherEggItem;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlocks;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\fH\u0002J\b\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/irregular_implements/datagen/model/ModItemModelProvider;", "Lnet/neoforged/neoforge/client/model/generators/ItemModelProvider;", "output", "Lnet/minecraft/data/PackOutput;", "existingFileHelper", "Lnet/neoforged/neoforge/common/data/ExistingFileHelper;", "<init>", "(Lnet/minecraft/data/PackOutput;Lnet/neoforged/neoforge/common/data/ExistingFileHelper;)V", "handledItems", "", "Lnet/minecraft/world/item/Item;", "registerModels", "", "advancedRedstoneTorch", "specialChests", "weatherEggs", "spectreChargers", "blockEntityWithoutLevelRenderers", "diviningRod", "redstoneActivator", "emeraldCompass", "goldenCompass", "buckets", "basicItems", "handheldItems", "coloredItems", "getName", "Lnet/minecraft/resources/ResourceLocation;", "item", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nModItemModelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModItemModelProvider.kt\ndev/aaronhowser/mods/irregular_implements/datagen/model/ModItemModelProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n1563#2:348\n1634#2,3:349\n1563#2:352\n1634#2,3:353\n*S KotlinDebug\n*F\n+ 1 ModItemModelProvider.kt\ndev/aaronhowser/mods/irregular_implements/datagen/model/ModItemModelProvider\n*L\n295#1:348\n295#1:349,3\n314#1:352\n314#1:353,3\n*E\n"})
public final class ModItemModelProvider
extends ItemModelProvider {
    @NotNull
    private final Set<Item> handledItems;

    public ModItemModelProvider(@NotNull PackOutput output, @NotNull ExistingFileHelper existingFileHelper) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)existingFileHelper, (String)"existingFileHelper");
        super(output, "irregular_implements", existingFileHelper);
        this.handledItems = new LinkedHashSet();
    }

    protected void registerModels() {
        this.coloredItems();
        this.handheldItems();
        this.emeraldCompass();
        this.goldenCompass();
        this.redstoneActivator();
        this.diviningRod();
        this.buckets();
        this.blockEntityWithoutLevelRenderers();
        this.spectreChargers();
        this.weatherEggs();
        this.specialChests();
        this.advancedRedstoneTorch();
        this.basicItems();
    }

    private final void advancedRedstoneTorch() {
        StandingAndWallBlockItem item = (StandingAndWallBlockItem)ModItems.INSTANCE.getADVANCED_REDSTONE_TORCH().get();
        ResourceLocation texture = this.modLoc("block/advanced_redstone_torch/red");
        Intrinsics.checkNotNull((Object)item);
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName((Item)item).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
        this.handledItems.add((Item)item);
    }

    private final void specialChests() {
        Item[] itemArray = new Item[]{ModBlocks.INSTANCE.getWATER_CHEST().asItem(), ModBlocks.INSTANCE.getNATURE_CHEST().asItem()};
        List blockItems = CollectionsKt.listOf((Object[])itemArray);
        for (Item item : blockItems) {
            Intrinsics.checkNotNull((Object)item);
            ((ItemModelBuilder)this.getBuilder(this.getName(item).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/chest"));
            this.handledItems.add(item);
        }
    }

    private final void weatherEggs() {
        WeatherEggItem item = (WeatherEggItem)((Object)ModItems.INSTANCE.getWEATHER_EGG().get());
        Intrinsics.checkNotNull((Object)((Object)item));
        ItemModelBuilder sunnyModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item) + "_sunny")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "item/weather_egg/sunny");
        ItemModelBuilder rainyModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item) + "_rainy")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "item/weather_egg/rainy");
        ItemModelBuilder stormyModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item) + "_stormy")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "item/weather_egg/stormy");
        ((ItemModelBuilder)this.getBuilder(this.getName(item).toString())).override().predicate(WeatherEggItem.Companion.getWEATHER(), 0.0f).model((ModelFile)sunnyModel).end().override().predicate(WeatherEggItem.Companion.getWEATHER(), 1.0f).model((ModelFile)rainyModel).end().override().predicate(WeatherEggItem.Companion.getWEATHER(), 2.0f).model((ModelFile)stormyModel).end();
        this.handledItems.add(item);
    }

    private final void spectreChargers() {
        ResourceLocation glowTexture = this.modLoc("item/spectre_charger/glow");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ModItems.INSTANCE.getSPECTRE_CHARGER_BASIC().get(), (Object)"basic"), TuplesKt.to((Object)ModItems.INSTANCE.getSPECTRE_CHARGER_REDSTONE().get(), (Object)"redstone"), TuplesKt.to((Object)ModItems.INSTANCE.getSPECTRE_CHARGER_ENDER().get(), (Object)"ender"), TuplesKt.to((Object)ModItems.INSTANCE.getSPECTRE_CHARGER_GENESIS().get(), (Object)"genesis")};
        Map items = MapsKt.mapOf((Pair[])pairArray);
        for (Map.Entry entry2 : items.entrySet()) {
            SpectreChargerItem item = (SpectreChargerItem)((Object)entry2.getKey());
            String type = (String)entry2.getValue();
            Intrinsics.checkNotNull((Object)((Object)item));
            ResourceLocation name = this.getName(item);
            ResourceLocation baseTexture = this.modLoc("item/spectre_charger/" + type);
            ItemModelBuilder glowModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name + "_glow")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", baseTexture)).texture("layer1", glowTexture);
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", baseTexture)).override().predicate(SpectreChargerItem.Companion.getIS_ENABLED(), 1.0f).model((ModelFile)glowModel).end();
            this.handledItems.add(item);
        }
    }

    private final void blockEntityWithoutLevelRenderers() {
        Item[] itemArray = new Item[]{ModItems.INSTANCE.getDIAPHANOUS_BLOCK().get(), ModItems.INSTANCE.getSPECTRE_ILLUMINATOR().get(), ModItems.INSTANCE.getCUSTOM_CRAFTING_TABLE().get()};
        List blockEntityWithoutLevelRenderers = CollectionsKt.listOf((Object[])itemArray);
        for (Item item : blockEntityWithoutLevelRenderers) {
            Intrinsics.checkNotNull((Object)item);
            ResourceLocation name = this.getName(item);
            ((ItemModelBuilder)this.getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"));
            this.handledItems.add(item);
        }
    }

    private final void diviningRod() {
        DiviningRodItem item = (DiviningRodItem)((Object)ModItems.INSTANCE.getDIVINING_ROD().get());
        Intrinsics.checkNotNull((Object)((Object)item));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", "item/divining_rod")).texture("layer1", "item/divining_rod_overlay");
        this.handledItems.add(item);
    }

    private final void redstoneActivator() {
        RedstoneActivatorItem item = (RedstoneActivatorItem)((Object)ModItems.INSTANCE.getREDSTONE_ACTIVATOR().get());
        Intrinsics.checkNotNull((Object)((Object)item));
        ItemModelBuilder middleModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item) + "_middle")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", "item/redstone_activator/middle");
        ItemModelBuilder rightModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item) + "_right")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", "item/redstone_activator/right");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", "item/redstone_activator/left")).override().predicate(RedstoneActivatorItem.Companion.getDURATION(), 20.0f).model((ModelFile)middleModel).end().override().predicate(RedstoneActivatorItem.Companion.getDURATION(), 100.0f).model((ModelFile)rightModel).end();
        this.handledItems.add(item);
    }

    private final void emeraldCompass() {
        EmeraldCompassItem item = (EmeraldCompassItem)((Object)ModItems.INSTANCE.getEMERALD_COMPASS().get());
        Intrinsics.checkNotNull((Object)((Object)item));
        ItemModelBuilder baseModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", "item/emerald_compass/emerald_compass_00");
        for (int i = 0; i < 31; ++i) {
            int wrapped = (i + 16) % 32;
            String number = StringsKt.padStart((String)String.valueOf(wrapped), (int)2, (char)'0');
            ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item) + "_" + number)).parent((ModelFile)baseModel)).texture("layer0", "item/emerald_compass/emerald_compass_" + number);
            baseModel.override().predicate(EmeraldCompassItem.Companion.getANGLE(), (float)i / (float)31).model((ModelFile)model).end();
        }
        this.handledItems.add(item);
    }

    private final void goldenCompass() {
        GoldenCompassItem item = (GoldenCompassItem)((Object)ModItems.INSTANCE.getGOLDEN_COMPASS().get());
        Intrinsics.checkNotNull((Object)((Object)item));
        ItemModelBuilder baseModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", "item/golden_compass/golden_compass_00");
        for (int i = 0; i < 31; ++i) {
            int wrapped = (i + 16) % 32;
            String number = StringsKt.padStart((String)String.valueOf(wrapped), (int)2, (char)'0');
            ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName(item) + "_" + number)).parent((ModelFile)baseModel)).texture("layer0", "item/golden_compass/golden_compass_" + number);
            baseModel.override().predicate(GoldenCompassItem.Companion.getANGLE(), (float)i / (float)31).model((ModelFile)model).end();
        }
        this.handledItems.add(item);
    }

    private final void buckets() {
        EnderBucketItem enderBucket = (EnderBucketItem)((Object)ModItems.INSTANCE.getENDER_BUCKET().get());
        Intrinsics.checkNotNull((Object)((Object)enderBucket));
        String string = this.getName(enderBucket).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String enderBucketName = string;
        ItemModelBuilder enderBaseModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(enderBucketName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "item/ender_bucket/base");
        ItemModelBuilder enderFluidModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(enderBucketName + "_fluid")).parent((ModelFile)enderBaseModel)).texture("layer1", "item/ender_bucket/fluid");
        enderBaseModel.override().predicate(EnderBucketItem.Companion.getHAS_FLUID(), 1.0f).model((ModelFile)enderFluidModel).end();
        ReinforcedEnderBucketItem reinforcedEnderBucket = (ReinforcedEnderBucketItem)((Object)ModItems.INSTANCE.getREINFORCED_ENDER_BUCKET().get());
        Intrinsics.checkNotNull((Object)((Object)reinforcedEnderBucket));
        String string2 = this.getName(reinforcedEnderBucket).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String reinforcedEnderBucketName = string2;
        ItemModelBuilder reinforcedBaseModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reinforcedEnderBucketName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "item/reinforced_ender_bucket/base");
        ItemModelBuilder reinforcedFluidModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reinforcedEnderBucketName + "_fluid")).parent((ModelFile)reinforcedBaseModel)).texture("layer1", "item/reinforced_ender_bucket/fluid");
        reinforcedBaseModel.override().predicate(EnderBucketItem.Companion.getHAS_FLUID(), 1.0f).model((ModelFile)reinforcedFluidModel).end();
        this.handledItems.add(enderBucket);
        this.handledItems.add(reinforcedEnderBucket);
    }

    /*
     * WARNING - void declaration
     */
    private final void basicItems() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new DeferredItem[]{ModItems.INSTANCE.getEMERALD_COMPASS(), ModItems.INSTANCE.getENDER_BUCKET(), ModItems.INSTANCE.getREINFORCED_ENDER_BUCKET(), ModItems.INSTANCE.getREDSTONE_ACTIVATOR(), ModItems.INSTANCE.getSPECTRE_CHARGER_BASIC(), ModItems.INSTANCE.getDIVINING_ROD()};
        List complexModels = CollectionsKt.listOf((Object[])objectArray);
        DeferredItem[] deferredItemArray = new DeferredItem[]{ModItems.INSTANCE.getLOTUS_SEEDS(), ModItems.INSTANCE.getBEAN(), ModItems.INSTANCE.getLESSER_MAGIC_BEAN(), ModItems.INSTANCE.getMAGIC_BEAN()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])deferredItemArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DeferredItem deferredItem = (DeferredItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((ItemNameBlockItem)it.get());
        }
        List blockItemsToModel = (List)destination$iv$iv;
        Collection collection = ModItems.INSTANCE.getITEM_REGISTRY().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEntries(...)");
        for (DeferredHolder deferred : CollectionsKt.minus((Iterable)collection, (Iterable)CollectionsKt.toSet((Iterable)complexModels))) {
            Item item = (Item)deferred.get();
            if (this.handledItems.contains(item) || item instanceof BlockItem && !CollectionsKt.contains((Iterable)blockItemsToModel, (Object)item)) continue;
            this.basicItem(item);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handheldItems() {
        void $this$mapTo$iv$iv;
        DeferredItem[] deferredItemArray = new DeferredItem[]{ModItems.INSTANCE.getREDSTONE_TOOL(), ModItems.INSTANCE.getSPECTRE_PICKAXE(), ModItems.INSTANCE.getSPECTRE_AXE(), ModItems.INSTANCE.getSPECTRE_SWORD(), ModItems.INSTANCE.getSPECTRE_SHOVEL()};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])deferredItemArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DeferredItem deferredItem = (DeferredItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Item)it.get());
        }
        List handHeldItems = (List)destination$iv$iv;
        for (Item item : handHeldItems) {
            Intrinsics.checkNotNull((Object)item);
            ResourceLocation name = this.getName(item);
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", "item/" + name.getPath());
            this.handledItems.add(item);
        }
    }

    private final void coloredItems() {
        for (DyeColor color : EntriesMappings.entries$0) {
            Object object = GrassSeedItem.Companion.getFromColor(color);
            if (object == null || (object = (GrassSeedItem)((Object)object.get())) == null) continue;
            Object grassSeeds2 = object;
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getName((Item)grassSeeds2).toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", "item/grass_seeds")).element().allFaces((arg_0, arg_1) -> ModItemModelProvider.coloredItems$lambda$2(color, arg_0, arg_1)).end();
            this.handledItems.add((Item)grassSeeds2);
        }
    }

    private final ResourceLocation getName(Item item) {
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)item);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
        return resourceLocation;
    }

    private static final void coloredItems$lambda$2(DyeColor $color, Direction t, ModelBuilder.ElementBuilder.FaceBuilder u) {
        u.tintindex($color.getId());
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<DyeColor> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])DyeColor.values()));
        }
    }
}

