/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.entity;

import dev.aaronhowser.mods.irregular_implements.entity.WeatherCloudEntity;
import dev.aaronhowser.mods.irregular_implements.item.WeatherEggItem;
import dev.aaronhowser.mods.irregular_implements.registry.ModEntityTypes;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0014R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/ThrownWeatherEggEntity;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "shooter", "Lnet/minecraft/world/entity/LivingEntity;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V", "x", "", "y", "z", "(Lnet/minecraft/world/level/Level;DDD)V", "weather", "Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;", "getWeather", "()Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;", "setWeather", "(Ldev/aaronhowser/mods/irregular_implements/item/WeatherEggItem$Weather;)V", "onHit", "", "result", "Lnet/minecraft/world/phys/HitResult;", "onHitEntity", "Lnet/minecraft/world/phys/EntityHitResult;", "handleEntityEvent", "id", "", "getDefaultItem", "Lnet/minecraft/world/item/Item;", "irregular-implements-1.21.1"})
public final class ThrownWeatherEggEntity
extends ThrowableItemProjectile {
    @NotNull
    private WeatherEggItem.Weather weather;

    public ThrownWeatherEggEntity(@NotNull EntityType<ThrownWeatherEggEntity> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
        this.weather = WeatherEggItem.Weather.SUNNY;
    }

    public ThrownWeatherEggEntity(@NotNull Level level, @NotNull LivingEntity shooter) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
        super((EntityType)ModEntityTypes.INSTANCE.getWEATHER_EGG().get(), shooter, level);
        this.weather = WeatherEggItem.Weather.SUNNY;
    }

    public ThrownWeatherEggEntity(@NotNull Level level, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)ModEntityTypes.INSTANCE.getWEATHER_EGG().get(), x, y, z, level);
        this.weather = WeatherEggItem.Weather.SUNNY;
    }

    @NotNull
    public final WeatherEggItem.Weather getWeather() {
        return this.weather;
    }

    public final void setWeather(@NotNull WeatherEggItem.Weather weather) {
        Intrinsics.checkNotNullParameter((Object)((Object)weather), (String)"<set-?>");
        this.weather = weather;
    }

    protected void onHit(@NotNull HitResult result) {
        WeatherEggItem.Weather currentWeather;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Level level = this.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        WeatherEggItem.Weather weather = level2.isRaining() ? (level2.isThundering() ? WeatherEggItem.Weather.STORMY : WeatherEggItem.Weather.RAINY) : (currentWeather = WeatherEggItem.Weather.SUNNY);
        if (currentWeather == this.weather) {
            ItemEntity itemEntity = new ItemEntity((Level)level2, this.getX(), this.getY(), this.getZ(), this.getItem());
            level2.addFreshEntity((Entity)itemEntity);
            this.discard();
            return;
        }
        WeatherCloudEntity weatherCloud = new WeatherCloudEntity((Level)level2, this.getX(), this.getY(), this.getZ(), this.weather);
        weatherCloud.setWeather(this.weather);
        level2.addFreshEntity((Entity)weatherCloud);
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
        this.discard();
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08, (this.random.nextDouble() - 0.5) * 0.08);
            }
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        Object object = ModItems.INSTANCE.getWEATHER_EGG().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }
}

