/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/DiviningRodItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
public final class DiviningRodItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;
    @NotNull
    private static final HashMap<TagKey<Block>, Block> defaultBlockForTag;
    @JvmField
    @NotNull
    public static final Map<TagKey<Block>, Integer> COLORS_PER_TAG;

    public DiviningRodItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        TagKey tagKey = (TagKey)stack.get((Supplier)ModDataComponents.INSTANCE.getBLOCK_TAG());
        if (tagKey == null) {
            return;
        }
        TagKey blockTag = tagKey;
        Component component = Intrinsics.areEqual((Object)blockTag, (Object)Tags.Blocks.ORES) ? (Component)ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.all_ores", new Object[0]) : Companion.getNameForBlockTag((TagKey<Block>)blockTag);
        tooltipComponents.add(component);
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
        defaultBlockForTag = new HashMap();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Tags.Blocks.ORES_COAL, (Object)0x141414), TuplesKt.to((Object)Tags.Blocks.ORES_IRON, (Object)13873311), TuplesKt.to((Object)Tags.Blocks.ORES_GOLD, (Object)16181584), TuplesKt.to((Object)Tags.Blocks.ORES_LAPIS, (Object)340118), TuplesKt.to((Object)Tags.Blocks.ORES_REDSTONE, (Object)13828353), TuplesKt.to((Object)Tags.Blocks.ORES_EMERALD, (Object)56320), TuplesKt.to((Object)Tags.Blocks.ORES_DIAMOND, (Object)5758437), TuplesKt.to((Object)Tags.Blocks.ORES_COPPER, (Object)12997163), TuplesKt.to((Object)Tags.Blocks.ORES_QUARTZ, (Object)14405306), TuplesKt.to((Object)Tags.Blocks.ORES_NETHERITE_SCRAP, (Object)12019289), TuplesKt.to((Object)DiviningRodItem.Companion.oreTag("tin"), (Object)11507031), TuplesKt.to((Object)DiviningRodItem.Companion.oreTag("osmium"), (Object)4288431), TuplesKt.to((Object)DiviningRodItem.Companion.oreTag("uranium"), (Object)6214435), TuplesKt.to((Object)DiviningRodItem.Companion.oreTag("fluorite"), (Object)12870337), TuplesKt.to((Object)DiviningRodItem.Companion.oreTag("lead"), (Object)5736140)};
        COLORS_PER_TAG = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u0013J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bJ\u0014\u0010\u0019\u001a\u00020\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bJ\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R6\u0010\u0016\u001a*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b\u0012\u0004\u0012\u00020\u000f0\u0017j\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b\u0012\u0004\u0012\u00020\u000f`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u001d\u001a2\u0012(\u0012&\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u000f0\u000f \u001f*\u0012\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u000b0\u000b\u0012\u0004\u0012\u00020 0\u001e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/DiviningRodItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "getRodForItemTag", "Lnet/minecraft/world/item/ItemStack;", "itemTag", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/item/Item;", "getRodForBlockTag", "blockTag", "Lnet/minecraft/world/level/block/Block;", "getAllOreRods", "", "getAllOreTags", "", "getNameForBlockTag", "Lnet/minecraft/network/chat/Component;", "defaultBlockForTag", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getBlockForTag", "oreTag", "name", "", "COLORS_PER_TAG", "", "kotlin.jvm.PlatformType", "", "getOverlayColor", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "getItemColor", "itemStack", "tintIndex", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nDiviningRodItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiviningRodItem.kt\ndev/aaronhowser/mods/irregular_implements/item/DiviningRodItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1563#2:165\n1634#2,3:166\n*S KotlinDebug\n*F\n+ 1 DiviningRodItem.kt\ndev/aaronhowser/mods/irregular_implements/item/DiviningRodItem$Companion\n*L\n58#1:165\n58#1:166,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        @NotNull
        public final ItemStack getRodForItemTag(@NotNull TagKey<Item> itemTag) {
            Intrinsics.checkNotNullParameter(itemTag, (String)"itemTag");
            TagKey blockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)itemTag.location());
            Intrinsics.checkNotNull((Object)blockTag);
            return this.getRodForBlockTag((TagKey<Block>)blockTag);
        }

        @NotNull
        public final ItemStack getRodForBlockTag(@NotNull TagKey<Block> blockTag) {
            Intrinsics.checkNotNullParameter(blockTag, (String)"blockTag");
            ItemStack stack = ModItems.INSTANCE.getDIVINING_ROD().toStack();
            stack.set((Supplier)ModDataComponents.INSTANCE.getBLOCK_TAG(), blockTag);
            Intrinsics.checkNotNull((Object)stack);
            return stack;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ItemStack> getAllOreRods() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getAllOreTags();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TagKey tagKey = (TagKey)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.getRodForBlockTag((TagKey<Block>)it));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final Set<TagKey<Block>> getAllOreTags() {
            TagKey oresTagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ores"));
            Optional optional = BuiltInRegistries.BLOCK.getTag(oresTagKey);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTag(...)");
            HolderSet.Named named = (HolderSet.Named)OptionalsKt.getOrNull((Optional)optional);
            if (named == null) {
                return SetsKt.emptySet();
            }
            HolderSet.Named ores = named;
            Object object = new TagKey[]{oresTagKey};
            Set oreTags = SetsKt.mutableSetOf((Object[])object);
            Iterator iterator = ores.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            object = iterator;
            while (object.hasNext()) {
                Holder ore = (Holder)object.next();
                Iterator iterator2 = ore.tags().iterator();
                while (iterator2.hasNext()) {
                    TagKey tag = (TagKey)iterator2.next();
                    if (!Intrinsics.areEqual((Object)tag.location().getNamespace(), (Object)"c")) continue;
                    String string = tag.location().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"ores/", (boolean)false, (int)2, null)) continue;
                    oreTags.add(tag);
                }
            }
            return oreTags;
        }

        @NotNull
        public final Component getNameForBlockTag(@NotNull TagKey<Block> blockTag) {
            Intrinsics.checkNotNullParameter(blockTag, (String)"blockTag");
            Block firstBlock = this.getBlockForTag(blockTag);
            if (Intrinsics.areEqual((Object)firstBlock, (Object)Blocks.AIR)) {
                MutableComponent mutableComponent = Component.literal((String)blockTag.location().toString()).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.STRIKETHROUGH);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                return (Component)mutableComponent;
            }
            MutableComponent mutableComponent = firstBlock.getName().withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNull((Object)mutableComponent);
            return (Component)mutableComponent;
        }

        @NotNull
        public final Block getBlockForTag(@NotNull TagKey<Block> blockTag) {
            Intrinsics.checkNotNullParameter(blockTag, (String)"blockTag");
            Block block = defaultBlockForTag.computeIfAbsent(blockTag, arg_0 -> Companion.getBlockForTag$lambda$2(arg_0 -> Companion.getBlockForTag$lambda$1(blockTag, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"computeIfAbsent(...)");
            return block;
        }

        private final TagKey<Block> oreTag(String name) {
            TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("ores/" + name)));
            Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"create(...)");
            return tagKey;
        }

        public final int getOverlayColor(@NotNull BlockState blockState) {
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            for (Map.Entry<TagKey<Block>, Integer> entry2 : COLORS_PER_TAG.entrySet()) {
                TagKey<Block> tag = entry2.getKey();
                int color = ((Number)entry2.getValue()).intValue();
                if (!blockState.is(tag)) continue;
                return 0x32000000 | color;
            }
            return 0x32FFFFFF;
        }

        public final int getItemColor(@NotNull ItemStack itemStack, int tintIndex) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            if (tintIndex != 1) {
                return -1;
            }
            TagKey blockTag = (TagKey)itemStack.get((Supplier)ModDataComponents.INSTANCE.getBLOCK_TAG());
            if (blockTag != null) {
                Integer n = COLORS_PER_TAG.get(blockTag);
                int rgb = n != null ? n : 0xFFFFFF;
                return 0xFF000000 | rgb;
            }
            return -1;
        }

        private static final Block getBlockForTag$lambda$1(TagKey $blockTag, TagKey it) {
            Block block;
            Holder holder;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Optional optional = BuiltInRegistries.BLOCK.getTag($blockTag);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTag(...)");
            HolderSet.Named named = (HolderSet.Named)OptionalsKt.getOrNull((Optional)optional);
            return named != null && (holder = (Holder)CollectionsKt.firstOrNull((Iterable)((Iterable)named))) != null && (block = (Block)holder.value()) != null ? block : Blocks.AIR;
        }

        private static final Block getBlockForTag$lambda$2(Function1 $tmp0, Object p0) {
            return (Block)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

