/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.handler.SpectreCoilSavedData;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J.\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/SpectreChargerItem;", "Lnet/minecraft/world/item/Item;", "type", "Ldev/aaronhowser/mods/irregular_implements/item/SpectreChargerItem$Type;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Ldev/aaronhowser/mods/irregular_implements/item/SpectreChargerItem$Type;Lnet/minecraft/world/item/Item$Properties;)V", "inventoryTick", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/Entity;", "slotId", "", "isSelected", "", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "appendHoverText", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Type", "Companion", "irregular-implements-1.21.1"})
public final class SpectreChargerItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;
    public static final int CHARGE_DELAY = 5;
    @NotNull
    private static final ResourceLocation IS_ENABLED;

    public SpectreChargerItem(@NotNull Type type, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.type = type;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity player, int slotId, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!(level instanceof ServerLevel && player instanceof Player && ((ServerLevel)level).getGameTime() % (long)5 == 0L && stack.has((Supplier)ModDataComponents.INSTANCE.getIS_ENABLED()))) {
            return;
        }
        int amountToCharge = ((Number)this.type.getAmountGetter().get()).intValue() * 5;
        SpectreCoilSavedData spectreCoilSavedData = SpectreCoilSavedData.Companion.get((ServerLevel)level);
        UUID uUID = ((Player)player).getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        IEnergyStorage coil = spectreCoilSavedData.getCoil(uUID);
        Iterator iterator = ((Player)player).getInventory().items.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack inventoryStack = (ItemStack)iterator2.next();
            IEnergyStorage energyCapability = (IEnergyStorage)inventoryStack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyCapability == null || !energyCapability.canReceive()) continue;
            if (this.type == Type.GENESIS) {
                energyCapability.receiveEnergy(amountToCharge, false);
                continue;
            }
            int available = coil.extractEnergy(amountToCharge, true);
            if (available <= 0) {
                return;
            }
            int sent = energyCapability.receiveEnergy(available, false);
            coil.extractEnergy(sent, false);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack usedStack = player.getItemInHand(usedHand);
        if (OtherUtil.INSTANCE.isServerSide(level)) {
            Unit unit = usedStack.has((Supplier)ModDataComponents.INSTANCE.getIS_ENABLED()) ? (Unit)usedStack.remove((Supplier)ModDataComponents.INSTANCE.getIS_ENABLED()) : (Unit)usedStack.set((Supplier)ModDataComponents.INSTANCE.getIS_ENABLED(), (Object)Unit.INSTANCE);
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)usedStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        Integer n = this.type.getAmountGetter().get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        int amount = ((Number)n).intValue();
        Object[] objectArray = new Object[1];
        String string = "%,d";
        Object[] objectArray2 = new Object[]{amount};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
        MutableComponent component = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.charger_charges", objectArray);
        tooltipComponents.add((Component)component);
    }

    static {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        DEFAULT_PROPERTIES = properties;
        IS_ENABLED = OtherUtil.modResource("is_enabled");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/SpectreChargerItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "CHARGE_DELAY", "", "IS_ENABLED", "Lnet/minecraft/resources/ResourceLocation;", "getIS_ENABLED", "()Lnet/minecraft/resources/ResourceLocation;", "getEnabledForPredicate", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "localLevel", "Lnet/minecraft/client/multiplayer/ClientLevel;", "holdingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "int", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        @NotNull
        public final ResourceLocation getIS_ENABLED() {
            return IS_ENABLED;
        }

        public final float getEnabledForPredicate(@NotNull ItemStack stack, @Nullable ClientLevel localLevel, @Nullable LivingEntity holdingEntity, int n) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return stack.has((Supplier)ModDataComponents.INSTANCE.getIS_ENABLED()) ? 1.0f : 0.0f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/SpectreChargerItem$Type;", "", "color", "", "amountGetter", "Ljava/util/function/Supplier;", "<init>", "(Ljava/lang/String;IILjava/util/function/Supplier;)V", "getColor", "()I", "getAmountGetter", "()Ljava/util/function/Supplier;", "BASIC", "REDSTONE", "ENDER", "GENESIS", "irregular-implements-1.21.1"})
    public static final class Type
    extends Enum<Type> {
        private final int color;
        @NotNull
        private final Supplier<Integer> amountGetter;
        public static final /* enum */ Type BASIC = new Type(Color.CYAN.getRGB(), Type::_init_$lambda$0);
        public static final /* enum */ Type REDSTONE = new Type(Color.RED.getRGB(), Type::_init_$lambda$1);
        public static final /* enum */ Type ENDER = new Type(new Color(200, 0, 210).getRGB(), Type::_init_$lambda$2);
        public static final /* enum */ Type GENESIS = new Type(Color.ORANGE.getRGB(), Type::_init_$lambda$3);
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(int color, Supplier<Integer> amountGetter) {
            this.color = color;
            this.amountGetter = amountGetter;
        }

        public final int getColor() {
            return this.color;
        }

        @NotNull
        public final Supplier<Integer> getAmountGetter() {
            return this.amountGetter;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        private static final Integer _init_$lambda$0() {
            return (Integer)ServerConfig.Companion.getCONFIG().getSpectreChargerBasic().get();
        }

        private static final Integer _init_$lambda$1() {
            return (Integer)ServerConfig.Companion.getCONFIG().getSpecterChargerRedstone().get();
        }

        private static final Integer _init_$lambda$2() {
            return (Integer)ServerConfig.Companion.getCONFIG().getSpectreChargerEnder().get();
        }

        private static final Integer _init_$lambda$3() {
            return (Integer)ServerConfig.Companion.getCONFIG().getSpectreChargerGenesis().get();
        }

        static {
            $VALUES = typeArray = new Type[]{Type.BASIC, Type.REDSTONE, Type.ENDER, Type.GENESIS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

