/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.entity.SpectreIlluminatorEntity;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/SpectreIlluminatorItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "irregular-implements-1.21.1"})
public final class SpectreIlluminatorItem
extends Item {
    public SpectreIlluminatorItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Player player = context.getPlayer();
        Intrinsics.checkNotNull((Object)clickedPos);
        Intrinsics.checkNotNull((Object)level);
        if (SpectreIlluminatorEntity.Companion.isChunkIlluminated(clickedPos, (BlockAndTintGetter)level)) {
            if (OtherUtil.INSTANCE.isServerSide(level)) {
                Player player2 = player;
                if (player2 != null) {
                    player2.sendSystemMessage((Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.spectre_illuminator.already_present", new Object[0]).withStyle(ChatFormatting.RED));
                }
            }
            return InteractionResult.FAIL;
        }
        Direction clickedFace = context.getClickedFace();
        Vec3 spawnPos = clickedPos.relative(clickedFace).getCenter();
        SpectreIlluminatorEntity entity = new SpectreIlluminatorEntity(level);
        entity.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        level.addFreshEntity((Entity)entity);
        context.getItemInHand().consume(1, (LivingEntity)player);
        return InteractionResult.SUCCESS;
    }
}

