/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.recipe.crafting;

import dev.aaronhowser.mods.irregular_implements.datagen.ModRecipeProvider;
import dev.aaronhowser.mods.irregular_implements.item.DiviningRodItem;
import dev.aaronhowser.mods.irregular_implements.registry.ModRecipeSerializers;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\f\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/crafting/DiviningRodRecipe;", "Lnet/minecraft/world/item/crafting/CustomRecipe;", "craftingCategory", "Lnet/minecraft/world/item/crafting/CraftingBookCategory;", "<init>", "(Lnet/minecraft/world/item/crafting/CraftingBookCategory;)V", "matches", "", "input", "Lnet/minecraft/world/item/crafting/CraftingInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "", "height", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nDiviningRodRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiviningRodRecipe.kt\ndev/aaronhowser/mods/irregular_implements/recipe/crafting/DiviningRodRecipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1740#2,3:69\n1740#2,3:72\n1740#2,3:75\n*S KotlinDebug\n*F\n+ 1 DiviningRodRecipe.kt\ndev/aaronhowser/mods/irregular_implements/recipe/crafting/DiviningRodRecipe\n*L\n24#1:69,3\n25#1:72,3\n26#1:75,3\n*E\n"})
public final class DiviningRodRecipe
extends CustomRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<Integer> ORE_SLOTS;
    @NotNull
    private static final Set<Integer> STICK_SLOTS;
    @NotNull
    private static final Set<Integer> EYE_SLOTS;
    @NotNull
    private static final Ingredient STICKS_INGREDIENT;
    @NotNull
    private static final Ingredient EYE_INGREDIENT;

    public DiviningRodRecipe(@NotNull CraftingBookCategory craftingCategory) {
        Intrinsics.checkNotNullParameter((Object)craftingCategory, (String)"craftingCategory");
        super(craftingCategory);
    }

    public /* synthetic */ DiviningRodRecipe(CraftingBookCategory craftingBookCategory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            craftingBookCategory = CraftingBookCategory.MISC;
        }
        this(craftingBookCategory);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        boolean bl;
        boolean sticksMatch;
        boolean oresMatch;
        block13: {
            boolean bl2;
            block12: {
                boolean bl3;
                block11: {
                    Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                    Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                    TagKey tagKey = DiviningRodRecipe.Companion.getOreTag(input);
                    if (tagKey == null) {
                        return false;
                    }
                    TagKey oreTag = tagKey;
                    if (input.width() < 3 || input.height() < 3) {
                        return false;
                    }
                    Iterable $this$all$iv = ORE_SLOTS;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            int it = ((Number)element$iv).intValue();
                            boolean bl4 = false;
                            if (input.getItem(it).is(oreTag)) continue;
                            bl3 = false;
                            break block11;
                        }
                        bl3 = true;
                    }
                }
                oresMatch = bl3;
                Iterable $this$all$iv = STICK_SLOTS;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl5 = false;
                        if (STICKS_INGREDIENT.test(input.getItem(it))) continue;
                        bl2 = false;
                        break block12;
                    }
                    bl2 = true;
                }
            }
            sticksMatch = bl2;
            Iterable $this$all$iv = EYE_SLOTS;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl6 = false;
                    if (EYE_INGREDIENT.test(input.getItem(it))) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        boolean eyeMatch = bl;
        return oresMatch && sticksMatch && eyeMatch;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        TagKey tagKey = DiviningRodRecipe.Companion.getOreTag(input);
        if (tagKey == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        TagKey oreTag = tagKey;
        return DiviningRodItem.Companion.getRodForItemTag((TagKey<Item>)oreTag);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 9;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getDIVINING_ROD().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    public DiviningRodRecipe() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new Integer[]{0, 2};
        ORE_SLOTS = SetsKt.setOf((Object[])objectArray);
        objectArray = new Integer[]{1, 3, 5, 6, 8};
        STICK_SLOTS = SetsKt.setOf((Object[])objectArray);
        EYE_SLOTS = SetsKt.setOf((Object)4);
        TagKey tagKey = Tags.Items.RODS_WOODEN;
        Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"RODS_WOODEN");
        STICKS_INGREDIENT = ModRecipeProvider.Companion.asIngredient((TagKey<Item>)tagKey);
        Item item = Items.SPIDER_EYE;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"SPIDER_EYE");
        EYE_INGREDIENT = ModRecipeProvider.Companion.asIngredient((ItemLike)item);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/crafting/DiviningRodRecipe$Companion;", "", "<init>", "()V", "ORE_SLOTS", "", "", "STICK_SLOTS", "EYE_SLOTS", "STICKS_INGREDIENT", "Lnet/minecraft/world/item/crafting/Ingredient;", "getSTICKS_INGREDIENT", "()Lnet/minecraft/world/item/crafting/Ingredient;", "EYE_INGREDIENT", "getEYE_INGREDIENT", "getOreTag", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/item/Item;", "input", "Lnet/minecraft/world/item/crafting/CraftingInput;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Ingredient getSTICKS_INGREDIENT() {
            return STICKS_INGREDIENT;
        }

        @NotNull
        public final Ingredient getEYE_INGREDIENT() {
            return EYE_INGREDIENT;
        }

        private final TagKey<Item> getOreTag(CraftingInput input) {
            if (input.width() < 3 || input.height() < 3) {
                return null;
            }
            ItemStack topLeftStack = input.getItem(0);
            ItemStack topRightStack = input.getItem(2);
            Optional<Object> optional = topLeftStack.getTags().filter(arg_0 -> Companion.getOreTag$lambda$1(arg_0 -> Companion.getOreTag$lambda$0(topRightStack, arg_0), arg_0)).findFirst();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
            return (TagKey)OptionalsKt.getOrNull(optional);
        }

        private static final boolean getOreTag$lambda$0(ItemStack $topRightStack, TagKey tag) {
            String string = tag.location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return StringsKt.startsWith$default((String)string, (String)"c:ores/", (boolean)false, (int)2, null) && $topRightStack.is(tag);
        }

        private static final boolean getOreTag$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

