/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.xbartheory.worldgen.tower;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2399;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3541;
import net.minecraft.class_5819;
import net.minecraft.class_7373;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import xyz.flirora.xbartheory.worldgen.BlockPlacementBuffer;
import xyz.flirora.xbartheory.worldgen.tower.TowerInterior;

public class TowerPlacer {
    private final BlockPlacementBuffer world;
    private final class_2338 origin;
    private final class_5819 random;
    private final class_3541 thicknessModulator;
    private final TrunkConfig trunkConfig;
    private final class_3541 windowNoise;
    private final DecorationConfig decorationConfig;
    private final BlockPalette palette;
    private final TowerInterior interior;
    private static final double[] ENTRANCE_DOT_THRESHOLD = new double[]{Math.cos(Math.toRadians(10.0)), Math.cos(Math.toRadians(8.5)), Math.cos(Math.toRadians(7.0)), Math.cos(Math.toRadians(4.0))};

    public TowerPlacer(class_1937 world, class_2338 origin, class_5819 random, TrunkConfig trunkConfig, DecorationConfig decorationConfig, BlockPalette palette, TowerInterior interior) {
        this.world = new BlockPlacementBuffer(world);
        this.origin = origin;
        this.random = random;
        this.thicknessModulator = new class_3541(random);
        this.trunkConfig = trunkConfig;
        this.windowNoise = new class_3541(random);
        this.decorationConfig = decorationConfig;
        this.palette = palette;
        this.interior = interior;
    }

    public void generate() {
        this.generateTrunk();
        this.generateInterior();
        this.world.commit();
    }

    private void generateTrunk() {
        class_2338.class_2339 currentPos = this.origin.method_25503();
        double entranceAngle = Math.PI * 2 * this.random.method_43058();
        double entranceDx = Math.cos(entranceAngle);
        double entranceDz = Math.sin(entranceAngle);
        for (int dy = 0; dy < this.trunkConfig.trunkHeight; ++dy) {
            double radius = this.trunkConfig.radiusAtHeight(dy);
            int curY = this.origin.method_10264() + dy;
            currentPos.method_33098(curY);
            int range = this.trunkConfig.maxHorizontalRange(dy);
            double modifiedWindowScaleXZ = this.decorationConfig.getWindowScaleXZAtHeight(dy);
            for (int dz = -range; dz <= range; ++dz) {
                for (int dx = -range; dx <= range; ++dx) {
                    double dot;
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    boolean entrance = false;
                    if (dy < ENTRANCE_DOT_THRESHOLD.length && (dot = entranceDx * (double)dx + entranceDz * (double)dz) > ENTRANCE_DOT_THRESHOLD[dy] * distance) {
                        entrance = true;
                    }
                    double density = distance - radius + this.thicknessModulator.method_22416((double)dx * this.trunkConfig.thicknessModulationScaleXZ, (double)dy * this.trunkConfig.thicknessModulationScaleY, (double)dz * this.trunkConfig.thicknessModulationScaleXZ);
                    currentPos.method_33097(this.origin.method_10263() + dx);
                    currentPos.method_33099(this.origin.method_10260() + dz);
                    if (Math.abs(density) <= 1.0 && !entrance) {
                        double windowVal = this.windowNoise.method_22416((double)dx * modifiedWindowScaleXZ / (distance + 1.0E-5), (double)dy * this.decorationConfig.windowScaleY, (double)dz * modifiedWindowScaleXZ / (distance + 1.0E-5));
                        boolean isWindow = windowVal >= 0.5 + 0.5 * Math.exp((double)(-dy) / 40.0);
                        this.world.setBlockState((class_2338)currentPos, isWindow ? this.palette.window : this.palette.exterior);
                        if (isWindow || !(this.random.method_43058() < this.decorationConfig.lanternChance)) continue;
                        this.generateLantern(currentPos, curY);
                        continue;
                    }
                    if (!(density < 0.0)) continue;
                    this.world.setBlockState((class_2338)currentPos, this.palette.air);
                    if (dy != 0) continue;
                    currentPos.method_33098(curY - 1);
                    this.world.setBlockState((class_2338)currentPos, this.palette.bottomFloor);
                    currentPos.method_33098(curY);
                }
            }
        }
    }

    private void generateInterior() {
        this.interior.generateInterior(this.world, this.origin, this.trunkConfig, this.palette, this.random);
    }

    private void generateLantern(class_2338.class_2339 currentPos, int curY) {
        int depth;
        for (depth = 0; depth < 8; ++depth) {
            currentPos.method_33098(curY - depth - 1);
            if (currentPos.method_10264() < this.origin.method_10264() || !this.world.getBlockState((class_2338)currentPos).method_26215()) break;
        }
        if (depth > 0) {
            depth = this.random.method_39332(1, depth);
            if (this.random.method_43056()) {
                depth = this.random.method_39332(1, depth);
            }
            for (int down = 1; down < depth; ++down) {
                currentPos.method_33098(curY - down);
                this.world.setBlockState((class_2338)currentPos, this.palette.chain);
            }
            currentPos.method_33098(curY - depth);
            this.world.setBlockState((class_2338)currentPos, this.palette.lantern);
        }
        currentPos.method_33098(curY);
    }

    public record TrunkConfig(double thicknessModulationScaleXZ, double thicknessModulationScaleY, double baseRadius, double rootRadiusIncrease, int trunkHeight) {
        public double radiusAtHeight(double height) {
            return this.baseRadius + this.rootRadiusIncrease * Math.exp(-height / 32.0);
        }

        public int maxHorizontalRange(double height) {
            return (int)Math.ceil(2.0 * this.radiusAtHeight(height));
        }
    }

    public record DecorationConfig(double windowScaleXZ, double windowScaleY, double lanternChance) {
        public double getWindowScaleXZAtHeight(double height) {
            return this.windowScaleXZ * (1.0 + 0.01 * height);
        }
    }

    public record BlockPalette(class_2680 exterior, class_2680 air, class_2680 window, class_2680 chain, class_2680 lantern, class_2680 floor, class_2680 crumblingFloor, class_2680 bottomFloor, class_2680[] ladders) {
        public BlockPalette(class_2248 log, class_2248 floor, class_2248 crumblingFloor, class_2248 bottomFloor) {
            this(log.method_9564(), class_2246.field_10124.method_9564(), class_2246.field_10033.method_9564(), (class_2680)class_2246.field_23985.method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11052), (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_2741.field_16561, (Comparable)Boolean.valueOf(true)), floor.method_9564(), crumblingFloor.method_9564(), bottomFloor.method_9564(), new class_2680[]{(class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11043), (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11034), (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11035), (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)class_2350.field_11039)});
        }
    }

    public record BranchConfig(int maxDepth, double minInitialDotProduct, double minSuccessiveDotProduct, class_7373 initialBranchLength, class_7373 branchLengthDecay, class_7373 initialBranchRadius, class_7373 branchRadiusDecay) {
        public Vector3d sampleBranchingVector(Vector3dc parent, class_5819 random, boolean initial) {
            return BranchConfig.sampleBranchingVector(parent, random, initial ? this.minInitialDotProduct : this.minSuccessiveDotProduct).mul((double)this.branchLengthDecay.method_33920(random));
        }

        private static Vector3d sampleBranchingVector(Vector3dc parent, class_5819 random, double minDotProduct) {
            double r = parent.length();
            double z = random.method_43058() * (1.0 - minDotProduct) + minDotProduct;
            double uSinTheta = r * Math.sqrt(1.0 - z * z);
            double phi = random.method_43058() * (Math.PI * 2);
            double x = uSinTheta * Math.cos(phi);
            double y = uSinTheta * Math.sin(phi);
            Vector3d n1 = new Vector3d(0.0, 1.0, 0.0);
            n1.orthogonalizeUnit(parent);
            Vector3d n2 = new Vector3d();
            parent.cross((Vector3dc)n1, n2);
            n2.normalize();
            n1.mul(x);
            n2.mul(y);
            n1.add((Vector3dc)n2);
            n2.set(parent);
            n2.mul(z);
            n2.add((Vector3dc)n1);
            return n2;
        }
    }
}

