/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.xbartheory.worldgen.tower;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongLists;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.stream.LongStream;
import net.minecraft.class_2246;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3541;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableDouble;
import xyz.flirora.xbartheory.worldgen.BlockPlacementBuffer;
import xyz.flirora.xbartheory.worldgen.ConfigKeyPair;
import xyz.flirora.xbartheory.worldgen.tower.CrumblingMode;
import xyz.flirora.xbartheory.worldgen.tower.PositionPool;
import xyz.flirora.xbartheory.worldgen.tower.TowerInterior;
import xyz.flirora.xbartheory.worldgen.tower.TowerInteriorTypes;
import xyz.flirora.xbartheory.worldgen.tower.TowerPlacer;

public class ClassicTowerInterior
extends TowerInterior {
    public static final MapCodec<ClassicTowerInterior> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TowerInterior.Config.CODEC.forGetter(TowerInterior::getConfig), (App)class_6017.field_33451.fieldOf("initial_floor_separation").forGetter(i -> i.initialFloorSeparation), (App)class_6017.field_33451.fieldOf("subsequent_floor_separation").forGetter(i -> i.subsequentFloorSeparation)).apply((Applicative)instance, ClassicTowerInterior::new));
    private final class_6017 initialFloorSeparation;
    private final class_6017 subsequentFloorSeparation;

    private static void addSpawnersAndChests(BlockPlacementBuffer world, int numSpawners, int numChests, TowerInterior.Config config, double progress, PositionPool pool, int y, class_5819 random, class_2338.class_2339 pos) {
        int level;
        long p;
        int i;
        for (i = 0; i < numSpawners; ++i) {
            if (pool.isEmpty()) {
                return;
            }
            p = pool.sample(random);
            pos.method_10103(class_2265.method_42106((long)p), y, class_2265.method_42107((long)p));
            level = config.progressFractionToLevel(progress, random);
            ConfigKeyPair trialConfigs = (ConfigKeyPair)config.levels().get(level).trialSpawners().method_66216(random);
            world.addTrialSpawner((class_2338)pos, trialConfigs);
        }
        for (i = 0; i < numChests; ++i) {
            if (pool.isEmpty()) {
                return;
            }
            p = pool.sample(random);
            pos.method_10103(class_2265.method_42106((long)p), y, class_2265.method_42107((long)p));
            level = config.progressFractionToLevel(progress, random);
            class_5321 lootTable = (class_5321)config.levels().get(level).lootTables().method_66216(random);
            world.addChest((class_2338)pos, (class_5321<class_52>)lootTable, random);
        }
    }

    public ClassicTowerInterior(TowerInterior.Config config, class_6017 initialFloorSeparation, class_6017 subsequentFloorSeparation) {
        super(TowerInteriorTypes.CLASSIC, config);
        this.initialFloorSeparation = initialFloorSeparation;
        this.subsequentFloorSeparation = subsequentFloorSeparation;
    }

    private FloorType sampleFloorType(class_5819 random) {
        return switch (random.method_43048(50)) {
            case 0, 1, 2, 3, 4, 5 -> SpawnerFloorType.INSTANCE;
            case 6, 7, 8, 9 -> MazeFloorType.INSTANCE;
            case 10, 11, 12 -> RegularFloorType.INSTANCE_FLOODED;
            case 13, 14 -> MineFloorType.INSTANCE;
            case 15 -> LavaFloorType.INSTANCE;
            default -> RegularFloorType.INSTANCE;
        };
    }

    @Override
    public void generateInterior(BlockPlacementBuffer world, class_2338 origin, TowerPlacer.TrunkConfig trunkConfig, TowerPlacer.BlockPalette palette, class_5819 random) {
        IntArrayList floorLevels = new IntArrayList();
        for (int y = this.initialFloorSeparation.method_35008(random); y < trunkConfig.trunkHeight(); y += this.subsequentFloorSeparation.method_35008(random)) {
            floorLevels.add(y);
        }
        ArrayList<Floor> floors = new ArrayList<Floor>();
        for (int floor = 0; floor < floorLevels.size(); ++floor) {
            int dy = floorLevels.getInt(floor);
            int range = trunkConfig.maxHorizontalRange(dy);
            Floor f = this.generateLayer(world, origin, (IntList)floorLevels, floor, dy, range, palette, random);
            if (floor > 0) {
                ((Floor)floors.getLast()).laddersUp = f.laddersDown;
            }
            floors.add(f);
        }
        for (Floor floor : floors) {
            floor.floorType.generate(world, floor, random, palette, origin);
        }
    }

    private Floor generateLayer(BlockPlacementBuffer world, class_2338 origin, IntList floorLevels, int floor, int dy, int range, TowerPlacer.BlockPalette palette, class_5819 random) {
        boolean last = floor == floorLevels.size() - 1;
        double progress = (double)(floor - 1) / (double)(floorLevels.size() - 2);
        class_2338.class_2339 currentPos = origin.method_25503();
        int curY = origin.method_10264() + dy;
        int height = floor == floorLevels.size() - 1 ? world.getMaxY() - dy : floorLevels.getInt(floor + 1) - dy;
        Floor result = new Floor(curY, height, progress, last ? BossFloorType.INSTANCE : this.sampleFloorType(random));
        currentPos.method_33098(curY);
        for (int dz = -range; dz <= range; ++dz) {
            for (int dx = -range; dx <= range; ++dx) {
                currentPos.method_33097(origin.method_10263() + dx);
                currentPos.method_33099(origin.method_10260() + dz);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                class_2680 floorBlock = palette.floor();
                world.setBlockState((class_2338)currentPos, floorBlock);
                currentPos.method_33098(curY + 1);
                if (world.getBlockState((class_2338)currentPos).method_26215()) {
                    result.floorColumnPosSet.add(class_2265.method_34874((int)currentPos.method_10263(), (int)currentPos.method_10260()));
                }
                currentPos.method_33098(curY);
            }
        }
        int MAX_ATTEMPTS = 100;
        int laddersWanted = 1;
        if (random.method_43048(20) == 0) {
            ++laddersWanted;
        }
        if (random.method_43048(20) == 0) {
            ++laddersWanted;
        }
        int laddersBuilt = 0;
        int prevFloorLevel = floor == 0 ? -1 : floorLevels.getInt(floor - 1);
        for (int attempt = 0; attempt <= 100; ++attempt) {
            int z;
            int dx = random.method_39332(-((range + 1) / 2), (range + 1) / 2);
            int dz = random.method_39332(-((range + 1) / 2), (range + 1) / 2);
            int x = origin.method_10263() + dx;
            if (!result.floorColumnPosSet.contains(class_2265.method_34874((int)x, (int)(z = origin.method_10260() + dz))) || result.floorType.rejectLadderOffset(dx, dz)) continue;
            if (attempt < 100) {
                currentPos.method_33098(origin.method_10264() + prevFloorLevel + 1);
                currentPos.method_33097(x);
                currentPos.method_33099(z);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                currentPos.method_33099(z - 1);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                currentPos.method_33099(z + 1);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                currentPos.method_33097(x - 1);
                currentPos.method_33099(z);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                currentPos.method_33097(x + 1);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                currentPos.method_33098(curY + 1);
                currentPos.method_33097(x);
                currentPos.method_33099(z - 1);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                currentPos.method_33099(z + 1);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                currentPos.method_33097(x - 1);
                currentPos.method_33099(z);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                currentPos.method_33097(x + 1);
                if (world.getExplicitBlockState((class_2338)currentPos) != palette.air()) {
                    continue;
                }
            } else if (laddersBuilt > 0) break;
            result.laddersDown.add(class_2265.method_34874((int)x, (int)z));
            for (int y = origin.method_10264() + prevFloorLevel + 1; y <= curY; ++y) {
                currentPos.method_10103(x, y, z);
                world.setBlockState((class_2338)currentPos, palette.exterior());
                currentPos.method_10103(x, y, z - 1);
                if (y == curY || world.getExplicitBlockState((class_2338)currentPos) == palette.air()) {
                    world.setBlockState((class_2338)currentPos, palette.ladders()[0]);
                }
                currentPos.method_10103(x + 1, y, z);
                if (y == curY || world.getExplicitBlockState((class_2338)currentPos) == palette.air()) {
                    world.setBlockState((class_2338)currentPos, palette.ladders()[1]);
                }
                currentPos.method_10103(x, y, z + 1);
                if (y == curY || world.getExplicitBlockState((class_2338)currentPos) == palette.air()) {
                    world.setBlockState((class_2338)currentPos, palette.ladders()[2]);
                }
                currentPos.method_10103(x - 1, y, z);
                if (y != curY && world.getExplicitBlockState((class_2338)currentPos) != palette.air()) continue;
                world.setBlockState((class_2338)currentPos, palette.ladders()[3]);
            }
            if (++laddersBuilt >= laddersWanted) break;
        }
        return result;
    }

    private record SpawnerFloorType() implements FloorType
    {
        public static final SpawnerFloorType INSTANCE = new SpawnerFloorType();

        @Override
        public void generate(BlockPlacementBuffer world, Floor floor, class_5819 random, TowerPlacer.BlockPalette palette, class_2338 origin) {
            TowerInterior.Config config = floor.getConfig();
            class_2338.class_2339 pos = new class_2338.class_2339();
            floor.cutout();
            PositionPool floorColumnPos = new PositionPool((LongCollection)floor.floorColumnPosSet);
            int numSpawners = 0;
            for (int i = 0; i < 3; ++i) {
                numSpawners += random.method_39332(1, 3);
            }
            ClassicTowerInterior.addSpawnersAndChests(world, numSpawners, 0, config, floor.progress, floorColumnPos, floor.y + 1, random, pos);
        }
    }

    private record MazeFloorType() implements FloorType
    {
        public static MazeFloorType INSTANCE = new MazeFloorType();
        private static final long MASK = 0x100000001L;

        @Override
        public void generate(BlockPlacementBuffer world, Floor floor, class_5819 random, TowerPlacer.BlockPalette palette, class_2338 origin) {
            TowerInterior.Config config = floor.getConfig();
            class_2338.class_2339 currentPos = new class_2338.class_2339();
            long requestedParity = random.method_43055() & 0x100000001L;
            LongOpenHashSet nodes = LongOpenHashSet.toSet((LongStream)floor.floorColumnPosSet.longStream().filter(pos -> (pos & 0x100000001L) == requestedParity));
            floor.forEachLadderPos(arg_0 -> MazeFloorType.lambda$generate$1(requestedParity, random, (LongSet)nodes, arg_0));
            int i = random.method_43048(nodes.size());
            LongIterator it = nodes.longIterator();
            it.skip(i);
            long startNode = it.nextLong();
            floor.cutout();
            floor.floorColumnPosSet.remove(startNode);
            nodes.remove(startNode);
            LongArrayList nodeStack = new LongArrayList();
            nodeStack.push(startNode);
            LongArrayList directions = new LongArrayList(4);
            while (!nodeStack.isEmpty()) {
                directions.clear();
                long nodePos = nodeStack.popLong();
                if (nodes.contains(nodePos - 2L)) {
                    directions.add(-1L);
                }
                if (nodes.contains(nodePos + 2L)) {
                    directions.add(1L);
                }
                if (nodes.contains(nodePos - 0x200000000L)) {
                    directions.add(-4294967296L);
                }
                if (nodes.contains(nodePos + 0x200000000L)) {
                    directions.add(0x100000000L);
                }
                if (directions.isEmpty()) continue;
                nodeStack.push(nodePos);
                long selectedDirection = directions.getLong(random.method_43048(directions.size()));
                long neighbor = nodePos + 2L * selectedDirection;
                floor.floorColumnPosSet.remove(nodePos + selectedDirection);
                floor.floorColumnPosSet.remove(neighbor);
                nodes.remove(neighbor);
                nodeStack.push(neighbor);
                if (random.method_43048(128) != 0) continue;
                int xx = class_2265.method_42106((long)neighbor);
                int zz = class_2265.method_42107((long)neighbor);
                int xMin = xx - random.method_39332(1, 2);
                int xMax = xx + random.method_39332(1, 2);
                int zMin = zz - random.method_39332(1, 2);
                int zMax = zz + random.method_39332(1, 2);
                for (int x = xMin; x <= xMax; ++x) {
                    for (int z = zMin; z <= zMax; ++z) {
                        floor.floorColumnPosSet.remove(class_2265.method_34874((int)x, (int)z));
                        currentPos.method_10103(class_2265.method_42106((long)neighbor), floor.y + 1, class_2265.method_42107((long)neighbor));
                        int level = config.progressFractionToLevel(floor.progress, random);
                        ConfigKeyPair trialConfigs = (ConfigKeyPair)config.levels().get(level).trialSpawners().method_66216(random);
                        world.addTrialSpawner((class_2338)currentPos, trialConfigs);
                    }
                }
            }
            floor.floorColumnPosSet.forEach(packedPos -> {
                int level;
                currentPos.method_10103(class_2265.method_42106((long)packedPos), floor.y + 1, class_2265.method_42107((long)packedPos));
                if (random.method_43048(64) == 0) {
                    level = config.progressFractionToLevel(floor.progress, random);
                    ConfigKeyPair trialConfigs = (ConfigKeyPair)config.levels().get(level).trialSpawners().method_66216(random);
                    world.addTrialSpawner((class_2338)currentPos, trialConfigs);
                } else {
                    world.setBlockState((class_2338)currentPos, palette.floor());
                }
                currentPos.method_33098(floor.y + 2);
                if (random.method_43048(128) < 3) {
                    level = config.progressFractionToLevel(floor.progress, random);
                    class_5321 lootTable = (class_5321)config.levels().get(level).lootTables().method_66216(random);
                    world.addChest((class_2338)currentPos, (class_5321<class_52>)lootTable, random);
                } else {
                    world.setBlockState((class_2338)currentPos, palette.floor());
                }
            });
        }

        @Override
        public CrumblingMode getCrumblingMode() {
            return CrumblingMode.NO_AIR;
        }

        private static /* synthetic */ void lambda$generate$1(long requestedParity, class_5819 random, LongSet nodes, long pos) {
            long parityDiff = pos & 0x100000001L ^ requestedParity;
            if (parityDiff != 0L) {
                if (parityDiff == 1L) {
                    long delendum = random.method_43056() ? pos - 1L : pos + 1L;
                    nodes.remove(delendum);
                } else if (parityDiff == 0x100000000L) {
                    long delendum = random.method_43056() ? pos - 0x100000000L : pos + 0x100000000L;
                    nodes.remove(delendum);
                } else if (parityDiff == 0x100000001L) {
                    long delendum = pos + (long)(random.method_43056() ? -1 : 1) + (random.method_43056() ? -4294967296L : 0x100000000L);
                    nodes.remove(delendum);
                } else {
                    throw new AssertionError((Object)"parityDiff is wrong; everything is wrong; crash and burn everything");
                }
            }
        }
    }

    private record RegularFloorType(boolean flood) implements FloorType
    {
        public static final RegularFloorType INSTANCE = new RegularFloorType(false);
        public static final RegularFloorType INSTANCE_FLOODED = new RegularFloorType(true);

        @Override
        public void generate(BlockPlacementBuffer world, Floor floor, class_5819 random, TowerPlacer.BlockPalette palette, class_2338 origin) {
            TowerInterior.Config config = floor.getConfig();
            class_2338.class_2339 pos = new class_2338.class_2339();
            LongOpenHashSet floorOrig = this.flood ? new LongOpenHashSet((LongCollection)floor.floorColumnPosSet) : null;
            floor.cutout();
            PositionPool floorColumnPos = new PositionPool((LongCollection)floor.floorColumnPosSet);
            int numSpawners = random.method_39332(1, 3) + random.method_39332(0, 1);
            int numChests = random.method_39332(1, 4) + random.method_39332(0, 3);
            ClassicTowerInterior.addSpawnersAndChests(world, numSpawners, numChests, config, floor.progress, floorColumnPos, floor.y + 1, random, pos);
            if (this.flood) {
                floorOrig.forEach(packedPos -> {
                    pos.method_10103(class_2265.method_42106((long)packedPos), floor.y + 1, class_2265.method_42107((long)packedPos));
                    class_2680 blockState = world.getBlockState((class_2338)pos);
                    class_2680 waterloggedBlockState = blockState.method_26215() ? class_2246.field_10382.method_9564() : (class_2680)blockState.method_47968((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
                    world.setBlockState((class_2338)pos, waterloggedBlockState);
                    if (waterloggedBlockState != blockState && random.method_43048(16) == 0) {
                        pos.method_33098(floor.y + 2);
                        world.setBlockState((class_2338)pos, class_2246.field_10588.method_9564());
                    } else if (waterloggedBlockState.method_27852(class_2246.field_10382)) {
                        boolean setFloor = true;
                        switch (random.method_43048(64)) {
                            case 0: {
                                world.setBlockState((class_2338)pos, (class_2680)((class_2680)class_2246.field_28682.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.class_2353.field_11062.method_10183(random))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)));
                                break;
                            }
                            case 1: {
                                class_2350 facing = class_2350.class_2353.field_11062.method_10183(random);
                                world.setBlockState((class_2338)pos, (class_2680)((class_2680)class_2246.field_28683.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)));
                                pos.method_33098(floor.y + 2);
                                world.setBlockState((class_2338)pos, (class_2680)class_2246.field_28682.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing));
                                break;
                            }
                            case 2: {
                                class_2350 facing = class_2350.class_2353.field_11062.method_10183(random);
                                world.setBlockState((class_2338)pos, (class_2680)((class_2680)((class_2680)class_2246.field_28684.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing)).method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12607)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)));
                                pos.method_33098(floor.y + 2);
                                world.setBlockState((class_2338)pos, (class_2680)((class_2680)class_2246.field_28684.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)facing)).method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609));
                                break;
                            }
                            default: {
                                setFloor = false;
                            }
                        }
                        if (setFloor) {
                            pos.method_33098(floor.y);
                            world.setBlockState((class_2338)pos, class_2246.field_10460.method_9564());
                        }
                    }
                });
            }
        }

        @Override
        public CrumblingMode getCrumblingMode() {
            return this.flood ? CrumblingMode.NO_AIR : CrumblingMode.ALL;
        }
    }

    private record MineFloorType() implements FloorType
    {
        public static MineFloorType INSTANCE = new MineFloorType();

        @Override
        public void generate(BlockPlacementBuffer world, Floor floor, class_5819 random, TowerPlacer.BlockPalette palette, class_2338 origin) {
            TowerInterior.Config config = floor.getConfig();
            class_2338.class_2339 currentPos = new class_2338.class_2339();
            class_3541 blockHeightNoise = new class_3541(random);
            double scaling = 0.18181818181818182;
            double exponent = 1.0 + 0.5 * floor.progress;
            floor.floorColumnPosSet.forEach(packedPos -> {
                int x = class_2265.method_42106((long)packedPos);
                int z = class_2265.method_42107((long)packedPos);
                double noise = blockHeightNoise.method_15433(scaling * (double)(x - origin.method_10263()), scaling * (double)(z - origin.method_10260()));
                noise = Math.max(0.0, noise + 0.5);
                noise = Math.pow(noise, 0.73);
                MutableDouble noiseValue = new MutableDouble(noise);
                floor.forEachLadderPos(ladderPos -> {
                    int distX = x - class_2265.method_42106((long)ladderPos);
                    int distZ = z - class_2265.method_42107((long)ladderPos);
                    double d = Math.sqrt(distX * distX + distZ * distZ);
                    d = Math.max(d - 1.0, 0.0);
                    noiseValue.setValue(noiseValue.doubleValue() * d / (d + 1.0));
                });
                int numStoneBlocks = Math.toIntExact(Math.min(Math.round(noiseValue.doubleValue() * 4.0), (long)(floor.height - 1)));
                currentPos.method_10103(x, 0, z);
                for (int i = 0; i < numStoneBlocks; ++i) {
                    currentPos.method_33098(floor.y + 1 + i);
                    if (i == 0 && random.method_43048(64) == 0) {
                        int level = config.progressFractionToLevel(floor.progress, random);
                        class_5321 lootTable = (class_5321)config.levels().get(level).lootTables().method_66216(random);
                        world.addBarrel((class_2338)currentPos, (class_5321<class_52>)lootTable, random);
                        continue;
                    }
                    if (i == numStoneBlocks - 1 && random.method_43048(64) == 0) {
                        int level = config.progressFractionToLevel(floor.progress, random);
                        ConfigKeyPair trialConfigs = (ConfigKeyPair)config.levels().get(level).trialSpawners().method_66216(random);
                        world.addTrialSpawner((class_2338)currentPos, trialConfigs);
                        continue;
                    }
                    double roll = Math.pow(random.method_43058(), exponent);
                    class_2680 state = roll < 0.001 ? class_2246.field_10442.method_9564() : (roll < 0.002 ? class_2246.field_10013.method_9564() : (roll < 0.01 ? class_2246.field_10571.method_9564() : (roll < 0.02 ? class_2246.field_10080.method_9564() : (roll < 0.045 ? class_2246.field_10212.method_9564() : (roll < 0.065 ? class_2246.field_27120.method_9564() : (roll < 0.1 ? class_2246.field_10418.method_9564() : class_2246.field_10340.method_9564()))))));
                    world.setBlockState((class_2338)currentPos, state);
                }
            });
        }

        @Override
        public CrumblingMode getCrumblingMode() {
            return CrumblingMode.NO_AIR;
        }
    }

    private record LavaFloorType() implements FloorType
    {
        public static LavaFloorType INSTANCE = new LavaFloorType();

        @Override
        public void generate(BlockPlacementBuffer world, Floor floor, class_5819 random, TowerPlacer.BlockPalette palette, class_2338 origin) {
            TowerInterior.Config config = floor.getConfig();
            class_2338.class_2339 currentPos = new class_2338.class_2339();
            class_3541 lavaNoiseSampler = new class_3541(random);
            class_3541 blackstoneNoiseSampler = new class_3541(random);
            double lavaScaling = 0.18181818181818182;
            double blackstoneScaling = 0.35842293906810035;
            double exponent = 0.8 - 0.3 * floor.progress;
            PositionPool floorPositions = new PositionPool();
            floor.floorColumnPosSet.forEach(packedPos -> {
                int x = class_2265.method_42106((long)packedPos);
                int z = class_2265.method_42107((long)packedPos);
                currentPos.method_10103(x, floor.y + 1, z);
                double lavaNoise = lavaNoiseSampler.method_15433(lavaScaling * (double)(x - origin.method_10263()), lavaScaling * (double)(z - origin.method_10260()));
                lavaNoise = Math.max(0.0, lavaNoise + 0.2);
                lavaNoise = Math.pow(lavaNoise, exponent);
                MutableDouble noiseValue = new MutableDouble(lavaNoise);
                floor.forEachLadderPos(ladderPos -> {
                    int distX = x - class_2265.method_42106((long)ladderPos);
                    int distZ = z - class_2265.method_42107((long)ladderPos);
                    double d = Math.sqrt(distX * distX + distZ * distZ);
                    d = Math.max(d - 1.0, 0.0);
                    noiseValue.setValue(noiseValue.doubleValue() * d / (d + 1.0));
                });
                MutableBoolean cancelPlacement = new MutableBoolean(false);
                if (cancelPlacement.isTrue()) {
                    return;
                }
                if (lavaNoise > 0.7) {
                    world.setBlockState((class_2338)currentPos, class_2246.field_10164.method_9564());
                } else {
                    double blackstoneNoise = blackstoneNoiseSampler.method_15433(blackstoneScaling * (double)(x - origin.method_10263()), blackstoneScaling * (double)(z - origin.method_10260()));
                    world.setBlockState((class_2338)currentPos, blackstoneNoise > 0.0 ? class_2246.field_23869.method_9564() : (class_2680)class_2246.field_22091.method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.method_16699((class_5819)random)));
                    floorPositions.add(packedPos);
                }
            });
            floor.laddersDown.forEach(ladderPos -> {
                int x = class_2265.method_42106((long)ladderPos);
                int z = class_2265.method_42107((long)ladderPos);
                floorPositions.removeIf(p -> Math.abs(class_2265.method_42106((long)p) - x) <= 1 && Math.abs(class_2265.method_42107((long)p) - z) <= 1);
                currentPos.method_10103(x, floor.y + 1, z);
                world.setBlockState((class_2338)currentPos, palette.exterior());
                currentPos.method_10103(x, floor.y + 1, z - 1);
                world.setBlockState((class_2338)currentPos, palette.ladders()[0]);
                currentPos.method_10103(x + 1, floor.y + 1, z);
                world.setBlockState((class_2338)currentPos, palette.ladders()[1]);
                currentPos.method_10103(x, floor.y + 1, z + 1);
                world.setBlockState((class_2338)currentPos, palette.ladders()[2]);
                currentPos.method_10103(x - 1, floor.y + 1, z);
                world.setBlockState((class_2338)currentPos, palette.ladders()[3]);
            });
            int numSpawners = random.method_39332(1, 2);
            int numChests = random.method_39332(1, 3);
            ClassicTowerInterior.addSpawnersAndChests(world, numSpawners, numChests, config, floor.progress, floorPositions, floor.y + 2, random, currentPos);
        }

        @Override
        public CrumblingMode getCrumblingMode() {
            return CrumblingMode.NONE;
        }
    }

    private class Floor {
        public int y;
        public int height;
        public LongSet floorColumnPosSet;
        public LongList laddersDown;
        public LongList laddersUp;
        public double progress;
        public FloorType floorType;

        public Floor(int y, int height, double progress, FloorType floorType) {
            this.y = y;
            this.height = height;
            this.floorColumnPosSet = new LongOpenHashSet();
            this.laddersDown = new LongArrayList();
            this.laddersUp = LongLists.EMPTY_LIST;
            this.progress = progress;
            this.floorType = floorType;
        }

        private void cutout(long packed) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    this.floorColumnPosSet.remove(packed + ((long)dx << 32) + (long)dz);
                }
            }
        }

        public void forEachLadderPos(LongConsumer consumer) {
            this.laddersDown.forEach(consumer);
            this.laddersUp.forEach(consumer);
        }

        public void cutout() {
            this.forEachLadderPos(this::cutout);
        }

        public TowerInterior.Config getConfig() {
            return ClassicTowerInterior.this.config;
        }
    }

    private static interface FloorType {
        public void generate(BlockPlacementBuffer var1, Floor var2, class_5819 var3, TowerPlacer.BlockPalette var4, class_2338 var5);

        default public CrumblingMode getCrumblingMode() {
            return CrumblingMode.ALL;
        }

        default public boolean rejectLadderOffset(int dx, int dz) {
            return false;
        }
    }

    private record BossFloorType() implements FloorType
    {
        public static final BossFloorType INSTANCE = new BossFloorType();

        @Override
        public void generate(BlockPlacementBuffer world, Floor floor, class_5819 random, TowerPlacer.BlockPalette palette, class_2338 origin) {
            TowerInterior.Config config = floor.getConfig();
            TowerInterior.Config.Level bossLevel = config.bossLevel();
            int x = origin.method_10263();
            int y = floor.y + 1;
            int z = origin.method_10260();
            class_2338.class_2339 currentPos = new class_2338.class_2339(x, y, z);
            world.addTrialSpawner((class_2338)currentPos, (ConfigKeyPair)bossLevel.trialSpawners().method_66216(random));
            currentPos.method_10103(x - 3, y, z);
            world.addChest((class_2338)currentPos, (class_5321<class_52>)((class_5321)bossLevel.lootTables().method_66216(random)), random, class_2350.field_11034);
            currentPos.method_10103(x + 3, y, z);
            world.addChest((class_2338)currentPos, (class_5321<class_52>)((class_5321)bossLevel.lootTables().method_66216(random)), random, class_2350.field_11039);
            currentPos.method_10103(x, y, z - 3);
            world.addChest((class_2338)currentPos, (class_5321<class_52>)((class_5321)bossLevel.lootTables().method_66216(random)), random, class_2350.field_11035);
            currentPos.method_10103(x, y, z + 3);
            world.addChest((class_2338)currentPos, (class_5321<class_52>)((class_5321)bossLevel.lootTables().method_66216(random)), random, class_2350.field_11043);
        }

        @Override
        public boolean rejectLadderOffset(int dx, int dz) {
            return Math.abs(dx) <= 1 || Math.abs(dz) <= 1;
        }
    }
}

