/*
 * Decompiled with CFR 0.152.
 */
package xyz.flirora.xbartheory.worldgen.tower;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6012;
import net.minecraft.class_7924;
import xyz.flirora.xbartheory.worldgen.BlockPlacementBuffer;
import xyz.flirora.xbartheory.worldgen.ConfigKeyPair;
import xyz.flirora.xbartheory.worldgen.tower.TowerInteriorType;
import xyz.flirora.xbartheory.worldgen.tower.TowerPlacer;

public abstract class TowerInterior {
    public static final Codec<TowerInterior> CODEC = TowerInteriorType.REGISTRY.method_39673().dispatch("type", TowerInterior::getType, TowerInteriorType::codec);
    protected final TowerInteriorType<?> type;
    protected final Config config;

    protected TowerInterior(TowerInteriorType<?> type, Config config) {
        this.type = type;
        this.config = config;
    }

    public TowerInteriorType<?> getType() {
        return this.type;
    }

    public Config getConfig() {
        return this.config;
    }

    public abstract void generateInterior(BlockPlacementBuffer var1, class_2338 var2, TowerPlacer.TrunkConfig var3, TowerPlacer.BlockPalette var4, class_5819 var5);

    public record Config(List<Level> levels, Level bossLevel) {
        public static final MapCodec<Config> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Level.LIST_CODEC.fieldOf("levels").forGetter(Config::levels), (App)Level.CODEC.fieldOf("boss_level").forGetter(Config::bossLevel)).apply((Applicative)instance, Config::new));

        public int progressFractionToLevel(double progress, class_5819 random) {
            int result = 0;
            for (int i = 0; i < this.levels.size() - 1; ++i) {
                if (!(random.method_43058() < progress)) continue;
                ++result;
            }
            return result;
        }

        public record Level(class_6012<ConfigKeyPair> trialSpawners, class_6012<class_5321<class_52>> lootTables) {
            public static final Codec<Level> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6012.method_66217(ConfigKeyPair.CODEC).fieldOf("trial_spawners").forGetter(Level::trialSpawners), (App)class_6012.method_66217((Codec)class_5321.method_39154((class_5321)class_7924.field_50079)).fieldOf("loot_tables").forGetter(Level::lootTables)).apply((Applicative)instance, Level::new));
            public static final Codec<List<Level>> LIST_CODEC = class_5699.method_36973((Codec)CODEC.listOf());
        }
    }
}

